/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.afm;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.StringTokenizer;
import org.apache.fontbox.afm.CharMetric;
import org.apache.fontbox.afm.Composite;
import org.apache.fontbox.afm.CompositePart;
import org.apache.fontbox.afm.FontMetrics;
import org.apache.fontbox.afm.KernPair;
import org.apache.fontbox.afm.Ligature;
import org.apache.fontbox.afm.TrackKern;
import org.apache.fontbox.util.BoundingBox;

public class AFMParser {
    public static final String COMMENT = "Comment";
    public static final String START_FONT_METRICS = "StartFontMetrics";
    public static final String END_FONT_METRICS = "EndFontMetrics";
    public static final String FONT_NAME = "FontName";
    public static final String FULL_NAME = "FullName";
    public static final String FAMILY_NAME = "FamilyName";
    public static final String WEIGHT = "Weight";
    public static final String FONT_BBOX = "FontBBox";
    public static final String VERSION = "Version";
    public static final String NOTICE = "Notice";
    public static final String ENCODING_SCHEME = "EncodingScheme";
    public static final String MAPPING_SCHEME = "MappingScheme";
    public static final String ESC_CHAR = "EscChar";
    public static final String CHARACTER_SET = "CharacterSet";
    public static final String CHARACTERS = "Characters";
    public static final String IS_BASE_FONT = "IsBaseFont";
    public static final String V_VECTOR = "VVector";
    public static final String IS_FIXED_V = "IsFixedV";
    public static final String CAP_HEIGHT = "CapHeight";
    public static final String X_HEIGHT = "XHeight";
    public static final String ASCENDER = "Ascender";
    public static final String DESCENDER = "Descender";
    public static final String UNDERLINE_POSITION = "UnderlinePosition";
    public static final String UNDERLINE_THICKNESS = "UnderlineThickness";
    public static final String ITALIC_ANGLE = "ItalicAngle";
    public static final String CHAR_WIDTH = "CharWidth";
    public static final String IS_FIXED_PITCH = "IsFixedPitch";
    public static final String START_CHAR_METRICS = "StartCharMetrics";
    public static final String END_CHAR_METRICS = "EndCharMetrics";
    public static final String CHARMETRICS_C = "C";
    public static final String CHARMETRICS_CH = "CH";
    public static final String CHARMETRICS_WX = "WX";
    public static final String CHARMETRICS_W0X = "W0X";
    public static final String CHARMETRICS_W1X = "W1X";
    public static final String CHARMETRICS_WY = "WY";
    public static final String CHARMETRICS_W0Y = "W0Y";
    public static final String CHARMETRICS_W1Y = "W1Y";
    public static final String CHARMETRICS_W = "W";
    public static final String CHARMETRICS_W0 = "W0";
    public static final String CHARMETRICS_W1 = "W1";
    public static final String CHARMETRICS_VV = "VV";
    public static final String CHARMETRICS_N = "N";
    public static final String CHARMETRICS_B = "B";
    public static final String CHARMETRICS_L = "L";
    public static final String STD_HW = "StdHW";
    public static final String STD_VW = "StdVW";
    public static final String START_TRACK_KERN = "StartTrackKern";
    public static final String END_TRACK_KERN = "EndTrackKern";
    public static final String START_KERN_DATA = "StartKernData";
    public static final String END_KERN_DATA = "EndKernData";
    public static final String START_KERN_PAIRS = "StartKernPairs";
    public static final String END_KERN_PAIRS = "EndKernPairs";
    public static final String START_KERN_PAIRS0 = "StartKernPairs0";
    public static final String START_KERN_PAIRS1 = "StartKernPairs1";
    public static final String START_COMPOSITES = "StartComposites";
    public static final String END_COMPOSITES = "EndComposites";
    public static final String CC = "CC";
    public static final String PCC = "PCC";
    public static final String KERN_PAIR_KP = "KP";
    public static final String KERN_PAIR_KPH = "KPH";
    public static final String KERN_PAIR_KPX = "KPX";
    public static final String KERN_PAIR_KPY = "KPY";
    private static final int BITS_IN_HEX = 16;
    private final InputStream input;

    public AFMParser(InputStream in) {
        this.input = in;
    }

    public FontMetrics parse() throws IOException {
        return this.parseFontMetric(false);
    }

    public FontMetrics parse(boolean reducedDataset) throws IOException {
        return this.parseFontMetric(reducedDataset);
    }

    private FontMetrics parseFontMetric(boolean reducedDataset) throws IOException {
        String nextCommand;
        this.readCommand(START_FONT_METRICS);
        FontMetrics fontMetrics = new FontMetrics();
        fontMetrics.setAFMVersion(this.readFloat());
        boolean charMetricsRead = false;
        block64: while (!END_FONT_METRICS.equals(nextCommand = this.readString())) {
            switch (nextCommand) {
                case "FontName": {
                    fontMetrics.setFontName(this.readLine());
                    continue block64;
                }
                case "FullName": {
                    fontMetrics.setFullName(this.readLine());
                    continue block64;
                }
                case "FamilyName": {
                    fontMetrics.setFamilyName(this.readLine());
                    continue block64;
                }
                case "Weight": {
                    fontMetrics.setWeight(this.readLine());
                    continue block64;
                }
                case "FontBBox": {
                    BoundingBox bBox = new BoundingBox();
                    bBox.setLowerLeftX(this.readFloat());
                    bBox.setLowerLeftY(this.readFloat());
                    bBox.setUpperRightX(this.readFloat());
                    bBox.setUpperRightY(this.readFloat());
                    fontMetrics.setFontBBox(bBox);
                    continue block64;
                }
                case "Version": {
                    fontMetrics.setFontVersion(this.readLine());
                    continue block64;
                }
                case "Notice": {
                    fontMetrics.setNotice(this.readLine());
                    continue block64;
                }
                case "EncodingScheme": {
                    fontMetrics.setEncodingScheme(this.readLine());
                    continue block64;
                }
                case "MappingScheme": {
                    fontMetrics.setMappingScheme(this.readInt());
                    continue block64;
                }
                case "EscChar": {
                    fontMetrics.setEscChar(this.readInt());
                    continue block64;
                }
                case "CharacterSet": {
                    fontMetrics.setCharacterSet(this.readLine());
                    continue block64;
                }
                case "Characters": {
                    fontMetrics.setCharacters(this.readInt());
                    continue block64;
                }
                case "IsBaseFont": {
                    fontMetrics.setIsBaseFont(this.readBoolean());
                    continue block64;
                }
                case "VVector": {
                    float[] vector = new float[]{this.readFloat(), this.readFloat()};
                    fontMetrics.setVVector(vector);
                    continue block64;
                }
                case "IsFixedV": {
                    fontMetrics.setIsFixedV(this.readBoolean());
                    continue block64;
                }
                case "CapHeight": {
                    fontMetrics.setCapHeight(this.readFloat());
                    continue block64;
                }
                case "XHeight": {
                    fontMetrics.setXHeight(this.readFloat());
                    continue block64;
                }
                case "Ascender": {
                    fontMetrics.setAscender(this.readFloat());
                    continue block64;
                }
                case "Descender": {
                    fontMetrics.setDescender(this.readFloat());
                    continue block64;
                }
                case "StdHW": {
                    fontMetrics.setStandardHorizontalWidth(this.readFloat());
                    continue block64;
                }
                case "StdVW": {
                    fontMetrics.setStandardVerticalWidth(this.readFloat());
                    continue block64;
                }
                case "Comment": {
                    fontMetrics.addComment(this.readLine());
                    continue block64;
                }
                case "UnderlinePosition": {
                    fontMetrics.setUnderlinePosition(this.readFloat());
                    continue block64;
                }
                case "UnderlineThickness": {
                    fontMetrics.setUnderlineThickness(this.readFloat());
                    continue block64;
                }
                case "ItalicAngle": {
                    fontMetrics.setItalicAngle(this.readFloat());
                    continue block64;
                }
                case "CharWidth": {
                    float[] widths = new float[]{this.readFloat(), this.readFloat()};
                    fontMetrics.setCharWidth(widths);
                    continue block64;
                }
                case "IsFixedPitch": {
                    fontMetrics.setFixedPitch(this.readBoolean());
                    continue block64;
                }
                case "StartCharMetrics": {
                    charMetricsRead = this.parseCharMetrics(fontMetrics);
                    continue block64;
                }
                case "StartKernData": {
                    if (reducedDataset) continue block64;
                    this.parseKernData(fontMetrics);
                    continue block64;
                }
                case "StartComposites": {
                    if (reducedDataset) continue block64;
                    this.parseComposites(fontMetrics);
                    continue block64;
                }
            }
            if (reducedDataset && charMetricsRead) continue;
            throw new IOException("Unknown AFM key '" + nextCommand + "'");
        }
        return fontMetrics;
    }

    private void parseKernData(FontMetrics fontMetrics) throws IOException {
        String nextCommand;
        block12: while (!(nextCommand = this.readString()).equals(END_KERN_DATA)) {
            switch (nextCommand) {
                case "StartTrackKern": {
                    int countTrackKern = this.readInt();
                    for (int i2 = 0; i2 < countTrackKern; ++i2) {
                        fontMetrics.addTrackKern(new TrackKern(this.readInt(), this.readFloat(), this.readFloat(), this.readFloat(), this.readFloat()));
                    }
                    this.readCommand(END_TRACK_KERN);
                    continue block12;
                }
                case "StartKernPairs": {
                    this.parseKernPairs(fontMetrics);
                    continue block12;
                }
                case "StartKernPairs0": {
                    this.parseKernPairs0(fontMetrics);
                    continue block12;
                }
                case "StartKernPairs1": {
                    this.parseKernPairs1(fontMetrics);
                    continue block12;
                }
            }
            throw new IOException("Unknown kerning data type '" + nextCommand + "'");
        }
    }

    private void parseKernPairs(FontMetrics fontMetrics) throws IOException {
        int countKernPairs = this.readInt();
        for (int i2 = 0; i2 < countKernPairs; ++i2) {
            fontMetrics.addKernPair(this.parseKernPair());
        }
        this.readCommand(END_KERN_PAIRS);
    }

    private void parseKernPairs0(FontMetrics fontMetrics) throws IOException {
        int countKernPairs = this.readInt();
        for (int i2 = 0; i2 < countKernPairs; ++i2) {
            fontMetrics.addKernPair0(this.parseKernPair());
        }
        this.readCommand(END_KERN_PAIRS);
    }

    private void parseKernPairs1(FontMetrics fontMetrics) throws IOException {
        int countKernPairs = this.readInt();
        for (int i2 = 0; i2 < countKernPairs; ++i2) {
            fontMetrics.addKernPair1(this.parseKernPair());
        }
        this.readCommand(END_KERN_PAIRS);
    }

    private KernPair parseKernPair() throws IOException {
        String cmd;
        switch (cmd = this.readString()) {
            case "KP": {
                return new KernPair(this.readString(), this.readString(), this.readFloat(), this.readFloat());
            }
            case "KPH": {
                return new KernPair(this.hexToString(this.readString()), this.hexToString(this.readString()), this.readFloat(), this.readFloat());
            }
            case "KPX": {
                return new KernPair(this.readString(), this.readString(), this.readFloat(), 0.0f);
            }
            case "KPY": {
                return new KernPair(this.readString(), this.readString(), 0.0f, this.readFloat());
            }
        }
        throw new IOException("Error expected kern pair command actual='" + cmd + "'");
    }

    private String hexToString(String hexToString) throws IOException {
        if (hexToString.length() < 2) {
            throw new IOException("Error: Expected hex string of length >= 2 not='" + hexToString);
        }
        if (hexToString.charAt(0) != '<' || hexToString.charAt(hexToString.length() - 1) != '>') {
            throw new IOException("String should be enclosed by angle brackets '" + hexToString + "'");
        }
        String hexString = hexToString.substring(1, hexToString.length() - 1);
        byte[] data = new byte[hexString.length() / 2];
        for (int i2 = 0; i2 < hexString.length(); i2 += 2) {
            String hex = Character.toString(hexString.charAt(i2)) + hexString.charAt(i2 + 1);
            data[i2 / 2] = (byte)this.parseInt(hex, 16);
        }
        return new String(data, StandardCharsets.ISO_8859_1);
    }

    private void parseComposites(FontMetrics fontMetrics) throws IOException {
        int countComposites = this.readInt();
        for (int i2 = 0; i2 < countComposites; ++i2) {
            fontMetrics.addComposite(this.parseComposite());
        }
        this.readCommand(END_COMPOSITES);
    }

    private Composite parseComposite() throws IOException {
        String partData = this.readLine();
        StringTokenizer tokenizer = new StringTokenizer(partData, " ;");
        String cc = tokenizer.nextToken();
        if (!cc.equals(CC)) {
            throw new IOException("Expected 'CC' actual='" + cc + "'");
        }
        String name = tokenizer.nextToken();
        Composite composite = new Composite(name);
        int partCount = this.parseInt(tokenizer.nextToken());
        for (int i2 = 0; i2 < partCount; ++i2) {
            String pcc = tokenizer.nextToken();
            if (!pcc.equals(PCC)) {
                throw new IOException("Expected 'PCC' actual='" + pcc + "'");
            }
            String partName = tokenizer.nextToken();
            int x = this.parseInt(tokenizer.nextToken());
            int y = this.parseInt(tokenizer.nextToken());
            composite.addPart(new CompositePart(partName, x, y));
        }
        return composite;
    }

    private boolean parseCharMetrics(FontMetrics fontMetrics) throws IOException {
        int countMetrics = this.readInt();
        for (int i2 = 0; i2 < countMetrics; ++i2) {
            fontMetrics.addCharMetric(this.parseCharMetric());
        }
        this.readCommand(END_CHAR_METRICS);
        return true;
    }

    private CharMetric parseCharMetric() throws IOException {
        CharMetric charMetric = new CharMetric();
        String metrics = this.readLine();
        StringTokenizer metricsTokenizer = new StringTokenizer(metrics);
        block34: while (metricsTokenizer.hasMoreTokens()) {
            String nextCommand;
            switch (nextCommand = metricsTokenizer.nextToken()) {
                case "C": {
                    String charCodeC = metricsTokenizer.nextToken();
                    charMetric.setCharacterCode(this.parseInt(charCodeC));
                    this.verifySemicolon(metricsTokenizer);
                    continue block34;
                }
                case "CH": {
                    String charCodeCH = metricsTokenizer.nextToken();
                    charMetric.setCharacterCode(this.parseInt(charCodeCH, 16));
                    this.verifySemicolon(metricsTokenizer);
                    continue block34;
                }
                case "WX": {
                    charMetric.setWx(this.parseFloat(metricsTokenizer.nextToken()));
                    this.verifySemicolon(metricsTokenizer);
                    continue block34;
                }
                case "W0X": {
                    charMetric.setW0x(this.parseFloat(metricsTokenizer.nextToken()));
                    this.verifySemicolon(metricsTokenizer);
                    continue block34;
                }
                case "W1X": {
                    charMetric.setW1x(this.parseFloat(metricsTokenizer.nextToken()));
                    this.verifySemicolon(metricsTokenizer);
                    continue block34;
                }
                case "WY": {
                    charMetric.setWy(this.parseFloat(metricsTokenizer.nextToken()));
                    this.verifySemicolon(metricsTokenizer);
                    continue block34;
                }
                case "W0Y": {
                    charMetric.setW0y(this.parseFloat(metricsTokenizer.nextToken()));
                    this.verifySemicolon(metricsTokenizer);
                    continue block34;
                }
                case "W1Y": {
                    charMetric.setW1y(this.parseFloat(metricsTokenizer.nextToken()));
                    this.verifySemicolon(metricsTokenizer);
                    continue block34;
                }
                case "W": {
                    float[] w = new float[]{this.parseFloat(metricsTokenizer.nextToken()), this.parseFloat(metricsTokenizer.nextToken())};
                    charMetric.setW(w);
                    this.verifySemicolon(metricsTokenizer);
                    continue block34;
                }
                case "W0": {
                    float[] w0 = new float[]{this.parseFloat(metricsTokenizer.nextToken()), this.parseFloat(metricsTokenizer.nextToken())};
                    charMetric.setW0(w0);
                    this.verifySemicolon(metricsTokenizer);
                    continue block34;
                }
                case "W1": {
                    float[] w1 = new float[]{this.parseFloat(metricsTokenizer.nextToken()), this.parseFloat(metricsTokenizer.nextToken())};
                    charMetric.setW1(w1);
                    this.verifySemicolon(metricsTokenizer);
                    continue block34;
                }
                case "VV": {
                    float[] vv = new float[]{this.parseFloat(metricsTokenizer.nextToken()), this.parseFloat(metricsTokenizer.nextToken())};
                    charMetric.setVv(vv);
                    this.verifySemicolon(metricsTokenizer);
                    continue block34;
                }
                case "N": {
                    charMetric.setName(metricsTokenizer.nextToken());
                    this.verifySemicolon(metricsTokenizer);
                    continue block34;
                }
                case "B": {
                    BoundingBox box = new BoundingBox();
                    box.setLowerLeftX(this.parseFloat(metricsTokenizer.nextToken()));
                    box.setLowerLeftY(this.parseFloat(metricsTokenizer.nextToken()));
                    box.setUpperRightX(this.parseFloat(metricsTokenizer.nextToken()));
                    box.setUpperRightY(this.parseFloat(metricsTokenizer.nextToken()));
                    charMetric.setBoundingBox(box);
                    this.verifySemicolon(metricsTokenizer);
                    continue block34;
                }
                case "L": {
                    Ligature lig = new Ligature(metricsTokenizer.nextToken(), metricsTokenizer.nextToken());
                    charMetric.addLigature(lig);
                    this.verifySemicolon(metricsTokenizer);
                    continue block34;
                }
            }
            throw new IOException("Unknown CharMetrics command '" + nextCommand + "'");
        }
        return charMetric;
    }

    private void verifySemicolon(StringTokenizer tokenizer) throws IOException {
        if (tokenizer.hasMoreTokens()) {
            String semicolon = tokenizer.nextToken();
            if (!";".equals(semicolon)) {
                throw new IOException("Error: Expected semicolon in stream actual='" + semicolon + "'");
            }
        } else {
            throw new IOException("CharMetrics is missing a semicolon after a command");
        }
    }

    private boolean readBoolean() throws IOException {
        return Boolean.parseBoolean(this.readString());
    }

    private int readInt() throws IOException {
        return this.parseInt(this.readString(), 10);
    }

    private int parseInt(String intValue) throws IOException {
        return this.parseInt(intValue, 10);
    }

    private int parseInt(String intValue, int radix) throws IOException {
        try {
            return Integer.parseInt(intValue, radix);
        }
        catch (NumberFormatException e2) {
            throw new IOException("Error parsing AFM document:" + e2, e2);
        }
    }

    private float readFloat() throws IOException {
        return this.parseFloat(this.readString());
    }

    private float parseFloat(String floatValue) throws IOException {
        try {
            return Float.parseFloat(floatValue);
        }
        catch (NumberFormatException e2) {
            throw new IOException("Error parsing AFM document:" + e2, e2);
        }
    }

    private String readLine() throws IOException {
        StringBuilder buf = new StringBuilder(60);
        int nextByte = this.input.read();
        while (AFMParser.isWhitespace(nextByte)) {
            nextByte = this.input.read();
        }
        buf.append((char)nextByte);
        nextByte = this.input.read();
        while (nextByte != -1 && !AFMParser.isEOL(nextByte)) {
            buf.append((char)nextByte);
            nextByte = this.input.read();
        }
        return buf.toString();
    }

    private String readString() throws IOException {
        StringBuilder buf = new StringBuilder(24);
        int nextByte = this.input.read();
        while (AFMParser.isWhitespace(nextByte)) {
            nextByte = this.input.read();
        }
        buf.append((char)nextByte);
        nextByte = this.input.read();
        while (nextByte != -1 && !AFMParser.isWhitespace(nextByte)) {
            buf.append((char)nextByte);
            nextByte = this.input.read();
        }
        return buf.toString();
    }

    private void readCommand(String expectedCommand) throws IOException {
        String command = this.readString();
        if (!expectedCommand.equals(command)) {
            throw new IOException("Error: Expected '" + expectedCommand + "' actual '" + command + "'");
        }
    }

    private static boolean isEOL(int character) {
        return character == 13 || character == 10;
    }

    private static boolean isWhitespace(int character) {
        switch (character) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                return true;
            }
        }
        return false;
    }
}

