/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.cff;

import java.io.IOException;
import org.apache.fontbox.cff.DataInput;
import org.apache.pdfbox.io.RandomAccessRead;

public class DataInputRandomAccessRead
implements DataInput {
    private final RandomAccessRead randomAccessRead;

    public DataInputRandomAccessRead(RandomAccessRead randomAccessRead) {
        this.randomAccessRead = randomAccessRead;
    }

    @Override
    public boolean hasRemaining() throws IOException {
        return this.randomAccessRead.available() > 0;
    }

    @Override
    public int getPosition() throws IOException {
        return (int)this.randomAccessRead.getPosition();
    }

    @Override
    public void setPosition(int position) throws IOException {
        if (position < 0) {
            throw new IOException("position is negative");
        }
        if ((long)position >= this.randomAccessRead.length()) {
            throw new IOException("New position is out of range " + position + " >= " + this.randomAccessRead.length());
        }
        this.randomAccessRead.seek(position);
    }

    @Override
    public byte readByte() throws IOException {
        if (!this.hasRemaining()) {
            throw new IOException("End of buffer reached!");
        }
        return (byte)this.randomAccessRead.read();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        if (!this.hasRemaining()) {
            throw new IOException("End of buffer reached!");
        }
        return this.randomAccessRead.read();
    }

    @Override
    public int peekUnsignedByte(int offset) throws IOException {
        if (offset < 0) {
            throw new IOException("offset is negative");
        }
        if (offset == 0) {
            return this.randomAccessRead.peek();
        }
        long currentPosition = this.randomAccessRead.getPosition();
        if (currentPosition + (long)offset >= this.randomAccessRead.length()) {
            throw new IOException("Offset position is out of range " + (currentPosition + (long)offset) + " >= " + this.randomAccessRead.length());
        }
        this.randomAccessRead.seek(currentPosition + (long)offset);
        int peekValue = this.randomAccessRead.read();
        this.randomAccessRead.seek(currentPosition);
        return peekValue;
    }

    @Override
    public byte[] readBytes(int length) throws IOException {
        if (length < 0) {
            throw new IOException("length is negative");
        }
        if (this.randomAccessRead.length() - this.randomAccessRead.getPosition() < (long)length) {
            throw new IOException("Premature end of buffer reached");
        }
        byte[] bytes = new byte[length];
        for (int i2 = 0; i2 < length; ++i2) {
            bytes[i2] = this.readByte();
        }
        return bytes;
    }

    @Override
    public int length() throws IOException {
        return (int)this.randomAccessRead.length();
    }
}

