/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fontbox.ttf.TTFDataStream;
import org.apache.fontbox.ttf.TTFTable;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.fontbox.ttf.WGL4Names;

public class PostScriptTable
extends TTFTable {
    private static final Log LOG = LogFactory.getLog(PostScriptTable.class);
    private float formatType;
    private float italicAngle;
    private short underlinePosition;
    private short underlineThickness;
    private long isFixedPitch;
    private long minMemType42;
    private long maxMemType42;
    private long mimMemType1;
    private long maxMemType1;
    private String[] glyphNames = null;
    public static final String TAG = "post";

    PostScriptTable() {
    }

    @Override
    void read(TrueTypeFont ttf, TTFDataStream data) throws IOException {
        this.formatType = data.read32Fixed();
        this.italicAngle = data.read32Fixed();
        this.underlinePosition = data.readSignedShort();
        this.underlineThickness = data.readSignedShort();
        this.isFixedPitch = data.readUnsignedInt();
        this.minMemType42 = data.readUnsignedInt();
        this.maxMemType42 = data.readUnsignedInt();
        this.mimMemType1 = data.readUnsignedInt();
        this.maxMemType1 = data.readUnsignedInt();
        if (data.getCurrentPosition() == data.getOriginalDataSize()) {
            LOG.warn("No PostScript name data is provided for the font " + ttf.getName());
        } else if (Float.compare(this.formatType, 1.0f) == 0) {
            this.glyphNames = WGL4Names.getAllNames();
        } else if (Float.compare(this.formatType, 2.0f) == 0) {
            int i2;
            int numGlyphs = data.readUnsignedShort();
            int[] glyphNameIndex = new int[numGlyphs];
            this.glyphNames = new String[numGlyphs];
            int maxIndex = Integer.MIN_VALUE;
            for (int i3 = 0; i3 < numGlyphs; ++i3) {
                int index;
                glyphNameIndex[i3] = index = data.readUnsignedShort();
                if (index > Short.MAX_VALUE) continue;
                maxIndex = Math.max(maxIndex, index);
            }
            String[] nameArray = null;
            if (maxIndex >= 258) {
                nameArray = new String[maxIndex - 258 + 1];
                for (i2 = 0; i2 < nameArray.length; ++i2) {
                    int numberOfChars = data.readUnsignedByte();
                    try {
                        nameArray[i2] = data.readString(numberOfChars);
                        continue;
                    }
                    catch (IOException ex) {
                        LOG.warn("Error reading names in PostScript table at entry " + i2 + " of " + nameArray.length + ", setting remaining entries to .notdef", ex);
                        for (int j2 = i2; j2 < nameArray.length; ++j2) {
                            nameArray[j2] = ".notdef";
                        }
                        break;
                    }
                }
            }
            for (i2 = 0; i2 < numGlyphs; ++i2) {
                int index = glyphNameIndex[i2];
                this.glyphNames[i2] = index >= 0 && index < 258 ? WGL4Names.getGlyphName(index) : (index >= 258 && index <= Short.MAX_VALUE && nameArray != null ? nameArray[index - 258] : ".undefined");
            }
        } else if (Float.compare(this.formatType, 2.5f) == 0) {
            int i4;
            int[] glyphNameIndex = new int[ttf.getNumberOfGlyphs()];
            for (i4 = 0; i4 < glyphNameIndex.length; ++i4) {
                int offset = data.readSignedByte();
                glyphNameIndex[i4] = i4 + 1 + offset;
            }
            this.glyphNames = new String[glyphNameIndex.length];
            for (i4 = 0; i4 < this.glyphNames.length; ++i4) {
                int index = glyphNameIndex[i4];
                if (index >= 0 && index < 258) {
                    String name = WGL4Names.getGlyphName(index);
                    if (name == null) continue;
                    this.glyphNames[i4] = name;
                    continue;
                }
                LOG.debug("incorrect glyph name index " + index + ", valid numbers 0.." + 258);
            }
        } else if (Float.compare(this.formatType, 3.0f) == 0) {
            LOG.debug("No PostScript name information is provided for the font " + ttf.getName());
        }
        this.initialized = true;
    }

    public float getFormatType() {
        return this.formatType;
    }

    public void setFormatType(float formatTypeValue) {
        this.formatType = formatTypeValue;
    }

    public long getIsFixedPitch() {
        return this.isFixedPitch;
    }

    public void setIsFixedPitch(long isFixedPitchValue) {
        this.isFixedPitch = isFixedPitchValue;
    }

    public float getItalicAngle() {
        return this.italicAngle;
    }

    public void setItalicAngle(float italicAngleValue) {
        this.italicAngle = italicAngleValue;
    }

    public long getMaxMemType1() {
        return this.maxMemType1;
    }

    public void setMaxMemType1(long maxMemType1Value) {
        this.maxMemType1 = maxMemType1Value;
    }

    public long getMaxMemType42() {
        return this.maxMemType42;
    }

    public void setMaxMemType42(long maxMemType42Value) {
        this.maxMemType42 = maxMemType42Value;
    }

    public long getMinMemType1() {
        return this.mimMemType1;
    }

    public void setMimMemType1(long mimMemType1Value) {
        this.mimMemType1 = mimMemType1Value;
    }

    public long getMinMemType42() {
        return this.minMemType42;
    }

    public void setMinMemType42(long minMemType42Value) {
        this.minMemType42 = minMemType42Value;
    }

    public short getUnderlinePosition() {
        return this.underlinePosition;
    }

    public void setUnderlinePosition(short underlinePositionValue) {
        this.underlinePosition = underlinePositionValue;
    }

    public short getUnderlineThickness() {
        return this.underlineThickness;
    }

    public void setUnderlineThickness(short underlineThicknessValue) {
        this.underlineThickness = underlineThicknessValue;
    }

    public String[] getGlyphNames() {
        return this.glyphNames;
    }

    public void setGlyphNames(String[] glyphNamesValue) {
        this.glyphNames = glyphNamesValue;
    }

    public String getName(int gid) {
        if (gid < 0 || this.glyphNames == null || gid >= this.glyphNames.length) {
            return null;
        }
        return this.glyphNames[gid];
    }
}

