/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.cos;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.filter.Filter;
import org.apache.pdfbox.io.RandomAccess;
import org.apache.pdfbox.io.RandomAccessInputStream;
import org.apache.pdfbox.io.RandomAccessOutputStream;
import org.apache.pdfbox.io.RandomAccessStreamCache;

public final class COSOutputStream
extends FilterOutputStream {
    private final List<Filter> filters;
    private final COSDictionary parameters;
    private final RandomAccessStreamCache streamCache;
    private RandomAccess buffer;

    COSOutputStream(List<Filter> filters, COSDictionary parameters, OutputStream output, RandomAccessStreamCache streamCache) throws IOException {
        super(output);
        this.filters = filters;
        this.parameters = parameters;
        this.streamCache = streamCache;
        this.buffer = filters.isEmpty() ? null : streamCache.createBuffer();
    }

    @Override
    public void write(byte[] b2) throws IOException {
        this.write(b2, 0, b2.length);
    }

    @Override
    public void write(byte[] b2, int off, int len) throws IOException {
        if (this.buffer != null) {
            this.buffer.write(b2, off, len);
        } else {
            super.write(b2, off, len);
        }
    }

    @Override
    public void write(int b2) throws IOException {
        if (this.buffer != null) {
            this.buffer.write(b2);
        } else {
            super.write(b2);
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.buffer == null) {
            super.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() throws IOException {
        try {
            if (this.buffer == null) return;
            try {
                int i2 = this.filters.size() - 1;
                while (i2 >= 0) {
                    block35: {
                        try (RandomAccessInputStream unfilteredIn = new RandomAccessInputStream(this.buffer);){
                            if (i2 == 0) {
                                this.filters.get(i2).encode(unfilteredIn, this.out, this.parameters, i2);
                                break block35;
                            }
                            RandomAccess filteredBuffer = this.streamCache.createBuffer();
                            try (RandomAccessOutputStream filteredOut = new RandomAccessOutputStream(filteredBuffer);){
                                this.filters.get(i2).encode(unfilteredIn, filteredOut, this.parameters, i2);
                            }
                            finally {
                                this.buffer.close();
                                this.buffer = filteredBuffer;
                            }
                        }
                    }
                    --i2;
                }
                return;
            }
            finally {
                this.buffer.close();
                this.buffer = null;
            }
        }
        finally {
            super.close();
        }
    }
}

