/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.io;

import java.io.IOException;
import org.apache.pdfbox.io.RandomAccess;
import org.apache.pdfbox.io.RandomAccessReadBuffer;

public class RandomAccessReadWriteBuffer
extends RandomAccessReadBuffer
implements RandomAccess {
    public RandomAccessReadWriteBuffer() {
    }

    public RandomAccessReadWriteBuffer(int definedChunkSize) {
        super(definedChunkSize);
    }

    @Override
    public void clear() throws IOException {
        this.checkClosed();
        this.resetBuffers();
    }

    @Override
    public void write(int b2) throws IOException {
        this.checkClosed();
        if (this.chunkSize - this.currentBufferPointer <= 0) {
            this.expandBuffer();
        }
        this.currentBuffer.put((byte)b2);
        ++this.currentBufferPointer;
        ++this.pointer;
        if (this.pointer > this.size) {
            this.size = this.pointer;
        }
    }

    @Override
    public void write(byte[] b2) throws IOException {
        this.write(b2, 0, b2.length);
    }

    @Override
    public void write(byte[] b2, int off, int len) throws IOException {
        int bytesToWrite;
        this.checkClosed();
        int bOff = off;
        for (int remain = len; remain > 0; remain -= bytesToWrite) {
            bytesToWrite = Math.min(remain, this.chunkSize - this.currentBufferPointer);
            if (bytesToWrite <= 0) {
                this.expandBuffer();
                bytesToWrite = Math.min(remain, this.chunkSize - this.currentBufferPointer);
            }
            if (bytesToWrite > 0) {
                this.currentBuffer.put(b2, bOff, bytesToWrite);
                this.currentBufferPointer += bytesToWrite;
                this.pointer += (long)bytesToWrite;
            }
            bOff += bytesToWrite;
        }
        if (this.pointer > this.size) {
            this.size = this.pointer;
        }
    }
}

