/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.pdmodel.PDStructureElementNameTreeNode;
import org.apache.pdfbox.pdmodel.common.COSDictionaryMap;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDNameTreeNode;
import org.apache.pdfbox.pdmodel.common.PDNumberTreeNode;
import org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDAttributeObject;
import org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDParentTreeValue;
import org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDStructureElement;
import org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDStructureNode;

public class PDStructureTreeRoot
extends PDStructureNode {
    private static final Log LOG = LogFactory.getLog(PDStructureTreeRoot.class);
    private static final String TYPE = "StructTreeRoot";

    public PDStructureTreeRoot() {
        super(TYPE);
    }

    public PDStructureTreeRoot(COSDictionary dic) {
        super(dic);
    }

    public COSBase getK() {
        return this.getCOSObject().getDictionaryObject(COSName.K);
    }

    public void setK(COSBase k2) {
        this.getCOSObject().setItem(COSName.K, k2);
    }

    public PDNameTreeNode<PDStructureElement> getIDTree() {
        COSDictionary idTree = this.getCOSObject().getCOSDictionary(COSName.ID_TREE);
        return idTree != null ? new PDStructureElementNameTreeNode(idTree) : null;
    }

    public void setIDTree(PDNameTreeNode<PDStructureElement> idTree) {
        this.getCOSObject().setItem(COSName.ID_TREE, idTree);
    }

    public PDNumberTreeNode getParentTree() {
        COSDictionary parentTree = this.getCOSObject().getCOSDictionary(COSName.PARENT_TREE);
        return parentTree != null ? new PDNumberTreeNode(parentTree, PDParentTreeValue.class) : null;
    }

    public void setParentTree(PDNumberTreeNode parentTree) {
        this.getCOSObject().setItem(COSName.PARENT_TREE, (COSObjectable)parentTree);
    }

    public int getParentTreeNextKey() {
        return this.getCOSObject().getInt(COSName.PARENT_TREE_NEXT_KEY);
    }

    public void setParentTreeNextKey(int parentTreeNextkey) {
        this.getCOSObject().setInt(COSName.PARENT_TREE_NEXT_KEY, parentTreeNextkey);
    }

    public Map<String, Object> getRoleMap() {
        COSDictionary rm = this.getCOSObject().getCOSDictionary(COSName.ROLE_MAP);
        if (rm != null) {
            try {
                return COSDictionaryMap.convertBasicTypesToMap(rm);
            }
            catch (IOException e2) {
                LOG.error(e2, e2);
            }
        }
        return new HashMap<String, Object>();
    }

    public void setRoleMap(Map<String, String> roleMap) {
        COSDictionary rmDic = new COSDictionary();
        roleMap.forEach(rmDic::setName);
        this.getCOSObject().setItem(COSName.ROLE_MAP, (COSBase)rmDic);
    }

    public Map<String, Object> getClassMap() {
        HashMap<String, Object> classMap = new HashMap<String, Object>();
        COSDictionary classMapDictionary = this.getCOSObject().getCOSDictionary(COSName.CLASS_MAP);
        if (classMapDictionary == null) {
            return classMap;
        }
        classMapDictionary.forEach((name, base) -> {
            if (base instanceof COSObject) {
                base = ((COSObject)base).getObject();
            }
            if (base instanceof COSDictionary) {
                classMap.put(name.getName(), PDAttributeObject.create((COSDictionary)base));
            } else if (base instanceof COSArray) {
                COSArray array = (COSArray)base;
                ArrayList<PDAttributeObject> list = new ArrayList<PDAttributeObject>();
                for (int i2 = 0; i2 < array.size(); ++i2) {
                    COSBase base2 = array.getObject(i2);
                    if (!(base2 instanceof COSDictionary)) continue;
                    list.add(PDAttributeObject.create((COSDictionary)base2));
                }
                classMap.put(name.getName(), list);
            }
        });
        return classMap;
    }

    public void setClassMap(Map<String, Object> classMap) {
        if (classMap == null || classMap.isEmpty()) {
            this.getCOSObject().removeItem(COSName.CLASS_MAP);
            return;
        }
        COSDictionary classMapDictionary = new COSDictionary();
        classMap.forEach((name, object) -> {
            if (object instanceof PDAttributeObject) {
                classMapDictionary.setItem((String)name, (COSBase)((PDAttributeObject)object).getCOSObject());
            } else if (object instanceof List) {
                classMapDictionary.setItem((String)name, (COSBase)new COSArray((List)object));
            }
        });
        this.getCOSObject().setItem(COSName.CLASS_MAP, (COSBase)classMapDictionary);
    }
}

