/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.interactive.form;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSString;

public final class FieldUtils {
    static final Comparator<KeyValue> BY_VALUE_COMPARATOR = Comparator.comparing(KeyValue::getValue);
    static final Comparator<KeyValue> BY_KEY_COMPARATOR = Comparator.comparing(KeyValue::getKey);

    private FieldUtils() {
    }

    static List<KeyValue> toKeyValueList(List<String> key, List<String> value) {
        ArrayList<KeyValue> list = new ArrayList<KeyValue>(key.size());
        for (int i2 = 0; i2 < key.size(); ++i2) {
            list.add(new KeyValue(key.get(i2), value.get(i2)));
        }
        return list;
    }

    static void sortByValue(List<KeyValue> pairs) {
        pairs.sort(BY_VALUE_COMPARATOR);
    }

    static void sortByKey(List<KeyValue> pairs) {
        pairs.sort(BY_KEY_COMPARATOR);
    }

    static List<String> getPairableItems(COSBase items, int pairIdx) {
        if (pairIdx < 0 || pairIdx > 1) {
            throw new IllegalArgumentException("Only 0 and 1 are allowed as an index into two-element arrays");
        }
        if (items instanceof COSString) {
            ArrayList<String> array = new ArrayList<String>(1);
            array.add(((COSString)items).getString());
            return array;
        }
        if (items instanceof COSArray) {
            ArrayList<String> entryList = new ArrayList<String>();
            for (COSBase entry : (COSArray)items) {
                COSArray cosArray;
                if (entry instanceof COSString) {
                    entryList.add(((COSString)entry).getString());
                    continue;
                }
                if (!(entry instanceof COSArray) || (cosArray = (COSArray)entry).size() < pairIdx + 1 || !(cosArray.get(pairIdx) instanceof COSString)) continue;
                entryList.add(((COSString)cosArray.get(pairIdx)).getString());
            }
            return entryList;
        }
        return Collections.emptyList();
    }

    static class KeyValue {
        private final String key;
        private final String value;

        KeyValue(String theKey, String theValue) {
            this.key = theKey;
            this.value = theValue;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return "(" + this.key + ", " + this.value + ")";
        }
    }
}

