/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.interactive.measurement;

import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.interactive.measurement.PDMeasureDictionary;
import org.apache.pdfbox.pdmodel.interactive.measurement.PDNumberFormatDictionary;

public class PDRectlinearMeasureDictionary
extends PDMeasureDictionary {
    public static final String SUBTYPE = "RL";

    public PDRectlinearMeasureDictionary() {
        this.setSubtype(SUBTYPE);
    }

    public PDRectlinearMeasureDictionary(COSDictionary dictionary) {
        super(dictionary);
    }

    public String getScaleRatio() {
        return this.getCOSObject().getString(COSName.R);
    }

    public void setScaleRatio(String scaleRatio) {
        this.getCOSObject().setString(COSName.R, scaleRatio);
    }

    public PDNumberFormatDictionary[] getChangeXs() {
        COSArray x = this.getCOSObject().getCOSArray(COSName.X);
        if (x != null) {
            PDNumberFormatDictionary[] retval = new PDNumberFormatDictionary[x.size()];
            for (int i2 = 0; i2 < x.size(); ++i2) {
                COSDictionary dic = (COSDictionary)x.get(i2);
                retval[i2] = new PDNumberFormatDictionary(dic);
            }
            return retval;
        }
        return null;
    }

    public void setChangeXs(PDNumberFormatDictionary[] changeXs) {
        COSArray array = new COSArray();
        for (PDNumberFormatDictionary changeX : changeXs) {
            array.add(changeX);
        }
        this.getCOSObject().setItem(COSName.X, (COSBase)array);
    }

    public PDNumberFormatDictionary[] getChangeYs() {
        COSArray y = this.getCOSObject().getCOSArray(COSName.Y);
        if (y != null) {
            PDNumberFormatDictionary[] retval = new PDNumberFormatDictionary[y.size()];
            for (int i2 = 0; i2 < y.size(); ++i2) {
                COSDictionary dic = (COSDictionary)y.get(i2);
                retval[i2] = new PDNumberFormatDictionary(dic);
            }
            return retval;
        }
        return null;
    }

    public void setChangeYs(PDNumberFormatDictionary[] changeYs) {
        COSArray array = new COSArray();
        for (PDNumberFormatDictionary changeY : changeYs) {
            array.add(changeY);
        }
        this.getCOSObject().setItem(COSName.Y, (COSBase)array);
    }

    public PDNumberFormatDictionary[] getDistances() {
        COSArray d2 = this.getCOSObject().getCOSArray(COSName.D);
        if (d2 != null) {
            PDNumberFormatDictionary[] retval = new PDNumberFormatDictionary[d2.size()];
            for (int i2 = 0; i2 < d2.size(); ++i2) {
                COSDictionary dic = (COSDictionary)d2.get(i2);
                retval[i2] = new PDNumberFormatDictionary(dic);
            }
            return retval;
        }
        return null;
    }

    public void setDistances(PDNumberFormatDictionary[] distances) {
        COSArray array = new COSArray();
        for (PDNumberFormatDictionary distance : distances) {
            array.add(distance);
        }
        this.getCOSObject().setItem(COSName.D, (COSBase)array);
    }

    public PDNumberFormatDictionary[] getAreas() {
        COSArray a2 = this.getCOSObject().getCOSArray(COSName.A);
        if (a2 != null) {
            PDNumberFormatDictionary[] retval = new PDNumberFormatDictionary[a2.size()];
            for (int i2 = 0; i2 < a2.size(); ++i2) {
                COSDictionary dic = (COSDictionary)a2.get(i2);
                retval[i2] = new PDNumberFormatDictionary(dic);
            }
            return retval;
        }
        return null;
    }

    public void setAreas(PDNumberFormatDictionary[] areas) {
        COSArray array = new COSArray();
        for (PDNumberFormatDictionary area : areas) {
            array.add(area);
        }
        this.getCOSObject().setItem(COSName.A, (COSBase)array);
    }

    public PDNumberFormatDictionary[] getAngles() {
        COSArray t = this.getCOSObject().getCOSArray(COSName.T);
        if (t != null) {
            PDNumberFormatDictionary[] retval = new PDNumberFormatDictionary[t.size()];
            for (int i2 = 0; i2 < t.size(); ++i2) {
                COSDictionary dic = (COSDictionary)t.get(i2);
                retval[i2] = new PDNumberFormatDictionary(dic);
            }
            return retval;
        }
        return null;
    }

    public void setAngles(PDNumberFormatDictionary[] angles) {
        COSArray array = new COSArray();
        for (PDNumberFormatDictionary angle : angles) {
            array.add(angle);
        }
        this.getCOSObject().setItem(COSName.T, (COSBase)array);
    }

    public PDNumberFormatDictionary[] getLineSloaps() {
        COSArray s = this.getCOSObject().getCOSArray(COSName.S);
        if (s != null) {
            PDNumberFormatDictionary[] retval = new PDNumberFormatDictionary[s.size()];
            for (int i2 = 0; i2 < s.size(); ++i2) {
                COSDictionary dic = (COSDictionary)s.get(i2);
                retval[i2] = new PDNumberFormatDictionary(dic);
            }
            return retval;
        }
        return null;
    }

    public void setLineSloaps(PDNumberFormatDictionary[] lineSloaps) {
        COSArray array = new COSArray();
        for (PDNumberFormatDictionary lineSloap : lineSloaps) {
            array.add(lineSloap);
        }
        this.getCOSObject().setItem(COSName.S, (COSBase)array);
    }

    public float[] getCoordSystemOrigin() {
        COSArray o = this.getCOSObject().getCOSArray(COSName.O);
        return o != null ? o.toFloatArray() : null;
    }

    public void setCoordSystemOrigin(float[] coordSystemOrigin) {
        COSArray array = new COSArray();
        array.setFloatArray(coordSystemOrigin);
        this.getCOSObject().setItem(COSName.O, (COSBase)array);
    }

    public float getCYX() {
        return this.getCOSObject().getFloat(COSName.CYX);
    }

    public void setCYX(float cyx) {
        this.getCOSObject().setFloat(COSName.CYX, cyx);
    }
}

