/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.angus.mail.imap.protocol;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;

public class BASE64MailboxEncoder {
    protected byte[] buffer = new byte[4];
    protected int bufsize = 0;
    protected boolean started = false;
    protected Writer out = null;
    private static final char[] pem_array = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', ','};

    public static String encode(String original) {
        BASE64MailboxEncoder base64stream = null;
        char[] origchars = original.toCharArray();
        int length = origchars.length;
        boolean changedString = false;
        CharArrayWriter writer = new CharArrayWriter(length);
        for (int index = 0; index < length; ++index) {
            char current = origchars[index];
            if (current >= ' ' && current <= '~') {
                if (base64stream != null) {
                    base64stream.flush();
                }
                if (current == '&') {
                    changedString = true;
                    writer.write(38);
                    writer.write(45);
                    continue;
                }
                writer.write(current);
                continue;
            }
            if (base64stream == null) {
                base64stream = new BASE64MailboxEncoder(writer);
                changedString = true;
            }
            base64stream.write(current);
        }
        if (base64stream != null) {
            base64stream.flush();
        }
        if (changedString) {
            return writer.toString();
        }
        return original;
    }

    public BASE64MailboxEncoder(Writer what) {
        this.out = what;
    }

    public void write(int c2) {
        try {
            if (!this.started) {
                this.started = true;
                this.out.write(38);
            }
            this.buffer[this.bufsize++] = (byte)(c2 >> 8);
            this.buffer[this.bufsize++] = (byte)(c2 & 0xFF);
            if (this.bufsize >= 3) {
                this.encode();
                this.bufsize -= 3;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void flush() {
        try {
            if (this.bufsize > 0) {
                this.encode();
                this.bufsize = 0;
            }
            if (this.started) {
                this.out.write(45);
                this.started = false;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void encode() throws IOException {
        if (this.bufsize == 1) {
            byte a2 = this.buffer[0];
            int b2 = 0;
            boolean c2 = false;
            this.out.write(pem_array[a2 >>> 2 & 0x3F]);
            this.out.write(pem_array[(a2 << 4 & 0x30) + (b2 >>> 4 & 0xF)]);
        } else if (this.bufsize == 2) {
            byte a3 = this.buffer[0];
            byte b3 = this.buffer[1];
            int c3 = 0;
            this.out.write(pem_array[a3 >>> 2 & 0x3F]);
            this.out.write(pem_array[(a3 << 4 & 0x30) + (b3 >>> 4 & 0xF)]);
            this.out.write(pem_array[(b3 << 2 & 0x3C) + (c3 >>> 6 & 3)]);
        } else {
            byte a4 = this.buffer[0];
            byte b4 = this.buffer[1];
            byte c4 = this.buffer[2];
            this.out.write(pem_array[a4 >>> 2 & 0x3F]);
            this.out.write(pem_array[(a4 << 4 & 0x30) + (b4 >>> 4 & 0xF)]);
            this.out.write(pem_array[(b4 << 2 & 0x3C) + (c4 >>> 6 & 3)]);
            this.out.write(pem_array[c4 & 0x3F]);
            if (this.bufsize == 4) {
                this.buffer[0] = this.buffer[3];
            }
        }
    }
}

