/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.angus.mail.imap.protocol;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.angus.mail.iap.ParsingException;
import org.eclipse.angus.mail.iap.Protocol;
import org.eclipse.angus.mail.iap.ProtocolException;
import org.eclipse.angus.mail.iap.Response;
import org.eclipse.angus.mail.imap.protocol.BODY;
import org.eclipse.angus.mail.imap.protocol.BODYSTRUCTURE;
import org.eclipse.angus.mail.imap.protocol.ENVELOPE;
import org.eclipse.angus.mail.imap.protocol.FLAGS;
import org.eclipse.angus.mail.imap.protocol.FetchItem;
import org.eclipse.angus.mail.imap.protocol.IMAPResponse;
import org.eclipse.angus.mail.imap.protocol.INTERNALDATE;
import org.eclipse.angus.mail.imap.protocol.Item;
import org.eclipse.angus.mail.imap.protocol.MODSEQ;
import org.eclipse.angus.mail.imap.protocol.RFC822DATA;
import org.eclipse.angus.mail.imap.protocol.RFC822SIZE;
import org.eclipse.angus.mail.imap.protocol.UID;
import org.eclipse.angus.mail.util.ASCIIUtility;

public class FetchResponse
extends IMAPResponse {
    private Item[] items;
    private Map<String, Object> extensionItems;
    private final FetchItem[] fitems;
    private static final char[] HEADER = new char[]{'.', 'H', 'E', 'A', 'D', 'E', 'R'};
    private static final char[] TEXT = new char[]{'.', 'T', 'E', 'X', 'T'};

    public FetchResponse(Protocol p) throws IOException, ProtocolException {
        super(p);
        this.fitems = null;
        this.parse();
    }

    public FetchResponse(IMAPResponse r) throws IOException, ProtocolException {
        this(r, null);
    }

    public FetchResponse(IMAPResponse r, FetchItem[] fitems) throws IOException, ProtocolException {
        super(r);
        this.fitems = fitems;
        this.parse();
    }

    public int getItemCount() {
        return this.items.length;
    }

    public Item getItem(int index) {
        return this.items[index];
    }

    public <T extends Item> T getItem(Class<T> c2) {
        for (int i2 = 0; i2 < this.items.length; ++i2) {
            if (!c2.isInstance(this.items[i2])) continue;
            return (T)((Item)c2.cast(this.items[i2]));
        }
        return null;
    }

    public static <T extends Item> T getItem(Response[] r, int msgno, Class<T> c2) {
        if (r == null) {
            return null;
        }
        for (int i2 = 0; i2 < r.length; ++i2) {
            if (r[i2] == null || !(r[i2] instanceof FetchResponse) || ((FetchResponse)r[i2]).getNumber() != msgno) continue;
            FetchResponse f2 = (FetchResponse)r[i2];
            for (int j2 = 0; j2 < f2.items.length; ++j2) {
                if (!c2.isInstance(f2.items[j2])) continue;
                return (T)((Item)c2.cast(f2.items[j2]));
            }
        }
        return null;
    }

    public static <T extends Item> List<T> getItems(Response[] r, int msgno, Class<T> c2) {
        ArrayList<Item> items = new ArrayList<Item>();
        if (r == null) {
            return items;
        }
        for (int i2 = 0; i2 < r.length; ++i2) {
            if (r[i2] == null || !(r[i2] instanceof FetchResponse) || ((FetchResponse)r[i2]).getNumber() != msgno) continue;
            FetchResponse f2 = (FetchResponse)r[i2];
            for (int j2 = 0; j2 < f2.items.length; ++j2) {
                if (!c2.isInstance(f2.items[j2])) continue;
                items.add((Item)c2.cast(f2.items[j2]));
            }
        }
        return items;
    }

    public Map<String, Object> getExtensionItems() {
        return this.extensionItems;
    }

    private void parse() throws ParsingException {
        if (!this.isNextNonSpace('(')) {
            throw new ParsingException("error in FETCH parsing, missing '(' at index " + this.index);
        }
        ArrayList<Item> v = new ArrayList<Item>();
        Item i2 = null;
        this.skipSpaces();
        do {
            if (this.index >= this.size) {
                throw new ParsingException("error in FETCH parsing, ran off end of buffer, size " + this.size);
            }
            i2 = this.parseItem();
            if (i2 != null) {
                v.add(i2);
                continue;
            }
            if (this.parseExtensionItem()) continue;
            throw new ParsingException("error in FETCH parsing, unrecognized item at index " + this.index + ", starts with \"" + this.next20() + "\"");
        } while (!this.isNextNonSpace(')'));
        this.items = v.toArray(new Item[0]);
    }

    private String next20() {
        if (this.index + 20 > this.size) {
            return ASCIIUtility.toString(this.buffer, this.index, this.size);
        }
        return ASCIIUtility.toString(this.buffer, this.index, this.index + 20) + "...";
    }

    private Item parseItem() throws ParsingException {
        switch (this.buffer[this.index]) {
            case 69: 
            case 101: {
                if (!this.match(ENVELOPE.name)) break;
                return new ENVELOPE(this);
            }
            case 70: 
            case 102: {
                if (!this.match(FLAGS.name)) break;
                return new FLAGS(this);
            }
            case 73: 
            case 105: {
                if (!this.match(INTERNALDATE.name)) break;
                return new INTERNALDATE(this);
            }
            case 66: 
            case 98: {
                if (this.match(BODYSTRUCTURE.name)) {
                    return new BODYSTRUCTURE(this);
                }
                if (!this.match(BODY.name)) break;
                if (this.buffer[this.index] == 91) {
                    return new BODY(this);
                }
                return new BODYSTRUCTURE(this);
            }
            case 82: 
            case 114: {
                if (this.match(RFC822SIZE.name)) {
                    return new RFC822SIZE(this);
                }
                if (!this.match(RFC822DATA.name)) break;
                boolean isHeader = false;
                if (this.match(HEADER)) {
                    isHeader = true;
                } else if (this.match(TEXT)) {
                    isHeader = false;
                }
                return new RFC822DATA(this, isHeader);
            }
            case 85: 
            case 117: {
                if (!this.match(UID.name)) break;
                return new UID(this);
            }
            case 77: 
            case 109: {
                if (!this.match(MODSEQ.name)) break;
                return new MODSEQ(this);
            }
        }
        return null;
    }

    private boolean parseExtensionItem() throws ParsingException {
        if (this.fitems == null) {
            return false;
        }
        for (int i2 = 0; i2 < this.fitems.length; ++i2) {
            if (!this.match(this.fitems[i2].getName())) continue;
            if (this.extensionItems == null) {
                this.extensionItems = new HashMap<String, Object>();
            }
            this.extensionItems.put(this.fitems[i2].getName(), this.fitems[i2].parseItem(this));
            return true;
        }
        return false;
    }

    private boolean match(char[] itemName) {
        int len = itemName.length;
        int i2 = 0;
        int j2 = this.index;
        while (i2 < len) {
            if (Character.toUpperCase((char)this.buffer[j2++]) == itemName[i2++]) continue;
            return false;
        }
        this.index += len;
        return true;
    }

    private boolean match(String itemName) {
        int len = itemName.length();
        int i2 = 0;
        int j2 = this.index;
        while (i2 < len) {
            if (Character.toUpperCase((char)this.buffer[j2++]) == itemName.charAt(i2++)) continue;
            return false;
        }
        this.index += len;
        return true;
    }
}

