/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.angus.mail.nativeimage;

import jakarta.mail.Provider;
import jakarta.mail.Session;
import jakarta.mail.URLName;
import java.lang.reflect.Executable;
import java.text.MessageFormat;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeReflection;

public class AngusMailFeature
implements Feature {
    private static final boolean ENABLED = AngusMailFeature.getOption("angus.mail.native-image.enable", true);
    private static final boolean DEBUG = AngusMailFeature.getOption("angus.mail.native-image.trace", false);

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return ENABLED;
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        ServiceLoader<Provider> providers = ServiceLoader.load(Provider.class);
        for (Provider p : providers) {
            Class pc = access.findClassByName(p.getClassName());
            if (pc != null) {
                AngusMailFeature.log(() -> MessageFormat.format("Registering {0}", pc));
                RuntimeReflection.register((Class[])new Class[]{pc});
                try {
                    RuntimeReflection.register((Executable[])new Executable[]{pc.getConstructor(Session.class, URLName.class)});
                }
                catch (NoSuchMethodException e2) {
                    AngusMailFeature.log(() -> MessageFormat.format("\tno constructor for {0}", pc));
                }
                continue;
            }
            AngusMailFeature.log(() -> MessageFormat.format("Class '{0}' for provider '{1}' not found", p.getClassName(), p.getClass().getName()));
        }
    }

    private static void log(Supplier<String> msg) {
        if (DEBUG) {
            System.out.println(msg.get());
        }
    }

    private static boolean getOption(String name, boolean def) {
        String prop = System.getProperty(name);
        if (prop == null) {
            return def;
        }
        return Boolean.parseBoolean(name);
    }
}

