/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.external.statistics.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import org.glassfish.external.statistics.BoundaryStatistic;
import org.glassfish.external.statistics.impl.StatisticImpl;

public final class BoundaryStatisticImpl
extends StatisticImpl
implements BoundaryStatistic,
InvocationHandler {
    private final long lowerBound;
    private final long upperBound;
    private final BoundaryStatistic bs = (BoundaryStatistic)Proxy.newProxyInstance(BoundaryStatistic.class.getClassLoader(), new Class[]{BoundaryStatistic.class}, (InvocationHandler)this);

    public BoundaryStatisticImpl(long lower, long upper, String name, String unit, String desc, long startTime, long sampleTime) {
        super(name, unit, desc, startTime, sampleTime);
        this.upperBound = upper;
        this.lowerBound = lower;
    }

    public synchronized BoundaryStatistic getStatistic() {
        return this.bs;
    }

    @Override
    public synchronized Map getStaticAsMap() {
        Map m2 = super.getStaticAsMap();
        m2.put("lowerbound", this.getLowerBound());
        m2.put("upperbound", this.getUpperBound());
        return m2;
    }

    @Override
    public synchronized long getLowerBound() {
        return this.lowerBound;
    }

    @Override
    public synchronized long getUpperBound() {
        return this.upperBound;
    }

    @Override
    public synchronized void reset() {
        super.reset();
        this.sampleTime = -1L;
    }

    @Override
    public Object invoke(Object proxy, Method m2, Object[] args) throws Throwable {
        Object result;
        this.checkMethod(m2);
        try {
            result = m2.invoke((Object)this, args);
        }
        catch (InvocationTargetException e2) {
            throw e2.getTargetException();
        }
        catch (Exception e3) {
            throw new RuntimeException("unexpected invocation exception: " + e3.getMessage());
        }
        return result;
    }
}

