/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jaxb.runtime.v2.runtime.reflect.opt;

import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.jaxb.runtime.v2.runtime.reflect.Accessor;

final class Injector {
    private static final ReentrantReadWriteLock irwl = new ReentrantReadWriteLock();
    private static final Lock ir = irwl.readLock();
    private static final Lock iw = irwl.writeLock();
    private static final Map<ClassLoader, WeakReference<Injector>> injectors = new WeakHashMap<ClassLoader, WeakReference<Injector>>();
    private static final Logger logger = Logger.getLogger(Injector.class.getName());
    private final Map<String, Class> classes = new HashMap<String, Class>();
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private final Lock r = this.rwl.readLock();
    private final Lock w = this.rwl.writeLock();
    private final ClassLoader parent;
    private final boolean loadable;
    private static Method defineClass;
    private static Method resolveClass;
    private static Method findLoadedClass;
    private static Object U;

    static Class inject(ClassLoader cl, String className, byte[] image) {
        Injector injector = Injector.get(cl);
        if (injector != null) {
            return injector.inject(className, image);
        }
        return null;
    }

    static Class find(ClassLoader cl, String className) {
        Injector injector = Injector.get(cl);
        if (injector != null) {
            return injector.find(className);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Injector get(ClassLoader cl) {
        WeakReference<Injector> wr;
        Injector injector = null;
        ir.lock();
        try {
            wr = injectors.get(cl);
        }
        finally {
            ir.unlock();
        }
        if (wr != null) {
            injector = (Injector)wr.get();
        }
        if (injector == null) {
            try {
                injector = new Injector(cl);
                wr = new WeakReference<Injector>(injector);
                iw.lock();
                try {
                    if (!injectors.containsKey(cl)) {
                        injectors.put(cl, wr);
                    }
                }
                finally {
                    iw.unlock();
                }
            }
            catch (SecurityException e2) {
                logger.log(Level.FINE, "Unable to set up a back-door for the injector", e2);
                return null;
            }
        }
        return injector;
    }

    private static Class classForNames(String ... names) throws ClassNotFoundException {
        for (String name : names) {
            try {
                return Class.forName(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        throw new ClassNotFoundException(String.format("No class found for supplied FQDNs %s", Arrays.toString(names)));
    }

    private static Method getMethod(Class<?> c2, String methodname, Class<?> ... params) {
        try {
            Method m2 = c2.getDeclaredMethod(methodname, params);
            m2.setAccessible(true);
            return m2;
        }
        catch (NoSuchMethodException e2) {
            throw new NoSuchMethodError(e2.getMessage());
        }
    }

    private Injector(ClassLoader parent) {
        this.parent = parent;
        assert (parent != null);
        boolean loadableCheck = false;
        try {
            loadableCheck = parent.loadClass(Accessor.class.getName()) == Accessor.class;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.loadable = loadableCheck;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Class inject(String className, byte[] image) {
        if (!this.loadable) {
            return null;
        }
        boolean wlocked = false;
        boolean rlocked = false;
        try {
            Throwable t;
            this.r.lock();
            rlocked = true;
            Class c2 = this.classes.get(className);
            this.r.unlock();
            rlocked = false;
            if (c2 == null && findLoadedClass != null) {
                try {
                    c2 = (Class)findLoadedClass.invoke((Object)this.parent, className.replace('/', '.'));
                }
                catch (IllegalAccessException | IllegalArgumentException e2) {
                    logger.log(Level.FINE, "Unable to find " + className, e2);
                }
                catch (InvocationTargetException e3) {
                    t = e3.getTargetException();
                    logger.log(Level.FINE, "Unable to find " + className, t);
                }
                if (c2 != null) {
                    this.w.lock();
                    wlocked = true;
                    this.classes.put(className, c2);
                    this.w.unlock();
                    wlocked = false;
                    Class e3 = c2;
                    return e3;
                }
            }
            if (c2 == null) {
                this.r.lock();
                rlocked = true;
                c2 = this.classes.get(className);
                this.r.unlock();
                rlocked = false;
                if (c2 == null) {
                    try {
                        if (resolveClass != null) {
                            c2 = (Class)defineClass.invoke((Object)this.parent, className.replace('/', '.'), image, 0, image.length);
                            resolveClass.invoke((Object)this.parent, c2);
                        } else {
                            c2 = (Class)defineClass.invoke(U, className.replace('/', '.'), image, 0, image.length, this.parent, Injector.class.getProtectionDomain());
                        }
                    }
                    catch (IllegalAccessException | LinkageError | SecurityException e4) {
                        logger.log(Level.FINE, "Unable to inject " + className, e4);
                        t = null;
                        if (rlocked) {
                            this.r.unlock();
                        }
                        if (wlocked) {
                            this.w.unlock();
                        }
                        return t;
                    }
                    catch (InvocationTargetException e5) {
                        t = e5.getTargetException();
                        if (t instanceof LinkageError) {
                            logger.log(Level.FINE, "duplicate class definition bug occured? Please report this : " + className, t);
                        } else {
                            logger.log(Level.FINE, "Unable to inject " + className, t);
                        }
                        Class clazz = null;
                        if (rlocked) {
                            this.r.unlock();
                        }
                        if (wlocked) {
                            this.w.unlock();
                        }
                        return clazz;
                    }
                    this.w.lock();
                    wlocked = true;
                    if (!this.classes.containsKey(className)) {
                        this.classes.put(className, c2);
                    }
                    this.w.unlock();
                    wlocked = false;
                }
            }
            Class clazz = c2;
            return clazz;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (rlocked) {
                this.r.unlock();
            }
            if (wlocked) {
                this.w.unlock();
            }
        }
    }

    private Class find(String className) {
        this.r.lock();
        try {
            Class clazz = this.classes.get(className);
            return clazz;
        }
        finally {
            this.r.unlock();
        }
    }

    static {
        try {
            Method[] m2 = AccessController.doPrivileged(new PrivilegedAction<Method[]>(){

                @Override
                public Method[] run() {
                    return new Method[]{Injector.getMethod(ClassLoader.class, "defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE), Injector.getMethod(ClassLoader.class, "resolveClass", Class.class), Injector.getMethod(ClassLoader.class, "findLoadedClass", String.class)};
                }
            });
            defineClass = m2[0];
            resolveClass = m2[1];
            findLoadedClass = m2[2];
        }
        catch (Throwable t) {
            try {
                U = AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        Class u = Injector.classForNames("sun.misc.Unsafe", "jdk.internal.misc.Unsafe");
                        Field theUnsafe = u.getDeclaredField("theUnsafe");
                        theUnsafe.setAccessible(true);
                        return theUnsafe.get(null);
                    }
                });
                defineClass = AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){

                    @Override
                    public Method run() throws Exception {
                        return U.getClass().getMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, ClassLoader.class, ProtectionDomain.class);
                    }
                });
            }
            catch (SecurityException | PrivilegedActionException ex) {
                Logger.getLogger(Injector.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

