/*
 * Decompiled with CFR 0.152.
 */
package org.htmlcleaner;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.ListIterator;
import org.htmlcleaner.BaseToken;
import org.htmlcleaner.CleanerProperties;
import org.htmlcleaner.CommentToken;
import org.htmlcleaner.ContentToken;
import org.htmlcleaner.TagNode;
import org.htmlcleaner.Utils;
import org.htmlcleaner.XmlSerializer;

public class BrowserCompactXmlSerializer
extends XmlSerializer {
    public BrowserCompactXmlSerializer(CleanerProperties cleanerProperties) {
        super(cleanerProperties);
    }

    protected void serialize(TagNode tagNode, Writer writer) throws IOException {
        this.serializeOpenTag(tagNode, writer, false);
        List list = tagNode.getChildren();
        if (!this.isMinimizedTagSyntax(tagNode)) {
            ListIterator listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                String string;
                Object e2 = listIterator.next();
                if (e2 == null) continue;
                if (e2 instanceof ContentToken) {
                    string = ((ContentToken)e2).getContent();
                    boolean bl = string.length() > 0 && Character.isWhitespace(string.charAt(0));
                    boolean bl2 = string.length() > 1 && Character.isWhitespace(string.charAt(string.length() - 1));
                    String string2 = string = this.dontEscape(tagNode) ? string.trim().replaceAll("]]>", "]]&gt;") : this.escapeXml(string.trim());
                    if (bl) {
                        writer.write(32);
                    }
                    if (string.length() != 0) {
                        writer.write(string);
                        if (bl2) {
                            writer.write(32);
                        }
                    }
                    if (!listIterator.hasNext()) continue;
                    if (!Utils.isWhitespaceString(listIterator.next())) {
                        writer.write("\n");
                    }
                    listIterator.previous();
                    continue;
                }
                if (e2 instanceof CommentToken) {
                    string = ((CommentToken)e2).getCommentedContent().trim();
                    writer.write(string);
                    continue;
                }
                ((BaseToken)e2).serialize(this, writer);
            }
            this.serializeEndTag(tagNode, writer, false);
        }
    }
}

