/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.util.Locale;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.plaf.basic.BasicOptionPaneUI;
import org.jdesktop.swingx.action.BoundAction;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;
import org.jdesktop.swingx.plaf.UIManagerExt;

public class JXDialog
extends JDialog {
    public static final String EXECUTE_ACTION_COMMAND = "execute";
    public static final String CLOSE_ACTION_COMMAND = "close";
    public static final String UIPREFIX = "XDialog.";
    protected JComponent content;

    public JXDialog(JComponent content) {
        this.setContent(content);
    }

    public JXDialog(Frame frame, JComponent content) {
        super(frame);
        this.setContent(content);
    }

    public JXDialog(Dialog dialog, JComponent content) {
        super(dialog);
        this.setContent(content);
    }

    private void setContent(JComponent content) {
        Action contentExecuteAction;
        if (this.content != null) {
            throw new IllegalStateException("content must not be set more than once");
        }
        this.initActions();
        Action contentCloseAction = content.getActionMap().get(CLOSE_ACTION_COMMAND);
        if (contentCloseAction != null) {
            this.putAction(CLOSE_ACTION_COMMAND, contentCloseAction);
        }
        if ((contentExecuteAction = content.getActionMap().get(EXECUTE_ACTION_COMMAND)) != null) {
            this.putAction(EXECUTE_ACTION_COMMAND, contentExecuteAction);
        }
        this.content = content;
        this.build();
        this.setTitleFromContent();
    }

    protected void setTitleFromContent() {
        if (this.content == null) {
            return;
        }
        this.setTitle(this.content.getName());
    }

    private void build() {
        Box contentBox = new Box(3);
        contentBox.add(this.content);
        JComponent buttonPanel = this.createButtonPanel();
        contentBox.add(buttonPanel);
        contentBox.setBorder(BorderFactory.createEmptyBorder(14, 14, 14, 14));
        this.add(contentBox);
    }

    public void setVisible(boolean visible) {
        if (this.content == null) {
            throw new IllegalStateException("content must be built before showing the dialog");
        }
        super.setVisible(visible);
    }

    public void setLocale(Locale l2) {
        if (this.content != null) {
            this.content.setLocale(l2);
            this.updateLocaleState(l2);
        }
        super.setLocale(l2);
    }

    protected void updateLocaleState(Locale locale) {
        this.setTitleFromContent();
        for (Object key : this.getRootPane().getActionMap().allKeys()) {
            String keyString;
            if (!(key instanceof String)) continue;
            Action contentAction = this.content.getActionMap().get(key);
            Action rootPaneAction = this.getAction(key);
            if (rootPaneAction.equals(contentAction) || key.equals(keyString = this.getUIString((String)key, locale))) continue;
            rootPaneAction.putValue("Name", keyString);
        }
    }

    public void doClose() {
        this.dispose();
    }

    private void initActions() {
        Action defaultAction = this.createCloseAction();
        this.putAction(CLOSE_ACTION_COMMAND, defaultAction);
        this.putAction(EXECUTE_ACTION_COMMAND, defaultAction);
    }

    private Action createCloseAction() {
        String actionName = this.getUIString(CLOSE_ACTION_COMMAND);
        BoundAction action = new BoundAction(actionName, CLOSE_ACTION_COMMAND);
        action.registerCallback(this, "doClose");
        return action;
    }

    protected JComponent createButtonPanel() {
        JPanel panel = new JPanel(new BasicOptionPaneUI.ButtonAreaLayout(true, 6)){

            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }
        };
        panel.setBorder(BorderFactory.createEmptyBorder(9, 0, 0, 0));
        Action executeAction = this.getAction(EXECUTE_ACTION_COMMAND);
        Action closeAction = this.getAction(CLOSE_ACTION_COMMAND);
        JButton findButton = new JButton(executeAction);
        panel.add(findButton);
        if (executeAction != closeAction) {
            panel.add(new JButton(closeAction));
        }
        KeyStroke enterKey = KeyStroke.getKeyStroke(10, 0, false);
        KeyStroke escapeKey = KeyStroke.getKeyStroke(27, 0, false);
        InputMap inputMap = this.getRootPane().getInputMap(1);
        inputMap.put(enterKey, EXECUTE_ACTION_COMMAND);
        inputMap.put(escapeKey, CLOSE_ACTION_COMMAND);
        this.getRootPane().setDefaultButton(findButton);
        return panel;
    }

    private void putAction(Object key, Action action) {
        this.getRootPane().getActionMap().put(key, action);
    }

    private Action getAction(Object key) {
        return this.getRootPane().getActionMap().get(key);
    }

    protected String getUIString(String key) {
        return this.getUIString(key, this.getLocale());
    }

    protected String getUIString(String key, Locale locale) {
        String text = UIManagerExt.getString(UIPREFIX + key, locale);
        return text != null ? text : key;
    }

    static {
        LookAndFeelAddons.getAddon();
    }
}

