/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.io.Serializable;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.UIResource;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.event.TableColumnModelExtListener;
import org.jdesktop.swingx.table.ColumnHeaderRenderer;
import org.jdesktop.swingx.table.TableColumnExt;

public class JXTableHeader
extends JTableHeader
implements TableColumnModelExtListener {
    private SortGestureRecognizer sortGestureRecognizer;
    private MouseInputListener headerListener;

    public JXTableHeader() {
    }

    public JXTableHeader(TableColumnModel columnModel) {
        super(columnModel);
    }

    public void setTable(JTable table) {
        super.setTable(table);
        if (this.getXTable() != null) {
            this.installHeaderListener();
        } else {
            this.uninstallHeaderListener();
        }
    }

    public void columnPropertyChange(PropertyChangeEvent event) {
        if (this.isColumnEvent(event)) {
            return;
        }
        this.resizeAndRepaint();
    }

    protected boolean isColumnEvent(PropertyChangeEvent event) {
        return "width".equals(event.getPropertyName()) || "preferredWidth".equals(event.getPropertyName()) || "visible".equals(event.getPropertyName());
    }

    public String getToolTipText(MouseEvent event) {
        String columnToolTipText = this.getColumnToolTipText(event);
        return columnToolTipText != null ? columnToolTipText : super.getToolTipText(event);
    }

    protected String getColumnToolTipText(MouseEvent event) {
        if (this.getXTable() == null) {
            return null;
        }
        int column = this.columnAtPoint(event.getPoint());
        if (column < 0) {
            return null;
        }
        TableColumnExt columnExt = this.getXTable().getColumnExt(column);
        return columnExt != null ? columnExt.getToolTipText() : null;
    }

    public JXTable getXTable() {
        if (!(this.getTable() instanceof JXTable)) {
            return null;
        }
        return (JXTable)this.getTable();
    }

    public TableCellRenderer getCellRenderer(int columnIndex) {
        TableCellRenderer renderer = this.getColumnModel().getColumn(columnIndex).getHeaderRenderer();
        return renderer != null ? renderer : this.getDefaultRenderer();
    }

    public Dimension getPreferredSize() {
        Dimension pref = super.getPreferredSize();
        pref = this.getPreferredSize(pref);
        pref.height = this.getMinimumHeight(pref.height);
        return pref;
    }

    protected Dimension getPreferredSize(Dimension pref) {
        int height = pref.height;
        for (int i2 = 0; i2 < this.getColumnModel().getColumnCount(); ++i2) {
            TableCellRenderer renderer = this.getCellRenderer(i2);
            Component comp = renderer.getTableCellRendererComponent(this.table, this.getColumnModel().getColumn(i2).getHeaderValue(), false, false, -1, i2);
            height = Math.max(height, comp.getPreferredSize().height);
        }
        pref.height = height;
        return pref;
    }

    protected int getMinimumHeight(int height) {
        if (height == 0) {
            TableCellRenderer renderer = this.getDefaultRenderer();
            Component comp = renderer.getTableCellRendererComponent(this.getTable(), "dummy", false, false, -1, -1);
            height = comp.getPreferredSize().height;
        }
        return height;
    }

    public void updateUI() {
        TableCellRenderer oldRenderer = this.preUpdateRendererUI();
        super.updateUI();
        this.postUpdateRendererUI(oldRenderer);
    }

    protected TableCellRenderer preUpdateRendererUI() {
        TableCellRenderer oldRenderer = this.getDefaultRenderer();
        if (oldRenderer instanceof ColumnHeaderRenderer) {
            this.setDefaultRenderer(((ColumnHeaderRenderer)oldRenderer).getDelegateRenderer());
        }
        return oldRenderer;
    }

    protected void postUpdateRendererUI(TableCellRenderer oldRenderer) {
        TableCellRenderer current = this.getDefaultRenderer();
        if (!(current instanceof ColumnHeaderRenderer) && current instanceof UIResource) {
            ColumnHeaderRenderer renderer;
            if (oldRenderer instanceof ColumnHeaderRenderer) {
                renderer = (ColumnHeaderRenderer)oldRenderer;
                renderer.updateUI(this);
            } else {
                renderer = new ColumnHeaderRenderer(this);
            }
            this.setDefaultRenderer(renderer);
        }
    }

    public void setDraggedDistance(int distance) {
        int old = this.getDraggedDistance();
        super.setDraggedDistance(distance);
        this.firePropertyChange("draggedDistance", old, this.getDraggedDistance());
        if (!this.getAutoscrolls() || this.getXTable() == null) {
            return;
        }
        TableColumn column = this.getDraggedColumn();
        if (column != null) {
            this.getXTable().scrollColumnToVisible(this.getViewIndexForColumn(column));
        }
    }

    public TableColumn getDraggedColumn() {
        return this.isVisible(this.draggedColumn) ? this.draggedColumn : null;
    }

    private boolean isVisible(TableColumn column) {
        return this.getViewIndexForColumn(column) >= 0;
    }

    private int getViewIndexForColumn(TableColumn aColumn) {
        if (aColumn == null) {
            return -1;
        }
        TableColumnModel cm = this.getColumnModel();
        for (int column = 0; column < cm.getColumnCount(); ++column) {
            if (cm.getColumn(column) != aColumn) continue;
            return column;
        }
        return -1;
    }

    public SortGestureRecognizer getSortGestureRecognizer() {
        if (this.sortGestureRecognizer == null) {
            this.sortGestureRecognizer = this.createSortGestureRecognizer();
        }
        return this.sortGestureRecognizer;
    }

    public void setSortGestureRecognizer(SortGestureRecognizer recognizer) {
        SortGestureRecognizer old = this.getSortGestureRecognizer();
        this.sortGestureRecognizer = recognizer;
        this.firePropertyChange("sortGestureRecognizer", old, this.getSortGestureRecognizer());
    }

    protected SortGestureRecognizer createSortGestureRecognizer() {
        return new SortGestureRecognizer();
    }

    protected void installHeaderListener() {
        if (this.headerListener == null) {
            this.headerListener = new HeaderListener();
            this.addMouseListener(this.headerListener);
            this.addMouseMotionListener(this.headerListener);
        }
    }

    protected void uninstallHeaderListener() {
        if (this.headerListener != null) {
            this.removeMouseListener(this.headerListener);
            this.removeMouseMotionListener(this.headerListener);
            this.headerListener = null;
        }
    }

    private class HeaderListener
    implements MouseInputListener,
    Serializable {
        private TableColumn cachedResizingColumn;

        private HeaderListener() {
        }

        public void mouseClicked(MouseEvent e2) {
            if (this.shouldIgnore(e2)) {
                return;
            }
            if (this.isInResizeRegion(e2)) {
                this.doResize(e2);
            } else {
                this.doSort(e2);
            }
        }

        private boolean shouldIgnore(MouseEvent e2) {
            return !SwingUtilities.isLeftMouseButton(e2) || !JXTableHeader.this.table.isEnabled();
        }

        private void doSort(MouseEvent e2) {
            JXTable table = JXTableHeader.this.getXTable();
            if (!table.isSortable()) {
                return;
            }
            if (JXTableHeader.this.getSortGestureRecognizer().isResetSortOrderGesture(e2)) {
                table.resetSortOrder();
                JXTableHeader.this.repaint();
            } else if (JXTableHeader.this.getSortGestureRecognizer().isToggleSortOrderGesture(e2)) {
                int column = JXTableHeader.this.columnAtPoint(e2.getPoint());
                if (column >= 0) {
                    table.toggleSortOrder(column);
                }
                this.uncacheResizingColumn();
                JXTableHeader.this.repaint();
            }
        }

        private void doResize(MouseEvent e2) {
            if (e2.getClickCount() != 2) {
                return;
            }
            int column = JXTableHeader.this.getViewIndexForColumn(this.cachedResizingColumn);
            if (column >= 0) {
                JXTableHeader.this.getXTable().packColumn(column, 5);
            }
            this.uncacheResizingColumn();
        }

        public void mouseReleased(MouseEvent e2) {
            this.cacheResizingColumn(e2);
        }

        public void mousePressed(MouseEvent e2) {
            this.cacheResizingColumn(e2);
        }

        private void cacheResizingColumn(MouseEvent e2) {
            if (!JXTableHeader.this.getSortGestureRecognizer().isSortOrderGesture(e2)) {
                return;
            }
            TableColumn column = JXTableHeader.this.getResizingColumn();
            if (column != null) {
                this.cachedResizingColumn = column;
            }
        }

        private void uncacheResizingColumn() {
            this.cachedResizingColumn = null;
        }

        private boolean isInResizeRegion(MouseEvent e2) {
            return this.cachedResizingColumn != null;
        }

        public void mouseEntered(MouseEvent e2) {
        }

        public void mouseExited(MouseEvent e2) {
            this.uncacheResizingColumn();
        }

        public void mouseDragged(MouseEvent e2) {
            this.uncacheResizingColumn();
        }

        public void mouseMoved(MouseEvent e2) {
        }
    }

    public static class SortGestureRecognizer {
        public boolean isResetSortOrderGesture(MouseEvent e2) {
            return this.isSortOrderGesture(e2) && this.isResetModifier(e2);
        }

        public boolean isToggleSortOrderGesture(MouseEvent e2) {
            return this.isSortOrderGesture(e2) && !this.isResetModifier(e2);
        }

        public boolean isSortOrderGesture(MouseEvent e2) {
            return e2.getClickCount() == 1;
        }

        protected boolean isResetModifier(MouseEvent e2) {
            return (e2.getModifiersEx() & 0x40) == 64;
        }
    }
}

