/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.action;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Logger;
import javax.swing.AbstractAction;

public class OpenBrowserAction
extends AbstractAction {
    private static Logger log = Logger.getLogger(OpenBrowserAction.class.getName());
    private URL url;
    private static final String osName = System.getProperty("os.name").toLowerCase();
    private static final boolean linux = osName.startsWith("linux");
    private static final boolean macosx = osName.startsWith("mac os x");
    private static final boolean win95 = osName.equals("windows 95");
    private static final boolean winAny = osName.startsWith("windows");
    private static final boolean DEBUG = true;

    public OpenBrowserAction() {
    }

    public OpenBrowserAction(String url) throws MalformedURLException {
        this.setUrl(new URL(url));
    }

    public OpenBrowserAction(URL url) {
        this.setUrl(url);
    }

    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public void actionPerformed(ActionEvent e2) {
        try {
            if (this.isApplet()) {
                log.fine("trying applet version");
                this.openApplet(this.url);
                log.fine("succeeded applet version");
            } else if (this.isWebStart()) {
                log.fine("trying applet version");
                this.openWebstart(this.url);
                log.fine("succeeded applet version");
            } else if (macosx) {
                log.fine("trying Mac OS X version");
                OpenBrowserAction.openMacOSX(this.url);
                log.fine("succeeded mac os x version");
            } else if (linux) {
                log.fine("trying linux version");
                this.openLinux(this.url);
                log.fine("succeeded linux version");
            } else if (win95) {
                log.fine("trying win95 version");
                this.openWin95(this.url);
                log.fine("succeeded win95 version");
            } else if (winAny) {
                log.fine("trying windows any version");
                this.openWindows(this.url);
                log.fine("succeeded windows any version");
            } else {
                log.fine("trying other version");
                this.openOther(this.url);
                log.fine("succeeded other version");
            }
        }
        catch (Throwable thr) {
            this.handleError(thr);
        }
    }

    protected void handleError(Throwable thr) {
        System.err.println(thr.getMessage());
        thr.printStackTrace(System.err);
    }

    private static void openMacOSX(URL url) throws IOException {
        try {
            log.fine("trying mac version using FileManager class");
            Class<?> fileMgr = Class.forName("com.apple.eio.FileManager");
            Method openURL = fileMgr.getDeclaredMethod("openURL", String.class);
            openURL.invoke(null, url.toString());
        }
        catch (Throwable thr) {
            log.fine("trying 'open' command version");
            thr.printStackTrace();
            Runtime.getRuntime().exec(new String[]{"open", url.toString()});
        }
    }

    private void openLinux(URL url) throws IOException, InterruptedException, Exception {
        try {
            Runtime.getRuntime().exec(new String[]{"./xdg-open", url.toString()});
        }
        catch (Throwable thr) {
            String[] browsers = new String[]{"firefox", "opera", "konqueror", "epiphany", "mozilla", "netscape"};
            String browser = null;
            for (int count = 0; count < browsers.length && browser == null; ++count) {
                if (Runtime.getRuntime().exec(new String[]{"which", browsers[count]}).waitFor() != 0) continue;
                browser = browsers[count];
            }
            if (browser == null) {
                throw new Exception("Could not find web browser");
            }
            Runtime.getRuntime().exec(new String[]{browser, url.toString()});
        }
    }

    private void openWin95(URL url) throws IOException {
        Runtime.getRuntime().exec(new String[]{"command.com", "/C", "start", url.toString()});
    }

    private void openWindows(URL url) throws IOException {
        Runtime.getRuntime().exec(new String[]{"cmd.exe", "/C", "start", url.toString()});
    }

    private void openOther(URL url) throws IOException {
        Runtime.getRuntime().exec(new String[]{"open", url.toString()});
    }

    private boolean isWebStart() {
        try {
            Class<?> svcManager = Class.forName("jnlp.ServiceManager");
            Method lookup = svcManager.getDeclaredMethod("lookup", String.class);
            lookup.invoke(null, "jnlp.BasicService");
            return true;
        }
        catch (Throwable thr) {
            return false;
        }
    }

    private void openWebstart(URL url) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class<?> svcManager = Class.forName("javax.jnlp.ServiceManager");
        Method lookup = svcManager.getDeclaredMethod("lookup", String.class);
        Object basicSvcInst = lookup.invoke(null, "javax.jnlp.BasicService");
        Class<?> basicSvc = Class.forName("javax.jnlp.BasicService");
        Method showDocument = basicSvc.getDeclaredMethod("showDocument", URL.class);
        showDocument.invoke(basicSvcInst, url);
    }

    private boolean isApplet() {
        return false;
    }

    private void openApplet(URL url) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public static void main(String ... args) throws MalformedURLException {
        OpenBrowserAction action = new OpenBrowserAction("http://sun.com/");
        action.actionPerformed(null);
    }
}

