/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.autocomplete;

import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.PlainDocument;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import org.jdesktop.swingx.autocomplete.AbstractAutoCompleteAdaptor;
import org.jdesktop.swingx.autocomplete.DelegatingDocumentEvent;
import org.jdesktop.swingx.autocomplete.ObjectToStringConverter;
import org.jdesktop.swingx.util.Contract;

public class AutoCompleteDocument
implements Document {
    boolean selecting = false;
    protected boolean strictMatching;
    AbstractAutoCompleteAdaptor adaptor;
    ObjectToStringConverter stringConverter;
    private final Handler handler;
    protected final Document delegate;

    public AutoCompleteDocument(AbstractAutoCompleteAdaptor adaptor, boolean strictMatching, ObjectToStringConverter stringConverter, Document delegate) {
        this.adaptor = Contract.asNotNull(adaptor, "adaptor cannot be null");
        this.strictMatching = strictMatching;
        this.stringConverter = stringConverter == null ? ObjectToStringConverter.DEFAULT_IMPLEMENTATION : stringConverter;
        this.delegate = delegate == null ? this.createDefaultDocument() : delegate;
        this.handler = new Handler();
        this.delegate.addDocumentListener(this.handler);
        Object selected = adaptor.getSelectedItem();
        if (selected != null) {
            this.setText(this.stringConverter.getPreferredStringForItem(selected));
        }
        this.adaptor.markEntireText();
    }

    public AutoCompleteDocument(AbstractAutoCompleteAdaptor adaptor, boolean strictMatching, ObjectToStringConverter stringConverter) {
        this(adaptor, strictMatching, stringConverter, null);
    }

    public AutoCompleteDocument(AbstractAutoCompleteAdaptor adaptor, boolean strictMatching) {
        this(adaptor, strictMatching, null);
    }

    protected Document createDefaultDocument() {
        return new PlainDocument();
    }

    public void remove(int offs, int len) throws BadLocationException {
        if (this.selecting) {
            return;
        }
        this.delegate.remove(offs, len);
        if (!this.strictMatching) {
            this.setSelectedItem(this.getText(0, this.getLength()), this.getText(0, this.getLength()));
            this.adaptor.getTextComponent().setCaretPosition(offs);
        }
    }

    public void insertString(int offs, String str, AttributeSet a2) throws BadLocationException {
        if (this.selecting) {
            return;
        }
        this.delegate.insertString(offs, str, a2);
        LookupResult lookupResult = this.lookupItem(this.getText(0, this.getLength()));
        if (lookupResult.matchingItem != null) {
            this.setSelectedItem(lookupResult.matchingItem, lookupResult.matchingString);
        } else if (this.strictMatching) {
            lookupResult.matchingItem = this.adaptor.getSelectedItem();
            lookupResult.matchingString = this.adaptor.getSelectedItemAsString();
            offs -= str.length();
            UIManager.getLookAndFeel().provideErrorFeedback(this.adaptor.getTextComponent());
        } else {
            lookupResult.matchingItem = this.getText(0, this.getLength());
            lookupResult.matchingString = this.getText(0, this.getLength());
            this.setSelectedItem(lookupResult.matchingItem, lookupResult.matchingString);
        }
        this.setText(lookupResult.matchingString);
        this.adaptor.markText(offs + str.length());
    }

    private void setText(String text) {
        try {
            this.delegate.remove(0, this.getLength());
            this.delegate.insertString(0, text, null);
        }
        catch (BadLocationException e2) {
            throw new RuntimeException(e2.toString());
        }
    }

    private void setSelectedItem(Object item, String itemAsString) {
        this.selecting = true;
        this.adaptor.setSelectedItem(item);
        this.adaptor.setSelectedItemAsString(itemAsString);
        this.selecting = false;
    }

    private LookupResult lookupItem(String pattern) {
        int j2;
        String[] possibleStrings;
        Object currentItem;
        int i2;
        Object selectedItem = this.adaptor.getSelectedItem();
        int n = this.adaptor.getItemCount();
        for (i2 = 0; i2 < n; ++i2) {
            currentItem = this.adaptor.getItem(i2);
            possibleStrings = this.stringConverter.getPossibleStringsForItem(currentItem);
            if (possibleStrings == null) continue;
            for (j2 = 0; j2 < possibleStrings.length; ++j2) {
                if (!possibleStrings[j2].equalsIgnoreCase(pattern)) continue;
                return new LookupResult(currentItem, possibleStrings[j2]);
            }
        }
        possibleStrings = this.stringConverter.getPossibleStringsForItem(selectedItem);
        if (possibleStrings != null) {
            for (i2 = 0; i2 < possibleStrings.length; ++i2) {
                if (!this.startsWithIgnoreCase(possibleStrings[i2], pattern)) continue;
                return new LookupResult(selectedItem, possibleStrings[i2]);
            }
        }
        n = this.adaptor.getItemCount();
        for (i2 = 0; i2 < n; ++i2) {
            currentItem = this.adaptor.getItem(i2);
            possibleStrings = this.stringConverter.getPossibleStringsForItem(currentItem);
            if (possibleStrings == null) continue;
            for (j2 = 0; j2 < possibleStrings.length; ++j2) {
                if (!this.startsWithIgnoreCase(possibleStrings[j2], pattern)) continue;
                return new LookupResult(currentItem, possibleStrings[j2]);
            }
        }
        return new LookupResult(null, "");
    }

    private boolean startsWithIgnoreCase(String base, String prefix) {
        if (base.length() < prefix.length()) {
            return false;
        }
        return base.regionMatches(true, 0, prefix, 0, prefix.length());
    }

    public void addDocumentListener(DocumentListener listener) {
        this.handler.addDocumentListener(listener);
    }

    public void addUndoableEditListener(UndoableEditListener listener) {
        this.handler.addUndoableEditListener(listener);
    }

    public Position createPosition(int offs) throws BadLocationException {
        return this.delegate.createPosition(offs);
    }

    public Element getDefaultRootElement() {
        return this.delegate.getDefaultRootElement();
    }

    public Position getEndPosition() {
        return this.delegate.getEndPosition();
    }

    public int getLength() {
        return this.delegate.getLength();
    }

    public Object getProperty(Object key) {
        return this.delegate.getProperty(key);
    }

    public Element[] getRootElements() {
        return this.delegate.getRootElements();
    }

    public Position getStartPosition() {
        return this.delegate.getStartPosition();
    }

    public String getText(int offset, int length) throws BadLocationException {
        return this.delegate.getText(offset, length);
    }

    public void getText(int offset, int length, Segment txt) throws BadLocationException {
        this.delegate.getText(offset, length, txt);
    }

    public void putProperty(Object key, Object value) {
        this.delegate.putProperty(key, value);
    }

    public void removeDocumentListener(DocumentListener listener) {
        this.handler.removeDocumentListener(listener);
    }

    public void removeUndoableEditListener(UndoableEditListener listener) {
        this.handler.removeUndoableEditListener(listener);
    }

    public void render(Runnable r) {
        this.delegate.render(r);
    }

    public boolean isStrictMatching() {
        return this.strictMatching;
    }

    private static class LookupResult {
        Object matchingItem;
        String matchingString;

        public LookupResult(Object matchingItem, String matchingString) {
            this.matchingItem = matchingItem;
            this.matchingString = matchingString;
        }
    }

    private class Handler
    implements DocumentListener,
    UndoableEditListener {
        private final EventListenerList listenerList = new EventListenerList();

        private Handler() {
        }

        public void addDocumentListener(DocumentListener listener) {
            this.listenerList.add(DocumentListener.class, listener);
        }

        public void addUndoableEditListener(UndoableEditListener listener) {
            this.listenerList.add(UndoableEditListener.class, listener);
        }

        public void removeDocumentListener(DocumentListener listener) {
            this.listenerList.remove(DocumentListener.class, listener);
        }

        public void removeUndoableEditListener(UndoableEditListener listener) {
            this.listenerList.remove(UndoableEditListener.class, listener);
        }

        public void changedUpdate(DocumentEvent e2) {
            e2 = new DelegatingDocumentEvent(AutoCompleteDocument.this, e2);
            Object[] listeners = this.listenerList.getListenerList();
            for (int i2 = listeners.length - 2; i2 >= 0; i2 -= 2) {
                if (listeners[i2] != DocumentListener.class) continue;
                ((DocumentListener)listeners[i2 + 1]).changedUpdate(e2);
            }
        }

        public void insertUpdate(DocumentEvent e2) {
            e2 = new DelegatingDocumentEvent(AutoCompleteDocument.this, e2);
            Object[] listeners = this.listenerList.getListenerList();
            for (int i2 = listeners.length - 2; i2 >= 0; i2 -= 2) {
                if (listeners[i2] != DocumentListener.class) continue;
                ((DocumentListener)listeners[i2 + 1]).insertUpdate(e2);
            }
        }

        public void removeUpdate(DocumentEvent e2) {
            e2 = new DelegatingDocumentEvent(AutoCompleteDocument.this, e2);
            Object[] listeners = this.listenerList.getListenerList();
            for (int i2 = listeners.length - 2; i2 >= 0; i2 -= 2) {
                if (listeners[i2] != DocumentListener.class) continue;
                ((DocumentListener)listeners[i2 + 1]).removeUpdate(e2);
            }
        }

        public void undoableEditHappened(UndoableEditEvent e2) {
            e2 = new UndoableEditEvent(AutoCompleteDocument.this, e2.getEdit());
            Object[] listeners = this.listenerList.getListenerList();
            for (int i2 = listeners.length - 2; i2 >= 0; i2 -= 2) {
                if (listeners[i2] != UndoableEditListener.class) continue;
                ((UndoableEditListener)listeners[i2 + 1]).undoableEditHappened(e2);
            }
        }
    }
}

