/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.decorator;

import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.FilterPipeline;

public abstract class Filter {
    private int column;
    protected FilterPipeline pipeline = null;
    protected ComponentAdapter adapter = null;
    protected int[] fromPrevious = new int[0];
    int order = -1;

    public Filter() {
        this(0);
    }

    public Filter(int column) {
        this.column = column;
        this.init();
    }

    public void refresh() {
        this.refresh(true);
    }

    public int getColumnIndex() {
        return this.column;
    }

    public void setColumnIndex(int modelColumn) {
        if (this.getColumnIndex() == modelColumn) {
            return;
        }
        this.column = modelColumn;
        this.refresh();
    }

    public String getColumnName() {
        if (this.adapter == null) {
            return "Column " + this.column;
        }
        return this.adapter.getColumnName(this.getColumnIndex());
    }

    public int convertRowIndexToModel(int row) {
        int mappedRow = this.mapTowardModel(row);
        Filter filter = this.getMappingFilter();
        if (filter != null) {
            mappedRow = filter.convertRowIndexToModel(mappedRow);
        }
        return mappedRow;
    }

    public int convertRowIndexToView(int row) {
        int mappedRow = row;
        Filter filter = this.getMappingFilter();
        if (filter != null) {
            mappedRow = filter.convertRowIndexToView(mappedRow);
        }
        return this.mapTowardView(mappedRow);
    }

    public Object getValueAt(int row, int column) {
        int mappedRow = this.mapTowardModel(row);
        Filter filter = this.getMappingFilter();
        if (filter != null) {
            return filter.getValueAt(mappedRow, column);
        }
        return this.adapter.getValueAt(mappedRow, column);
    }

    public String getStringAt(int row, int column) {
        int mappedRow = this.mapTowardModel(row);
        Filter filter = this.getMappingFilter();
        if (filter != null) {
            return filter.getStringAt(mappedRow, column);
        }
        return this.adapter.getStringAt(mappedRow, column);
    }

    public void setValueAt(Object aValue, int row, int column) {
        int mappedRow = this.mapTowardModel(row);
        Filter filter = this.getMappingFilter();
        if (filter != null) {
            filter.setValueAt(aValue, mappedRow, column);
            return;
        }
        this.adapter.setValueAt(aValue, mappedRow, column);
    }

    public boolean isCellEditable(int row, int column) {
        int mappedRow = this.mapTowardModel(row);
        Filter filter = this.getMappingFilter();
        if (filter != null) {
            return filter.isCellEditable(mappedRow, column);
        }
        return this.adapter.isCellEditable(mappedRow, column);
    }

    public abstract int getSize();

    protected int getInputSize() {
        return this.pipeline == null ? (this.adapter == null ? 0 : this.adapter.getRowCount()) : this.pipeline.getInputSize(this);
    }

    protected Object getInputValue(int row, int column) {
        Filter filter = this.getMappingFilter();
        if (filter != null) {
            return filter.getValueAt(row, column);
        }
        if (this.adapter != null) {
            return this.adapter.getValueAt(row, column);
        }
        return null;
    }

    protected String getInputString(int row, int column) {
        Filter filter = this.getMappingFilter();
        if (filter != null) {
            return filter.getStringAt(row, column);
        }
        if (this.adapter != null) {
            return this.adapter.getStringAt(row, column);
        }
        return null;
    }

    protected abstract void init();

    protected abstract void reset();

    protected abstract void filter();

    protected abstract int mapTowardModel(int var1);

    protected int mapTowardView(int row) {
        return row < 0 || row >= this.fromPrevious.length ? -1 : this.fromPrevious[row];
    }

    protected Filter getMappingFilter() {
        Filter filter = null;
        if (this.pipeline != null) {
            filter = this.pipeline.previous(this);
        }
        return filter;
    }

    protected void refresh(boolean reset) {
        if (reset) {
            this.reset();
        }
        this.filter();
        this.fireFilterChanged();
    }

    protected void fireFilterChanged() {
        if (this.pipeline != null && this.pipeline.contains(this)) {
            this.pipeline.filterChanged(this);
            return;
        }
        if (this.adapter != null) {
            this.adapter.refresh();
        }
    }

    protected void assign(ComponentAdapter adapter) {
        if (adapter == null) {
            throw new IllegalArgumentException("null adapter");
        }
        if (this.adapter == null) {
            this.adapter = adapter;
        } else if (this.adapter != adapter) {
            throw new IllegalStateException("Already bound to another adapter");
        }
    }

    final void assign(FilterPipeline pipeline) {
        if (this.pipeline == null || pipeline == null) {
            this.pipeline = pipeline;
        } else if (this.pipeline != pipeline) {
            throw new IllegalStateException("Already bound to another pipeline");
        }
    }

    void assign(FilterPipeline pipeline, int i2) {
        if (this.order >= 0) {
            throw new IllegalArgumentException("Element " + i2 + " is part of another pipeline.");
        }
        this.order = i2;
        this.assign(pipeline);
    }

    protected FilterPipeline getPipeline() {
        return this.pipeline;
    }
}

