/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.graphics;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.imageio.ImageIO;

public class GraphicsUtilities {
    private GraphicsUtilities() {
    }

    private static GraphicsConfiguration getGraphicsConfiguration() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    }

    private static boolean isHeadless() {
        return GraphicsEnvironment.isHeadless();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage convertToBufferedImage(Image img) {
        BufferedImage buff = GraphicsUtilities.createCompatibleTranslucentImage(img.getWidth(null), img.getHeight(null));
        Graphics2D g2 = buff.createGraphics();
        try {
            g2.drawImage(img, 0, 0, null);
        }
        finally {
            g2.dispose();
        }
        return buff;
    }

    public static BufferedImage createColorModelCompatibleImage(BufferedImage image) {
        ColorModel cm = image.getColorModel();
        return new BufferedImage(cm, cm.createCompatibleWritableRaster(image.getWidth(), image.getHeight()), cm.isAlphaPremultiplied(), null);
    }

    public static BufferedImage createCompatibleImage(BufferedImage image) {
        return GraphicsUtilities.createCompatibleImage(image, image.getWidth(), image.getHeight());
    }

    public static BufferedImage createCompatibleImage(BufferedImage image, int width, int height) {
        return GraphicsUtilities.isHeadless() ? new BufferedImage(width, height, image.getType()) : GraphicsUtilities.getGraphicsConfiguration().createCompatibleImage(width, height, image.getTransparency());
    }

    public static BufferedImage createCompatibleImage(int width, int height) {
        return GraphicsUtilities.isHeadless() ? new BufferedImage(width, height, 1) : GraphicsUtilities.getGraphicsConfiguration().createCompatibleImage(width, height);
    }

    public static BufferedImage createCompatibleTranslucentImage(int width, int height) {
        return GraphicsUtilities.isHeadless() ? new BufferedImage(width, height, 2) : GraphicsUtilities.getGraphicsConfiguration().createCompatibleImage(width, height, 3);
    }

    public static BufferedImage loadCompatibleImage(InputStream in) throws IOException {
        BufferedImage image = ImageIO.read(in);
        if (image == null) {
            return null;
        }
        return GraphicsUtilities.toCompatibleImage(image);
    }

    public static BufferedImage loadCompatibleImage(URL resource) throws IOException {
        BufferedImage image = ImageIO.read(resource);
        return GraphicsUtilities.toCompatibleImage(image);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage toCompatibleImage(BufferedImage image) {
        if (GraphicsUtilities.isHeadless()) {
            return image;
        }
        if (image.getColorModel().equals(GraphicsUtilities.getGraphicsConfiguration().getColorModel())) {
            return image;
        }
        BufferedImage compatibleImage = GraphicsUtilities.getGraphicsConfiguration().createCompatibleImage(image.getWidth(), image.getHeight(), image.getTransparency());
        Graphics g2 = compatibleImage.getGraphics();
        try {
            g2.drawImage(image, 0, 0, null);
        }
        finally {
            g2.dispose();
        }
        return compatibleImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage createThumbnailFast(BufferedImage image, int newSize) {
        int height;
        int width = image.getWidth();
        if (width > (height = image.getHeight())) {
            if (newSize >= width) {
                throw new IllegalArgumentException("newSize must be lower than the image width");
            }
            if (newSize <= 0) {
                throw new IllegalArgumentException("newSize must be greater than 0");
            }
            float ratio = (float)width / (float)height;
            width = newSize;
            height = (int)((float)newSize / ratio);
        } else {
            if (newSize >= height) {
                throw new IllegalArgumentException("newSize must be lower than the image height");
            }
            if (newSize <= 0) {
                throw new IllegalArgumentException("newSize must be greater than 0");
            }
            float ratio = (float)height / (float)width;
            height = newSize;
            width = (int)((float)newSize / ratio);
        }
        BufferedImage temp = GraphicsUtilities.createCompatibleImage(image, width, height);
        Graphics2D g2 = temp.createGraphics();
        try {
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g2.drawImage(image, 0, 0, temp.getWidth(), temp.getHeight(), null);
        }
        finally {
            g2.dispose();
        }
        return temp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage createThumbnailFast(BufferedImage image, int newWidth, int newHeight) {
        if (newWidth >= image.getWidth() || newHeight >= image.getHeight()) {
            throw new IllegalArgumentException("newWidth and newHeight cannot be greater than the image dimensions");
        }
        if (newWidth <= 0 || newHeight <= 0) {
            throw new IllegalArgumentException("newWidth and newHeight must be greater than 0");
        }
        BufferedImage temp = GraphicsUtilities.createCompatibleImage(image, newWidth, newHeight);
        Graphics2D g2 = temp.createGraphics();
        try {
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g2.drawImage(image, 0, 0, temp.getWidth(), temp.getHeight(), null);
        }
        finally {
            g2.dispose();
        }
        return temp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage createThumbnail(BufferedImage image, int newSize) {
        boolean isWidthGreater;
        int width = image.getWidth();
        int height = image.getHeight();
        boolean isTranslucent = image.getTransparency() != 1;
        boolean bl = isWidthGreater = width > height;
        if (isWidthGreater) {
            if (newSize >= width) {
                throw new IllegalArgumentException("newSize must be lower than the image width");
            }
        } else if (newSize >= height) {
            throw new IllegalArgumentException("newSize must be lower than the image height");
        }
        if (newSize <= 0) {
            throw new IllegalArgumentException("newSize must be greater than 0");
        }
        float ratioWH = (float)width / (float)height;
        float ratioHW = (float)height / (float)width;
        BufferedImage thumb = image;
        BufferedImage temp = null;
        Graphics g2 = null;
        try {
            int previousWidth = width;
            int previousHeight = height;
            do {
                if (isWidthGreater) {
                    if ((width /= 2) < newSize) {
                        width = newSize;
                    }
                    height = (int)((float)width / ratioWH);
                } else {
                    if ((height /= 2) < newSize) {
                        height = newSize;
                    }
                    width = (int)((float)height / ratioHW);
                }
                if (temp == null || isTranslucent) {
                    if (g2 != null) {
                        g2.dispose();
                    }
                    temp = GraphicsUtilities.createCompatibleImage(image, width, height);
                    g2 = temp.createGraphics();
                    ((Graphics2D)g2).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                }
                g2.drawImage(thumb, 0, 0, width, height, 0, 0, previousWidth, previousHeight, null);
                previousWidth = width;
                previousHeight = height;
                thumb = temp;
            } while (newSize != (isWidthGreater ? width : height));
        }
        finally {
            g2.dispose();
        }
        if (width != thumb.getWidth() || height != thumb.getHeight()) {
            temp = GraphicsUtilities.createCompatibleImage(image, width, height);
            g2 = temp.createGraphics();
            try {
                ((Graphics2D)g2).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                g2.drawImage(thumb, 0, 0, width, height, 0, 0, width, height, null);
            }
            finally {
                g2.dispose();
            }
            thumb = temp;
        }
        return thumb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage createThumbnail(BufferedImage image, int newWidth, int newHeight) {
        boolean isTranslucent;
        int width = image.getWidth();
        int height = image.getHeight();
        boolean bl = isTranslucent = image.getTransparency() != 1;
        if (newWidth >= width || newHeight >= height) {
            throw new IllegalArgumentException("newWidth and newHeight cannot be greater than the image dimensions");
        }
        if (newWidth <= 0 || newHeight <= 0) {
            throw new IllegalArgumentException("newWidth and newHeight must be greater than 0");
        }
        BufferedImage thumb = image;
        BufferedImage temp = null;
        Graphics g2 = null;
        try {
            int previousWidth = width;
            int previousHeight = height;
            do {
                if (width > newWidth && (width /= 2) < newWidth) {
                    width = newWidth;
                }
                if (height > newHeight && (height /= 2) < newHeight) {
                    height = newHeight;
                }
                if (temp == null || isTranslucent) {
                    if (g2 != null) {
                        g2.dispose();
                    }
                    temp = GraphicsUtilities.createCompatibleImage(image, width, height);
                    g2 = temp.createGraphics();
                    ((Graphics2D)g2).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                }
                g2.drawImage(thumb, 0, 0, width, height, 0, 0, previousWidth, previousHeight, null);
                previousWidth = width;
                previousHeight = height;
                thumb = temp;
            } while (width != newWidth || height != newHeight);
        }
        finally {
            g2.dispose();
        }
        if (width != thumb.getWidth() || height != thumb.getHeight()) {
            temp = GraphicsUtilities.createCompatibleImage(image, width, height);
            g2 = temp.createGraphics();
            try {
                ((Graphics2D)g2).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                g2.drawImage(thumb, 0, 0, width, height, 0, 0, width, height, null);
            }
            finally {
                g2.dispose();
            }
            thumb = temp;
        }
        return thumb;
    }

    public static int[] getPixels(BufferedImage img, int x, int y, int w, int h2, int[] pixels) {
        if (w == 0 || h2 == 0) {
            return new int[0];
        }
        if (pixels == null) {
            pixels = new int[w * h2];
        } else if (pixels.length < w * h2) {
            throw new IllegalArgumentException("pixels array must have a length >= w*h");
        }
        int imageType = img.getType();
        if (imageType == 2 || imageType == 1) {
            WritableRaster raster = img.getRaster();
            return (int[])raster.getDataElements(x, y, w, h2, pixels);
        }
        return img.getRGB(x, y, w, h2, pixels, 0, w);
    }

    public static void setPixels(BufferedImage img, int x, int y, int w, int h2, int[] pixels) {
        if (pixels == null || w == 0 || h2 == 0) {
            return;
        }
        if (pixels.length < w * h2) {
            throw new IllegalArgumentException("pixels array must have a length >= w*h");
        }
        int imageType = img.getType();
        if (imageType == 2 || imageType == 1) {
            WritableRaster raster = img.getRaster();
            raster.setDataElements(x, y, w, h2, pixels);
        } else {
            img.setRGB(x, y, w, h2, pixels, 0, w);
        }
    }

    public static Shape mergeClip(Graphics g2, Shape clip) {
        Shape oldClip = g2.getClip();
        if (oldClip == null) {
            g2.setClip(clip);
            return null;
        }
        Area area = new Area(oldClip);
        area.intersect(new Area(clip));
        g2.setClip(area);
        return oldClip;
    }
}

