/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.image;

import java.awt.image.BufferedImage;
import org.jdesktop.swingx.graphics.GraphicsUtilities;
import org.jdesktop.swingx.image.AbstractFilter;

public class FastBlurFilter
extends AbstractFilter {
    private final int radius;

    public FastBlurFilter() {
        this(3);
    }

    public FastBlurFilter(int radius) {
        if (radius < 1) {
            radius = 1;
        }
        this.radius = radius;
    }

    public int getRadius() {
        return this.radius;
    }

    public BufferedImage filter(BufferedImage src, BufferedImage dst) {
        int width = src.getWidth();
        int height = src.getHeight();
        if (dst == null) {
            dst = this.createCompatibleDestImage(src, null);
        }
        int[] srcPixels = new int[width * height];
        int[] dstPixels = new int[width * height];
        GraphicsUtilities.getPixels(src, 0, 0, width, height, srcPixels);
        FastBlurFilter.blur(srcPixels, dstPixels, width, height, this.radius);
        FastBlurFilter.blur(dstPixels, srcPixels, height, width, this.radius);
        GraphicsUtilities.setPixels(dst, 0, 0, width, height, srcPixels);
        return dst;
    }

    static void blur(int[] srcPixels, int[] dstPixels, int width, int height, int radius) {
        int i2;
        int windowSize = radius * 2 + 1;
        int radiusPlusOne = radius + 1;
        int srcIndex = 0;
        int[] sumLookupTable = new int[256 * windowSize];
        for (int i3 = 0; i3 < sumLookupTable.length; ++i3) {
            sumLookupTable[i3] = i3 / windowSize;
        }
        int[] indexLookupTable = new int[radiusPlusOne];
        if (radius < width) {
            for (i2 = 0; i2 < indexLookupTable.length; ++i2) {
                indexLookupTable[i2] = i2;
            }
        } else {
            for (i2 = 0; i2 < width; ++i2) {
                indexLookupTable[i2] = i2;
            }
            for (i2 = width; i2 < indexLookupTable.length; ++i2) {
                indexLookupTable[i2] = width - 1;
            }
        }
        for (int y = 0; y < height; ++y) {
            int sumBlue = 0;
            int sumGreen = 0;
            int sumRed = 0;
            int sumAlpha = 0;
            int dstIndex = y;
            int pixel = srcPixels[srcIndex];
            sumAlpha += radiusPlusOne * (pixel >> 24 & 0xFF);
            sumRed += radiusPlusOne * (pixel >> 16 & 0xFF);
            sumGreen += radiusPlusOne * (pixel >> 8 & 0xFF);
            sumBlue += radiusPlusOne * (pixel & 0xFF);
            for (int i4 = 1; i4 <= radius; ++i4) {
                pixel = srcPixels[srcIndex + indexLookupTable[i4]];
                sumAlpha += pixel >> 24 & 0xFF;
                sumRed += pixel >> 16 & 0xFF;
                sumGreen += pixel >> 8 & 0xFF;
                sumBlue += pixel & 0xFF;
            }
            for (int x = 0; x < width; ++x) {
                int previousPixelIndex;
                dstPixels[dstIndex] = sumLookupTable[sumAlpha] << 24 | sumLookupTable[sumRed] << 16 | sumLookupTable[sumGreen] << 8 | sumLookupTable[sumBlue];
                dstIndex += height;
                int nextPixelIndex = x + radiusPlusOne;
                if (nextPixelIndex >= width) {
                    nextPixelIndex = width - 1;
                }
                if ((previousPixelIndex = x - radius) < 0) {
                    previousPixelIndex = 0;
                }
                int nextPixel = srcPixels[srcIndex + nextPixelIndex];
                int previousPixel = srcPixels[srcIndex + previousPixelIndex];
                sumAlpha += nextPixel >> 24 & 0xFF;
                sumAlpha -= previousPixel >> 24 & 0xFF;
                sumRed += nextPixel >> 16 & 0xFF;
                sumRed -= previousPixel >> 16 & 0xFF;
                sumGreen += nextPixel >> 8 & 0xFF;
                sumGreen -= previousPixel >> 8 & 0xFF;
                sumBlue += nextPixel & 0xFF;
                sumBlue -= previousPixel & 0xFF;
            }
            srcIndex += width;
        }
    }
}

