/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.layout;

import org.xhtmlrenderer.css.constants.CSSName;
import org.xhtmlrenderer.css.constants.IdentValue;
import org.xhtmlrenderer.css.style.CalculatedStyle;
import org.xhtmlrenderer.util.Uu;

public class TextUtil {
    public static String transformText(String text, CalculatedStyle style) {
        IdentValue fontVariant;
        IdentValue transform = style.getIdent(CSSName.TEXT_TRANSFORM);
        if (transform == IdentValue.LOWERCASE) {
            text = text.toLowerCase();
        }
        if (transform == IdentValue.UPPERCASE) {
            text = text.toUpperCase();
        }
        if (transform == IdentValue.CAPITALIZE) {
            text = TextUtil.capitalizeWords(text);
        }
        if ((fontVariant = style.getIdent(CSSName.FONT_VARIANT)) == IdentValue.SMALL_CAPS) {
            text = text.toUpperCase();
        }
        return text;
    }

    private static String capitalizeWords(String text) {
        if (text.length() == 0) {
            return text;
        }
        StringBuffer sb = new StringBuffer();
        boolean cap = true;
        for (int i2 = 0; i2 < text.length(); ++i2) {
            String ch = text.substring(i2, i2 + 1);
            if (cap) {
                sb.append(ch.toUpperCase());
            } else {
                sb.append(ch);
            }
            cap = false;
            if (!ch.equals(" ")) continue;
            cap = true;
        }
        if (sb.toString().length() != text.length()) {
            Uu.p("error! to strings arent the same length = -" + sb.toString() + "-" + text + "-");
        }
        return sb.toString();
    }
}

