/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.newtable;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.newtable.ColumnData;
import org.xhtmlrenderer.newtable.RowData;
import org.xhtmlrenderer.newtable.TableBox;
import org.xhtmlrenderer.newtable.TableCellBox;
import org.xhtmlrenderer.newtable.TableRowBox;
import org.xhtmlrenderer.render.BlockBox;
import org.xhtmlrenderer.render.RenderingContext;

public class TableSectionBox
extends BlockBox {
    private List _grid = new ArrayList();
    private boolean _needCellWidthCalc;
    private boolean _needCellRecalc;
    private boolean _footer;
    private boolean _header;
    private boolean _capturedOriginalAbsY;
    private int _originalAbsY;

    public BlockBox copyOf() {
        TableSectionBox result = new TableSectionBox();
        result.setStyle(this.getStyle());
        result.setElement(this.getElement());
        return result;
    }

    public List getGrid() {
        return this._grid;
    }

    public void setGrid(List grid) {
        this._grid = grid;
    }

    public void extendGridToColumnCount(int columnCount) {
        Iterator i2 = this._grid.iterator();
        while (i2.hasNext()) {
            RowData row = (RowData)i2.next();
            row.extendToColumnCount(columnCount);
        }
    }

    public void splitColumn(int pos) {
        Iterator i2 = this._grid.iterator();
        while (i2.hasNext()) {
            RowData row = (RowData)i2.next();
            row.splitColumn(pos);
        }
    }

    public void recalcCells(LayoutContext c2) {
        int cRow = 0;
        this._grid.clear();
        this.ensureChildren(c2);
        Iterator i2 = this.getChildIterator();
        while (i2.hasNext()) {
            TableRowBox row = (TableRowBox)i2.next();
            row.ensureChildren(c2);
            Iterator j2 = row.getChildIterator();
            while (j2.hasNext()) {
                TableCellBox cell = (TableCellBox)j2.next();
                this.addCell(row, cell, cRow);
            }
            ++cRow;
        }
    }

    public void calcBorders(LayoutContext c2) {
        this.ensureChildren(c2);
        Iterator i2 = this.getChildIterator();
        while (i2.hasNext()) {
            TableRowBox row = (TableRowBox)i2.next();
            row.ensureChildren(c2);
            Iterator j2 = row.getChildIterator();
            while (j2.hasNext()) {
                TableCellBox cell = (TableCellBox)j2.next();
                cell.calcCollapsedBorder(c2);
            }
        }
    }

    public TableCellBox cellAt(int row, int col) {
        if (row >= this._grid.size()) {
            return null;
        }
        RowData rowData = (RowData)this._grid.get(row);
        if (col >= rowData.getRow().size()) {
            return null;
        }
        return (TableCellBox)rowData.getRow().get(col);
    }

    private void setCellAt(int row, int col, TableCellBox cell) {
        ((RowData)this._grid.get(row)).getRow().set(col, cell);
    }

    private void ensureRows(int numRows) {
        int nCols = this.getTable().numEffCols();
        for (int nRows = this._grid.size(); nRows < numRows; ++nRows) {
            RowData row = new RowData();
            row.extendToColumnCount(nCols);
            this._grid.add(row);
        }
    }

    private TableBox getTable() {
        return (TableBox)this.getParent();
    }

    protected void layoutChildren(LayoutContext c2, int contentStart) {
        if (this.isNeedCellRecalc()) {
            this.recalcCells(c2);
            this.setNeedCellRecalc(false);
        }
        if (this.isNeedCellWidthCalc()) {
            this.setCellWidths(c2);
            this.setNeedCellWidthCalc(false);
        }
        super.layoutChildren(c2, contentStart);
    }

    private void addCell(TableRowBox row, TableCellBox cell, int cRow) {
        int cCol;
        int rSpan = cell.getStyle().getRowSpan();
        int cSpan = cell.getStyle().getColSpan();
        List columns = this.getTable().getColumns();
        int nCols = columns.size();
        this.ensureRows(cRow + rSpan);
        for (cCol = 0; cCol < nCols && this.cellAt(cRow, cCol) != null; ++cCol) {
        }
        int col = cCol;
        TableCellBox set = cell;
        while (cSpan > 0) {
            while (cCol >= this.getTable().getColumns().size()) {
                this.getTable().appendColumn(1);
            }
            ColumnData cData = (ColumnData)columns.get(cCol);
            if (cSpan < cData.getSpan()) {
                this.getTable().splitColumn(cCol, cSpan);
            }
            cData = (ColumnData)columns.get(cCol);
            int currentSpan = cData.getSpan();
            for (int r = 0; r < rSpan; ++r) {
                if (this.cellAt(cRow + r, cCol) != null) continue;
                this.setCellAt(cRow + r, cCol, set);
            }
            ++cCol;
            cSpan -= currentSpan;
            set = TableCellBox.SPANNING_CELL;
        }
        cell.setRow(cRow);
        cell.setCol(this.getTable().effColToCol(col));
    }

    public void reset(LayoutContext c2) {
        super.reset(c2);
        this._grid.clear();
        this.setNeedCellWidthCalc(true);
        this.setNeedCellRecalc(true);
        this.setCapturedOriginalAbsY(false);
    }

    void setCellWidths(LayoutContext c2) {
        int[] columnPos = this.getTable().getColumnPos();
        Iterator i2 = this._grid.iterator();
        while (i2.hasNext()) {
            RowData row = (RowData)i2.next();
            List cols = row.getRow();
            int hspacing = this.getTable().getStyle().getBorderHSpacing(c2);
            for (int j2 = 0; j2 < cols.size(); ++j2) {
                TableCellBox cell = (TableCellBox)cols.get(j2);
                if (cell == null || cell == TableCellBox.SPANNING_CELL) continue;
                int endCol = j2;
                for (int cspan = cell.getStyle().getColSpan(); cspan > 0 && endCol < cols.size(); cspan -= this.getTable().spanOfEffCol(endCol), ++endCol) {
                }
                int w = columnPos[endCol] - columnPos[j2] - hspacing;
                cell.setLayoutWidth(c2, w);
                cell.setX(columnPos[j2] + hspacing);
            }
        }
    }

    public boolean isAutoHeight() {
        return true;
    }

    public int numRows() {
        return this._grid.size();
    }

    protected boolean isSkipWhenCollapsingMargins() {
        return true;
    }

    public void paintBorder(RenderingContext c2) {
    }

    public void paintBackground(RenderingContext c2) {
    }

    public TableRowBox getLastRow() {
        if (this.getChildCount() > 0) {
            return (TableRowBox)this.getChild(this.getChildCount() - 1);
        }
        return null;
    }

    boolean isNeedCellWidthCalc() {
        return this._needCellWidthCalc;
    }

    void setNeedCellWidthCalc(boolean needCellWidthCalc) {
        this._needCellWidthCalc = needCellWidthCalc;
    }

    private boolean isNeedCellRecalc() {
        return this._needCellRecalc;
    }

    private void setNeedCellRecalc(boolean needCellRecalc) {
        this._needCellRecalc = needCellRecalc;
    }

    public void layout(LayoutContext c2, int contentStart) {
        boolean running;
        boolean bl = running = c2.isPrint() && (this.isHeader() || this.isFooter()) && this.getTable().getStyle().isPaginateTable();
        if (running) {
            c2.setNoPageBreak(c2.getNoPageBreak() + 1);
        }
        super.layout(c2, contentStart);
        if (running) {
            c2.setNoPageBreak(c2.getNoPageBreak() - 1);
        }
    }

    public boolean isFooter() {
        return this._footer;
    }

    public void setFooter(boolean footer) {
        this._footer = footer;
    }

    public boolean isHeader() {
        return this._header;
    }

    public void setHeader(boolean header) {
        this._header = header;
    }

    public boolean isCapturedOriginalAbsY() {
        return this._capturedOriginalAbsY;
    }

    public void setCapturedOriginalAbsY(boolean capturedOriginalAbsY) {
        this._capturedOriginalAbsY = capturedOriginalAbsY;
    }

    public int getOriginalAbsY() {
        return this._originalAbsY;
    }

    public void setOriginalAbsY(int originalAbsY) {
        this._originalAbsY = originalAbsY;
    }
}

