/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.pdf;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xhtmlrenderer.extend.FSImage;
import org.xhtmlrenderer.extend.ReplacedElement;
import org.xhtmlrenderer.extend.ReplacedElementFactory;
import org.xhtmlrenderer.extend.UserAgentCallback;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.pdf.BookmarkElement;
import org.xhtmlrenderer.pdf.ITextImageElement;
import org.xhtmlrenderer.pdf.ITextOutputDevice;
import org.xhtmlrenderer.pdf.RadioButtonFormField;
import org.xhtmlrenderer.render.BlockBox;
import org.xhtmlrenderer.simple.extend.FormSubmissionListener;

public class ITextReplacedElementFactory
implements ReplacedElementFactory {
    private ITextOutputDevice _outputDevice;
    private Map _radioButtonsByElem = new HashMap();
    private Map _radioButtonsByName = new HashMap();

    public ITextReplacedElementFactory(ITextOutputDevice outputDevice) {
        this._outputDevice = outputDevice;
    }

    public ReplacedElement createReplacedElement(LayoutContext c2, BlockBox box, UserAgentCallback uac, int cssWidth, int cssHeight) {
        Element e2 = box.getElement();
        if (e2 == null) {
            return null;
        }
        String nodeName = e2.getNodeName();
        if (nodeName.equals("img")) {
            FSImage fsImage = uac.getImageResource(e2.getAttribute("src")).getImage();
            if (fsImage != null) {
                if (cssWidth != -1 || cssHeight != -1) {
                    fsImage.scale(cssWidth, cssHeight);
                }
                return new ITextImageElement(fsImage);
            }
        } else if (nodeName.equals("bookmark")) {
            BookmarkElement result = new BookmarkElement();
            if (e2.hasAttribute("name")) {
                String name = e2.getAttribute("name");
                c2.addBoxId(name, box);
                result.setAnchorName(name);
            }
            return result;
        }
        return null;
    }

    private boolean isTextarea(Element e2) {
        if (!e2.getNodeName().equals("textarea")) {
            return false;
        }
        Node n = e2.getFirstChild();
        while (n != null) {
            short nodeType = n.getNodeType();
            if (nodeType == 3 || nodeType == 4) continue;
            return false;
        }
        return true;
    }

    private void saveResult(Element e2, RadioButtonFormField result) {
        this._radioButtonsByElem.put(e2, result);
        String fieldName = result.getFieldName(this._outputDevice, e2);
        ArrayList<RadioButtonFormField> fields = (ArrayList<RadioButtonFormField>)this._radioButtonsByName.get(fieldName);
        if (fields == null) {
            fields = new ArrayList<RadioButtonFormField>();
            this._radioButtonsByName.put(fieldName, fields);
        }
        fields.add(result);
    }

    public void reset() {
        this._radioButtonsByElem = new HashMap();
        this._radioButtonsByName = new HashMap();
    }

    public void remove(Element e2) {
        String fieldName;
        List values;
        RadioButtonFormField field = (RadioButtonFormField)this._radioButtonsByElem.remove(e2);
        if (field != null && (values = (List)this._radioButtonsByName.get(fieldName = field.getFieldName(this._outputDevice, e2))) != null) {
            values.remove(field);
            if (values.size() == 0) {
                this._radioButtonsByName.remove(fieldName);
            }
        }
    }

    public void remove(String fieldName) {
        List values = (List)this._radioButtonsByName.get(fieldName);
        if (values != null) {
            Iterator i2 = values.iterator();
            while (i2.hasNext()) {
                RadioButtonFormField field = (RadioButtonFormField)i2.next();
                this._radioButtonsByElem.remove(field.getBox().getElement());
            }
        }
        this._radioButtonsByName.remove(fieldName);
    }

    public List getRadioButtons(String name) {
        return (List)this._radioButtonsByName.get(name);
    }

    public void setFormSubmissionListener(FormSubmissionListener listener) {
    }
}

