/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.render;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.xhtmlrenderer.css.constants.CSSName;
import org.xhtmlrenderer.css.constants.IdentValue;
import org.xhtmlrenderer.css.newmatch.CascadedStyle;
import org.xhtmlrenderer.css.parser.FSRGBColor;
import org.xhtmlrenderer.css.style.CalculatedStyle;
import org.xhtmlrenderer.css.style.CssContext;
import org.xhtmlrenderer.css.style.FSDerivedValue;
import org.xhtmlrenderer.css.style.derived.BorderPropertySet;
import org.xhtmlrenderer.css.style.derived.LengthValue;
import org.xhtmlrenderer.css.style.derived.RectPropertySet;
import org.xhtmlrenderer.extend.FSImage;
import org.xhtmlrenderer.extend.ReplacedElement;
import org.xhtmlrenderer.layout.BlockBoxing;
import org.xhtmlrenderer.layout.BlockFormattingContext;
import org.xhtmlrenderer.layout.BoxBuilder;
import org.xhtmlrenderer.layout.BreakAtLineContext;
import org.xhtmlrenderer.layout.CounterFunction;
import org.xhtmlrenderer.layout.FloatManager;
import org.xhtmlrenderer.layout.InlineBoxing;
import org.xhtmlrenderer.layout.InlinePaintable;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.layout.PaintingInfo;
import org.xhtmlrenderer.layout.PersistentBFC;
import org.xhtmlrenderer.layout.Styleable;
import org.xhtmlrenderer.newtable.TableRowBox;
import org.xhtmlrenderer.render.AnonymousBlockBox;
import org.xhtmlrenderer.render.Box;
import org.xhtmlrenderer.render.ContentLimit;
import org.xhtmlrenderer.render.ContentLimitContainer;
import org.xhtmlrenderer.render.FloatedBoxData;
import org.xhtmlrenderer.render.InlineBox;
import org.xhtmlrenderer.render.InlineLayoutBox;
import org.xhtmlrenderer.render.LineBox;
import org.xhtmlrenderer.render.ListItemPainter;
import org.xhtmlrenderer.render.MarkerData;
import org.xhtmlrenderer.render.PageBox;
import org.xhtmlrenderer.render.RenderingContext;
import org.xhtmlrenderer.render.StrutMetrics;

public class BlockBox
extends Box
implements InlinePaintable {
    public static final int POSITION_VERTICALLY = 1;
    public static final int POSITION_HORIZONTALLY = 2;
    public static final int POSITION_BOTH = 3;
    public static final int CONTENT_UNKNOWN = 0;
    public static final int CONTENT_INLINE = 1;
    public static final int CONTENT_BLOCK = 2;
    public static final int CONTENT_EMPTY = 4;
    protected static final int NO_BASELINE = Integer.MIN_VALUE;
    private MarkerData _markerData;
    private int _listCounter;
    private PersistentBFC _persistentBFC;
    private Box _staticEquivalent;
    private boolean _needPageClear;
    private ReplacedElement _replacedElement;
    private int _childrenContentType;
    private List _inlineContent;
    private boolean _topMarginCalculated;
    private boolean _bottomMarginCalculated;
    private MarginCollapseResult _pendingCollapseCalculation;
    private int _minWidth;
    private int _maxWidth;
    private boolean _minMaxCalculated;
    private boolean _dimensionsCalculated;
    private boolean _needShrinkToFitCalculatation;
    private CascadedStyle _firstLineStyle;
    private CascadedStyle _firstLetterStyle;
    private FloatedBoxData _floatedBoxData;
    private int _childrenHeight;
    private boolean _fromCaptionedTable;

    public BlockBox copyOf() {
        BlockBox result = new BlockBox();
        result.setStyle(this.getStyle());
        result.setElement(this.getElement());
        return result;
    }

    protected String getExtraBoxDescription() {
        return "";
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        String className = this.getClass().getName();
        result.append(className.substring(className.lastIndexOf(46) + 1));
        result.append(": ");
        if (this.getElement() != null && !this.isAnonymous()) {
            result.append("<");
            result.append(this.getElement().getNodeName());
            result.append("> ");
        }
        if (this.isAnonymous()) {
            result.append("(anonymous) ");
        }
        if (this.getPseudoElementOrClass() != null) {
            result.append(':');
            result.append(this.getPseudoElementOrClass());
            result.append(' ');
        }
        result.append('(');
        result.append(this.getStyle().getIdent(CSSName.DISPLAY).toString());
        result.append(") ");
        if (this.getStyle().isRunning()) {
            result.append("(running) ");
        }
        result.append('(');
        switch (this.getChildrenContentType()) {
            case 2: {
                result.append('B');
                break;
            }
            case 1: {
                result.append('I');
                break;
            }
            case 4: {
                result.append('E');
            }
        }
        result.append(") ");
        result.append(this.getExtraBoxDescription());
        this.appendPositioningInfo(result);
        result.append("(" + this.getAbsX() + "," + this.getAbsY() + ")->(" + this.getWidth() + " x " + this.getHeight() + ")");
        return result.toString();
    }

    protected void appendPositioningInfo(StringBuffer result) {
        if (this.getStyle().isRelative()) {
            result.append("(relative) ");
        }
        if (this.getStyle().isFixed()) {
            result.append("(fixed) ");
        }
        if (this.getStyle().isAbsolute()) {
            result.append("(absolute) ");
        }
        if (this.getStyle().isFloated()) {
            result.append("(floated) ");
        }
    }

    public String dump(LayoutContext c2, String indent, int which) {
        StringBuffer result = new StringBuffer(indent);
        this.ensureChildren(c2);
        result.append(this);
        RectPropertySet margin = this.getMargin(c2);
        result.append(" effMargin=[" + margin.top() + ", " + margin.right() + ", " + margin.bottom() + ", " + margin.right() + "] ");
        RectPropertySet styleMargin = this.getStyleMargin(c2);
        result.append(" styleMargin=[" + styleMargin.top() + ", " + styleMargin.right() + ", " + styleMargin.bottom() + ", " + styleMargin.right() + "] ");
        if (this.getChildrenContentType() != 4) {
            result.append('\n');
        }
        switch (this.getChildrenContentType()) {
            case 2: {
                this.dumpBoxes(c2, indent, this.getChildren(), which, result);
                break;
            }
            case 1: {
                if (which == 2) {
                    this.dumpBoxes(c2, indent, this.getChildren(), which, result);
                    break;
                }
                Iterator i2 = this.getInlineContent().iterator();
                while (i2.hasNext()) {
                    Styleable styleable = (Styleable)i2.next();
                    if (styleable instanceof BlockBox) {
                        BlockBox b2 = (BlockBox)styleable;
                        result.append(b2.dump(c2, indent + "  ", which));
                        if (result.charAt(result.length() - 1) == '\n') {
                            result.deleteCharAt(result.length() - 1);
                        }
                    } else {
                        result.append(indent + "  ");
                        result.append(styleable.toString());
                    }
                    if (!i2.hasNext()) continue;
                    result.append('\n');
                }
                break;
            }
        }
        return result.toString();
    }

    public void paintListMarker(RenderingContext c2) {
        if (!this.getStyle().isVisible()) {
            return;
        }
        if (this.getStyle().isListItem()) {
            ListItemPainter.paint(c2, this);
        }
    }

    public Rectangle getPaintingClipEdge(CssContext cssCtx) {
        Rectangle result = super.getPaintingClipEdge(cssCtx);
        if (this.getStyle().isListItem()) {
            int delta = result.x;
            result.x = 0;
            result.width += delta;
        }
        return result;
    }

    public void paintInline(RenderingContext c2) {
        if (!this.getStyle().isVisible()) {
            return;
        }
        this.getContainingLayer().paintAsLayer(c2, this);
    }

    public boolean isInline() {
        Box parent = this.getParent();
        return parent instanceof LineBox || parent instanceof InlineLayoutBox;
    }

    public LineBox getLineBox() {
        if (!this.isInline()) {
            return null;
        }
        Box b2 = this.getParent();
        while (!(b2 instanceof LineBox)) {
            b2 = b2.getParent();
        }
        return (LineBox)b2;
    }

    public void paintDebugOutline(RenderingContext c2) {
        c2.getOutputDevice().drawDebugOutline(c2, this, FSRGBColor.RED);
    }

    public MarkerData getMarkerData() {
        return this._markerData;
    }

    public void setMarkerData(MarkerData markerData) {
        this._markerData = markerData;
    }

    public void createMarkerData(LayoutContext c2) {
        if (this.getMarkerData() != null) {
            return;
        }
        StrutMetrics strutMetrics = InlineBoxing.createDefaultStrutMetrics(c2, this);
        boolean imageMarker = false;
        MarkerData result = new MarkerData();
        result.setStructMetrics(strutMetrics);
        CalculatedStyle style = this.getStyle();
        IdentValue listStyle = style.getIdent(CSSName.LIST_STYLE_TYPE);
        String image = style.getStringProperty(CSSName.LIST_STYLE_IMAGE);
        if (!image.equals("none")) {
            result.setImageMarker(this.makeImageMarker(c2, strutMetrics, image));
            boolean bl = imageMarker = result.getImageMarker() != null;
        }
        if (listStyle != IdentValue.NONE && !imageMarker) {
            if (listStyle == IdentValue.CIRCLE || listStyle == IdentValue.SQUARE || listStyle == IdentValue.DISC) {
                result.setGlyphMarker(this.makeGlyphMarker(strutMetrics));
            } else {
                result.setTextMarker(this.makeTextMarker(c2, listStyle));
            }
        }
        this.setMarkerData(result);
    }

    private MarkerData.GlyphMarker makeGlyphMarker(StrutMetrics strutMetrics) {
        int diameter = (int)((strutMetrics.getAscent() + strutMetrics.getDescent()) / 3.0f);
        MarkerData.GlyphMarker result = new MarkerData.GlyphMarker();
        result.setDiameter(diameter);
        result.setLayoutWidth(diameter * 3);
        return result;
    }

    private MarkerData.ImageMarker makeImageMarker(LayoutContext c2, StrutMetrics structMetrics, String image) {
        FSImage img = null;
        if (!image.equals("none") && (img = c2.getUac().getImageResource(image).getImage()) != null) {
            StrutMetrics strutMetrics = structMetrics;
            if ((float)img.getHeight() > strutMetrics.getAscent()) {
                img.scale(-1, (int)strutMetrics.getAscent());
            }
            MarkerData.ImageMarker result = new MarkerData.ImageMarker();
            result.setImage(img);
            result.setLayoutWidth(img.getWidth() * 2);
            return result;
        }
        return null;
    }

    private MarkerData.TextMarker makeTextMarker(LayoutContext c2, IdentValue listStyle) {
        int listCounter = this.getListCounter();
        String text = CounterFunction.createCounterText(listStyle, listCounter);
        text = text + ".  ";
        int w = c2.getTextRenderer().getWidth(c2.getFontContext(), this.getStyle().getFSFont(c2), text);
        MarkerData.TextMarker result = new MarkerData.TextMarker();
        result.setText(text);
        result.setLayoutWidth(w);
        return result;
    }

    public int getListCounter() {
        return this._listCounter;
    }

    public void setListCounter(int listCounter) {
        this._listCounter = listCounter;
    }

    public PersistentBFC getPersistentBFC() {
        return this._persistentBFC;
    }

    public void setPersistentBFC(PersistentBFC persistentBFC) {
        this._persistentBFC = persistentBFC;
    }

    public Box getStaticEquivalent() {
        return this._staticEquivalent;
    }

    public void setStaticEquivalent(Box staticEquivalent) {
        this._staticEquivalent = staticEquivalent;
    }

    public boolean isReplaced() {
        return this._replacedElement != null;
    }

    public void calcCanvasLocation() {
        LineBox lineBox;
        if (this.isFloated()) {
            FloatManager manager = this._floatedBoxData.getManager();
            Point offset = manager.getOffset(this);
            this.setAbsX(manager.getMaster().getAbsX() + this.getX() - offset.x);
            this.setAbsY(manager.getMaster().getAbsY() + this.getY() - offset.y);
        }
        if ((lineBox = this.getLineBox()) == null) {
            Box cb;
            Box parent = this.getParent();
            if (parent != null) {
                this.setAbsX(parent.getAbsX() + parent.getTx() + this.getX());
                this.setAbsY(parent.getAbsY() + parent.getTy() + this.getY());
            } else if (this.isStyled() && this.getStyle().isAbsFixedOrInlineBlockEquiv() && (cb = this.getContainingBlock()) != null) {
                this.setAbsX(cb.getAbsX() + this.getX());
                this.setAbsY(cb.getAbsY() + this.getY());
            }
        } else {
            this.setAbsX(lineBox.getAbsX() + this.getX());
            this.setAbsY(lineBox.getAbsY() + this.getY());
        }
        if (this.isReplaced()) {
            Point location = this.getReplacedElement().getLocation();
            if (location.x != this.getAbsX() || location.y != this.getAbsY()) {
                this.getReplacedElement().setLocation(this.getAbsX(), this.getAbsY());
            }
        }
    }

    public void calcInitialFloatedCanvasLocation(LayoutContext c2) {
        Point offset = c2.getBlockFormattingContext().getOffset();
        FloatManager manager = c2.getBlockFormattingContext().getFloatManager();
        this.setAbsX(manager.getMaster().getAbsX() + this.getX() - offset.x);
        this.setAbsY(manager.getMaster().getAbsY() + this.getY() - offset.y);
    }

    public void calcChildLocations() {
        super.calcChildLocations();
        if (this._persistentBFC != null) {
            this._persistentBFC.getFloatManager().calcFloatLocations();
        }
    }

    public boolean isNeedPageClear() {
        return this._needPageClear;
    }

    public void setNeedPageClear(boolean needPageClear) {
        this._needPageClear = needPageClear;
    }

    private void alignToStaticEquivalent() {
        if (this._staticEquivalent.getAbsY() != this.getAbsY()) {
            this.setY(this._staticEquivalent.getAbsY() - this.getAbsY());
            this.setAbsY(this._staticEquivalent.getAbsY());
        }
    }

    public void positionAbsolute(CssContext cssCtx, int direction) {
        CalculatedStyle style = this.getStyle();
        Rectangle boundingBox = null;
        int cbContentHeight = this.getContainingBlock().getContentAreaEdge((int)0, (int)0, (CssContext)cssCtx).height;
        boundingBox = this.getContainingBlock() instanceof BlockBox ? this.getContainingBlock().getPaddingEdge(0, 0, cssCtx) : this.getContainingBlock().getContentAreaEdge(0, 0, cssCtx);
        if ((direction & 2) != 0) {
            this.setX(0);
            if (!style.isIdent(CSSName.LEFT, IdentValue.AUTO)) {
                this.setX((int)style.getFloatPropertyProportionalWidth(CSSName.LEFT, this.getContainingBlock().getContentWidth(), cssCtx));
            } else if (!style.isIdent(CSSName.RIGHT, IdentValue.AUTO)) {
                this.setX(boundingBox.width - (int)style.getFloatPropertyProportionalWidth(CSSName.RIGHT, this.getContainingBlock().getContentWidth(), cssCtx) - this.getWidth());
            }
            this.setX(this.getX() + boundingBox.x);
        }
        if ((direction & 1) != 0) {
            this.setY(0);
            if (!style.isIdent(CSSName.TOP, IdentValue.AUTO)) {
                this.setY((int)style.getFloatPropertyProportionalHeight(CSSName.TOP, cbContentHeight, cssCtx));
            } else if (!style.isIdent(CSSName.BOTTOM, IdentValue.AUTO)) {
                this.setY(boundingBox.height - (int)style.getFloatPropertyProportionalWidth(CSSName.BOTTOM, cbContentHeight, cssCtx) - this.getHeight());
            }
            int pinnedHeight = this.calcPinnedHeight(cssCtx);
            if (pinnedHeight != -1 && this.getCSSHeight(cssCtx) == -1) {
                this.setHeight(pinnedHeight);
                this.applyCSSMinMaxHeight(cssCtx);
            }
            this.setY(this.getY() + boundingBox.y);
        }
        this.calcCanvasLocation();
        if ((direction & 1) != 0 && this.getStyle().isTopAuto() && this.getStyle().isBottomAuto()) {
            this.alignToStaticEquivalent();
        }
        this.calcChildLocations();
    }

    public void positionAbsoluteOnPage(LayoutContext c2) {
        if (c2.isPrint() && (this.getStyle().isForcePageBreakBefore() || this.isNeedPageClear())) {
            this.forcePageBreakBefore(c2, this.getStyle().getIdent(CSSName.PAGE_BREAK_BEFORE), false);
            this.calcCanvasLocation();
            this.calcChildLocations();
            this.setNeedPageClear(false);
        }
    }

    public ReplacedElement getReplacedElement() {
        return this._replacedElement;
    }

    public void setReplacedElement(ReplacedElement replacedElement) {
        this._replacedElement = replacedElement;
    }

    public void reset(LayoutContext c2) {
        super.reset(c2);
        this.setTopMarginCalculated(false);
        this.setBottomMarginCalculated(false);
        this.setDimensionsCalculated(false);
        this.setMinMaxCalculated(false);
        this.setChildrenHeight(0);
        if (this.isReplaced()) {
            this.getReplacedElement().detach(c2);
            this.setReplacedElement(null);
        }
        if (this.getChildrenContentType() == 1) {
            this.removeAllChildren();
        }
        if (this.isFloated()) {
            this._floatedBoxData.getManager().removeFloat(this);
        }
        if (this.getStyle().isRunning()) {
            c2.getRootLayer().removeRunningBlock(this);
        }
    }

    private int calcPinnedContentWidth(CssContext c2) {
        if (!this.getStyle().isIdent(CSSName.LEFT, IdentValue.AUTO) && !this.getStyle().isIdent(CSSName.RIGHT, IdentValue.AUTO)) {
            int right;
            Rectangle paddingEdge = this.getContainingBlock().getPaddingEdge(0, 0, c2);
            int left = (int)this.getStyle().getFloatPropertyProportionalTo(CSSName.LEFT, paddingEdge.width, c2);
            int result = paddingEdge.width - left - (right = (int)this.getStyle().getFloatPropertyProportionalTo(CSSName.RIGHT, paddingEdge.width, c2)) - this.getLeftMBP() - this.getRightMBP();
            return result < 0 ? 0 : result;
        }
        return -1;
    }

    private int calcPinnedHeight(CssContext c2) {
        if (!this.getStyle().isIdent(CSSName.TOP, IdentValue.AUTO) && !this.getStyle().isIdent(CSSName.BOTTOM, IdentValue.AUTO)) {
            int bottom;
            Rectangle paddingEdge = this.getContainingBlock().getPaddingEdge(0, 0, c2);
            int top = (int)this.getStyle().getFloatPropertyProportionalTo(CSSName.TOP, paddingEdge.height, c2);
            int result = paddingEdge.height - top - (bottom = (int)this.getStyle().getFloatPropertyProportionalTo(CSSName.BOTTOM, paddingEdge.height, c2));
            return result < 0 ? 0 : result;
        }
        return -1;
    }

    protected void resolveAutoMargins(LayoutContext c2, int cssWidth, RectPropertySet padding, BorderPropertySet border) {
        int withoutMargins = (int)border.left() + (int)padding.left() + cssWidth + (int)padding.right() + (int)border.right();
        if (withoutMargins < this.getContainingBlockWidth()) {
            int available = this.getContainingBlockWidth() - withoutMargins;
            boolean autoLeft = this.getStyle().isAutoLeftMargin();
            boolean autoRight = this.getStyle().isAutoRightMargin();
            if (autoLeft && autoRight) {
                this.setMarginLeft(c2, available / 2);
                this.setMarginRight(c2, available / 2);
            } else if (autoLeft) {
                this.setMarginLeft(c2, available);
            } else if (autoRight) {
                this.setMarginRight(c2, available);
            }
        }
    }

    public void calcDimensions(LayoutContext c2) {
        this.calcDimensions(c2, this.getCSSWidth(c2));
    }

    protected void calcDimensions(LayoutContext c2, int cssWidth) {
        if (!this.isDimensionsCalculated()) {
            CalculatedStyle style = this.getStyle();
            RectPropertySet padding = this.getPadding(c2);
            BorderPropertySet border = this.getBorder(c2);
            if (cssWidth != -1 && !this.isAnonymous() && (this.getStyle().isIdent(CSSName.MARGIN_LEFT, IdentValue.AUTO) || this.getStyle().isIdent(CSSName.MARGIN_RIGHT, IdentValue.AUTO)) && this.getStyle().isNeedAutoMarginResolution()) {
                this.resolveAutoMargins(c2, cssWidth, padding, border);
            }
            this.recalcMargin(c2);
            RectPropertySet margin = this.getMargin(c2);
            this.setLeftMBP((int)margin.left() + (int)border.left() + (int)padding.left());
            this.setRightMBP((int)padding.right() + (int)border.right() + (int)margin.right());
            this.setContentWidth(this.getContainingBlockWidth() - this.getLeftMBP() - this.getRightMBP());
            this.setHeight(0);
            if (!this.isAnonymous() || this.isFromCaptionedTable() && this.isFloated()) {
                ReplacedElement re;
                int pinnedContentWidth = -1;
                if (cssWidth != -1) {
                    this.setContentWidth(cssWidth);
                } else if ((this.getStyle().isAbsolute() || this.getStyle().isFixed()) && (pinnedContentWidth = this.calcPinnedContentWidth(c2)) != -1) {
                    this.setContentWidth(pinnedContentWidth);
                }
                int cssHeight = this.getCSSHeight(c2);
                if (cssHeight != -1) {
                    this.setHeight(cssHeight);
                }
                if ((re = this.getReplacedElement()) == null) {
                    re = c2.getReplacedElementFactory().createReplacedElement(c2, this, c2.getUac(), cssWidth, cssHeight);
                }
                if (re != null) {
                    this.setContentWidth(re.getIntrinsicWidth());
                    this.setHeight(re.getIntrinsicHeight());
                    this.setReplacedElement(re);
                } else if (cssWidth == -1 && pinnedContentWidth == -1 && (style.isInlineBlock() || style.isFloated() || style.isAbsolute() || style.isFixed())) {
                    this.setNeedShrinkToFitCalculatation(true);
                }
                if (!this.isReplaced()) {
                    this.applyCSSMinMaxWidth(c2);
                }
            }
            this.setDimensionsCalculated(true);
        }
    }

    private void calcClearance(LayoutContext c2) {
        if (this.getStyle().isCleared() && !this.getStyle().isFloated()) {
            c2.translate(0, -this.getY());
            c2.getBlockFormattingContext().clear(c2, this);
            c2.translate(0, this.getY());
            this.calcCanvasLocation();
        }
    }

    private void calcExtraPageClearance(LayoutContext c2) {
        PageBox first;
        if (c2.isPageBreaksAllowed() && c2.getExtraSpaceTop() > 0 && (this.getStyle().isSpecifiedAsBlock() || this.getStyle().isListItem()) && (first = c2.getRootLayer().getFirstPage(c2, this)) != null && first.getTop() + c2.getExtraSpaceTop() > this.getAbsY()) {
            int diff = first.getTop() + c2.getExtraSpaceTop() - this.getAbsY();
            this.setY(this.getY() + diff);
            c2.translate(0, diff);
            this.calcCanvasLocation();
        }
    }

    private void addBoxID(LayoutContext c2) {
        if (!this.isAnonymous()) {
            String id;
            String name = c2.getNamespaceHandler().getAnchorName(this.getElement());
            if (name != null) {
                c2.addBoxId(name, this);
            }
            if ((id = c2.getNamespaceHandler().getID(this.getElement())) != null) {
                c2.addBoxId(id, this);
            }
        }
    }

    public void layout(LayoutContext c2) {
        this.layout(c2, 0);
    }

    public void layout(LayoutContext c2, int contentStart) {
        int delta;
        PageBox firstPage;
        CalculatedStyle style = this.getStyle();
        boolean pushedLayer = false;
        if (this.isRoot() || style.requiresLayer()) {
            pushedLayer = true;
            if (this.getLayer() == null) {
                c2.pushLayer(this);
            } else {
                c2.pushLayer(this.getLayer());
            }
        }
        if (style.isFixedBackground()) {
            c2.getRootLayer().setFixedBackground(true);
        }
        this.calcClearance(c2);
        if (this.isRoot() || this.getStyle().establishesBFC() || this.isMarginAreaRoot()) {
            BlockFormattingContext bfc = new BlockFormattingContext(this, c2);
            c2.pushBFC(bfc);
        }
        this.addBoxID(c2);
        if (c2.isPrint() && this.getStyle().isIdent(CSSName.FS_PAGE_SEQUENCE, IdentValue.START)) {
            c2.getRootLayer().addPageSequence(this);
        }
        this.calcDimensions(c2);
        this.calcShrinkToFitWidthIfNeeded(c2);
        this.collapseMargins(c2);
        this.calcExtraPageClearance(c2);
        if (c2.isPrint() && (firstPage = c2.getRootLayer().getFirstPage(c2, this)) != null && firstPage.getTop() == this.getAbsY() - this.getPageClearance()) {
            this.resetTopMargin(c2);
        }
        BorderPropertySet border = this.getBorder(c2);
        RectPropertySet margin = this.getMargin(c2);
        RectPropertySet padding = this.getPadding(c2);
        int originalHeight = this.getHeight();
        if (!this.isReplaced()) {
            this.setHeight(0);
        }
        boolean didSetMarkerData = false;
        if (this.getStyle().isListItem()) {
            this.createMarkerData(c2);
            c2.setCurrentMarkerData(this.getMarkerData());
            didSetMarkerData = true;
        }
        int tx = (int)margin.left() + (int)border.left() + (int)padding.left();
        int ty = (int)margin.top() + (int)border.top() + (int)padding.top();
        this.setTx(tx);
        this.setTy(ty);
        c2.translate(this.getTx(), this.getTy());
        if (!this.isReplaced()) {
            this.layoutChildren(c2, contentStart);
        } else {
            this.setState(3);
        }
        c2.translate(-this.getTx(), -this.getTy());
        this.setChildrenHeight(this.getHeight());
        if (!this.isReplaced()) {
            if (!this.isAutoHeight() && ((delta = originalHeight - this.getHeight()) > 0 || this.isAllowHeightToShrink())) {
                this.setHeight(originalHeight);
            }
            this.applyCSSMinMaxHeight(c2);
        }
        if ((this.isRoot() || this.getStyle().establishesBFC()) && this.getStyle().isAutoHeight() && (delta = c2.getBlockFormattingContext().getFloatManager().getClearDelta(c2, this.getTy() + this.getHeight())) > 0) {
            this.setHeight(this.getHeight() + delta);
            this.setChildrenHeight(this.getChildrenHeight() + delta);
        }
        if (didSetMarkerData) {
            c2.setCurrentMarkerData(null);
        }
        this.calcLayoutHeight(c2, border, margin, padding);
        if (this.isRoot() || this.getStyle().establishesBFC()) {
            c2.popBFC();
        }
        if (pushedLayer) {
            c2.popLayer();
        }
    }

    protected boolean isAllowHeightToShrink() {
        return true;
    }

    protected int getPageClearance() {
        return 0;
    }

    protected void calcLayoutHeight(LayoutContext c2, BorderPropertySet border, RectPropertySet margin, RectPropertySet padding) {
        this.setHeight(this.getHeight() + ((int)margin.top() + (int)border.top() + (int)padding.top() + (int)padding.bottom() + (int)border.bottom() + (int)margin.bottom()));
        this.setChildrenHeight(this.getChildrenHeight() + ((int)margin.top() + (int)border.top() + (int)padding.top() + (int)padding.bottom() + (int)border.bottom() + (int)margin.bottom()));
    }

    private void calcShrinkToFitWidthIfNeeded(LayoutContext c2) {
        if (this.isNeedShrinkToFitCalculatation()) {
            this.setContentWidth(this.calcShrinkToFitWidth(c2) - this.getLeftMBP() - this.getRightMBP());
            this.applyCSSMinMaxWidth(c2);
            this.setNeedShrinkToFitCalculatation(false);
        }
    }

    private void applyCSSMinMaxWidth(CssContext c2) {
        int cssMinWidth;
        if (!this.getStyle().isMaxWidthNone()) {
            int cssMaxWidth = this.getCSSMaxWidth(c2);
            if (this.getContentWidth() > cssMaxWidth) {
                this.setContentWidth(cssMaxWidth);
            }
        }
        if ((cssMinWidth = this.getCSSMinWidth(c2)) > 0 && this.getContentWidth() < cssMinWidth) {
            this.setContentWidth(cssMinWidth);
        }
    }

    private void applyCSSMinMaxHeight(CssContext c2) {
        int cssMinHeight;
        if (!this.getStyle().isMaxHeightNone()) {
            int cssMaxHeight = this.getCSSMaxHeight(c2);
            if (this.getHeight() > cssMaxHeight) {
                this.setHeight(cssMaxHeight);
            }
        }
        if ((cssMinHeight = this.getCSSMinHeight(c2)) > 0 && this.getHeight() < cssMinHeight) {
            this.setHeight(cssMinHeight);
        }
    }

    public void ensureChildren(LayoutContext c2) {
        if (this.getChildrenContentType() == 0) {
            BoxBuilder.createChildren(c2, this);
        }
    }

    protected void layoutChildren(LayoutContext c2, int contentStart) {
        this.setState(2);
        this.ensureChildren(c2);
        if (this.getFirstLetterStyle() != null) {
            c2.getFirstLettersTracker().addStyle(this.getFirstLetterStyle());
        }
        if (this.getFirstLineStyle() != null) {
            c2.getFirstLinesTracker().addStyle(this.getFirstLineStyle());
        }
        switch (this.getChildrenContentType()) {
            case 1: {
                this.layoutInlineChildren(c2, contentStart, this.calcInitialBreakAtLine(c2), true);
                break;
            }
            case 2: {
                BlockBoxing.layoutContent(c2, this, contentStart);
            }
        }
        if (this.getFirstLetterStyle() != null) {
            c2.getFirstLettersTracker().removeLast();
        }
        if (this.getFirstLineStyle() != null) {
            c2.getFirstLinesTracker().removeLast();
        }
        this.setState(3);
    }

    protected void layoutInlineChildren(LayoutContext c2, int contentStart, int breakAtLine, boolean tryAgain) {
        InlineBoxing.layoutContent(c2, this, contentStart, breakAtLine);
        if (c2.isPrint() && c2.isPageBreaksAllowed() && this.getChildCount() > 1) {
            this.satisfyWidowsAndOrphans(c2, contentStart, tryAgain);
        }
        if (tryAgain && this.getStyle().isTextJustify()) {
            this.justifyText();
        }
    }

    private void justifyText() {
        Iterator i2 = this.getChildIterator();
        while (i2.hasNext()) {
            LineBox line = (LineBox)i2.next();
            line.justify();
        }
    }

    private void satisfyWidowsAndOrphans(LayoutContext c2, int contentStart, boolean tryAgain) {
        LineBox lB;
        int i2;
        LineBox firstLineBox = (LineBox)this.getChild(0);
        PageBox firstPage = c2.getRootLayer().getFirstPage(c2, firstLineBox);
        if (firstPage == null) {
            return;
        }
        int noContentLBs = 0;
        int cCount = this.getChildCount();
        for (i2 = 0; i2 < cCount && (lB = (LineBox)this.getChild(i2)).getAbsY() < firstPage.getBottom(); ++i2) {
            if (lB.isContainsContent()) continue;
            ++noContentLBs;
        }
        if (i2 != cCount) {
            int orphans = (int)this.getStyle().asFloat(CSSName.ORPHANS);
            if (i2 - noContentLBs < orphans) {
                this.setNeedPageClear(true);
            } else {
                LineBox lB2;
                LineBox lastLineBox = (LineBox)this.getChild(cCount - 1);
                List pages = c2.getRootLayer().getPages();
                PageBox lastPage = (PageBox)pages.get(firstPage.getPageNo() + 1);
                while (lastPage.getPageNo() != pages.size() - 1 && lastPage.getBottom() < lastLineBox.getAbsY()) {
                    lastPage = (PageBox)pages.get(lastPage.getPageNo() + 1);
                }
                noContentLBs = 0;
                for (i2 = cCount - 1; i2 >= 0 && ((LineBox)this.getChild(i2)).getAbsY() >= lastPage.getTop() && (lB2 = (LineBox)this.getChild(i2)).getAbsY() >= lastPage.getTop(); --i2) {
                    if (lB2.isContainsContent()) continue;
                    ++noContentLBs;
                }
                int widows = (int)this.getStyle().asFloat(CSSName.WIDOWS);
                if (cCount - 1 - i2 - noContentLBs < widows) {
                    if (cCount - 1 - widows < orphans) {
                        this.setNeedPageClear(true);
                    } else if (tryAgain) {
                        int breakAtLine = cCount - 1 - widows;
                        this.resetChildren(c2);
                        this.removeAllChildren();
                        this.layoutInlineChildren(c2, contentStart, breakAtLine, false);
                    }
                }
            }
        }
    }

    public int getChildrenContentType() {
        return this._childrenContentType;
    }

    public void setChildrenContentType(int contentType) {
        this._childrenContentType = contentType;
    }

    public List getInlineContent() {
        return this._inlineContent;
    }

    public void setInlineContent(List inlineContent) {
        this._inlineContent = inlineContent;
        if (inlineContent != null) {
            Iterator i2 = inlineContent.iterator();
            while (i2.hasNext()) {
                Styleable child = (Styleable)i2.next();
                if (!(child instanceof Box)) continue;
                ((Box)child).setContainingBlock(this);
            }
        }
    }

    protected boolean isSkipWhenCollapsingMargins() {
        return false;
    }

    protected boolean isMayCollapseMarginsWithChildren() {
        return !this.isRoot() && this.getStyle().isMayCollapseMarginsWithChildren();
    }

    private void collapseMargins(LayoutContext c2) {
        if (!this.isTopMarginCalculated() || !this.isBottomMarginCalculated()) {
            this.recalcMargin(c2);
            RectPropertySet margin = this.getMargin(c2);
            if (!this.isTopMarginCalculated() && !this.isBottomMarginCalculated() && this.isVerticalMarginsAdjoin(c2)) {
                MarginCollapseResult collapsedMargin = this._pendingCollapseCalculation != null ? this._pendingCollapseCalculation : new MarginCollapseResult();
                this.collapseEmptySubtreeMargins(c2, collapsedMargin);
                this.setCollapsedBottomMargin(c2, margin, collapsedMargin);
            } else {
                MarginCollapseResult collapsedMargin;
                if (!this.isTopMarginCalculated()) {
                    collapsedMargin = this._pendingCollapseCalculation != null ? this._pendingCollapseCalculation : new MarginCollapseResult();
                    this.collapseTopMargin(c2, true, collapsedMargin);
                    if ((int)margin.top() != collapsedMargin.getMargin()) {
                        this.setMarginTop(c2, collapsedMargin.getMargin());
                    }
                }
                if (!this.isBottomMarginCalculated()) {
                    collapsedMargin = new MarginCollapseResult();
                    this.collapseBottomMargin(c2, true, collapsedMargin);
                    this.setCollapsedBottomMargin(c2, margin, collapsedMargin);
                }
            }
        }
    }

    private void setCollapsedBottomMargin(LayoutContext c2, RectPropertySet margin, MarginCollapseResult collapsedMargin) {
        BlockBox next = null;
        if (!this.isInline()) {
            next = this.getNextCollapsableSibling(collapsedMargin);
        }
        if (next != null && !(next instanceof AnonymousBlockBox) && collapsedMargin.hasMargin()) {
            next._pendingCollapseCalculation = collapsedMargin;
            this.setMarginBottom(c2, 0);
        } else if ((int)margin.bottom() != collapsedMargin.getMargin()) {
            this.setMarginBottom(c2, collapsedMargin.getMargin());
        }
    }

    private BlockBox getNextCollapsableSibling(MarginCollapseResult collapsedMargin) {
        BlockBox next;
        for (next = (BlockBox)this.getNextSibling(); next != null; next = (BlockBox)next.getNextSibling()) {
            if (next instanceof AnonymousBlockBox) {
                ((AnonymousBlockBox)next).provideSiblingMarginToFloats(collapsedMargin.getMargin());
            }
            if (!next.isSkipWhenCollapsingMargins()) break;
        }
        return next;
    }

    private void collapseTopMargin(LayoutContext c2, boolean calculationRoot, MarginCollapseResult result) {
        if (!this.isTopMarginCalculated()) {
            if (!this.isSkipWhenCollapsingMargins()) {
                this.calcDimensions(c2);
                RectPropertySet margin = this.getMargin(c2);
                result.update((int)margin.top());
                if (!calculationRoot && (int)margin.top() != 0) {
                    this.setMarginTop(c2, 0);
                }
                if (this.isMayCollapseMarginsWithChildren() && this.isNoTopPaddingOrBorder(c2)) {
                    this.ensureChildren(c2);
                    if (this.getChildrenContentType() == 2) {
                        Iterator i2 = this.getChildIterator();
                        while (i2.hasNext()) {
                            BlockBox child = (BlockBox)i2.next();
                            child.collapseTopMargin(c2, false, result);
                            if (child.isSkipWhenCollapsingMargins()) continue;
                        }
                    }
                }
            }
            this.setTopMarginCalculated(true);
        }
    }

    private void collapseBottomMargin(LayoutContext c2, boolean calculationRoot, MarginCollapseResult result) {
        if (!this.isBottomMarginCalculated()) {
            if (!this.isSkipWhenCollapsingMargins()) {
                this.calcDimensions(c2);
                RectPropertySet margin = this.getMargin(c2);
                result.update((int)margin.bottom());
                if (!calculationRoot && (int)margin.bottom() != 0) {
                    this.setMarginBottom(c2, 0);
                }
                if (this.isMayCollapseMarginsWithChildren() && !this.getStyle().isTable() && this.isNoBottomPaddingOrBorder(c2)) {
                    this.ensureChildren(c2);
                    if (this.getChildrenContentType() == 2) {
                        for (int i2 = this.getChildCount() - 1; i2 >= 0; --i2) {
                            BlockBox child = (BlockBox)this.getChild(i2);
                            if (child.isSkipWhenCollapsingMargins()) continue;
                            child.collapseBottomMargin(c2, false, result);
                            break;
                        }
                    }
                }
            }
            this.setBottomMarginCalculated(true);
        }
    }

    private boolean isNoTopPaddingOrBorder(LayoutContext c2) {
        RectPropertySet padding = this.getPadding(c2);
        BorderPropertySet border = this.getBorder(c2);
        return (int)padding.top() == 0 && (int)border.top() == 0;
    }

    private boolean isNoBottomPaddingOrBorder(LayoutContext c2) {
        RectPropertySet padding = this.getPadding(c2);
        BorderPropertySet border = this.getBorder(c2);
        return (int)padding.bottom() == 0 && (int)border.bottom() == 0;
    }

    private void collapseEmptySubtreeMargins(LayoutContext c2, MarginCollapseResult result) {
        RectPropertySet margin = this.getMargin(c2);
        result.update((int)margin.top());
        result.update((int)margin.bottom());
        this.setMarginTop(c2, 0);
        this.setTopMarginCalculated(true);
        this.setMarginBottom(c2, 0);
        this.setBottomMarginCalculated(true);
        this.ensureChildren(c2);
        if (this.getChildrenContentType() == 2) {
            Iterator i2 = this.getChildIterator();
            while (i2.hasNext()) {
                BlockBox child = (BlockBox)i2.next();
                child.collapseEmptySubtreeMargins(c2, result);
            }
        }
    }

    private boolean isVerticalMarginsAdjoin(LayoutContext c2) {
        boolean bordersOrPadding;
        CalculatedStyle style = this.getStyle();
        BorderPropertySet borderWidth = style.getBorder(c2);
        RectPropertySet padding = this.getPadding(c2);
        boolean bl = bordersOrPadding = (int)borderWidth.top() != 0 || (int)borderWidth.bottom() != 0 || (int)padding.top() != 0 || (int)padding.bottom() != 0;
        if (bordersOrPadding) {
            return false;
        }
        this.ensureChildren(c2);
        if (this.getChildrenContentType() == 1) {
            return false;
        }
        if (this.getChildrenContentType() == 2) {
            Iterator i2 = this.getChildIterator();
            while (i2.hasNext()) {
                BlockBox child = (BlockBox)i2.next();
                if (!child.isSkipWhenCollapsingMargins() && child.isVerticalMarginsAdjoin(c2)) continue;
                return false;
            }
        }
        return style.asFloat(CSSName.MIN_HEIGHT) == 0.0f && (this.isAutoHeight() || style.asFloat(CSSName.HEIGHT) == 0.0f);
    }

    public boolean isTopMarginCalculated() {
        return this._topMarginCalculated;
    }

    public void setTopMarginCalculated(boolean topMarginCalculated) {
        this._topMarginCalculated = topMarginCalculated;
    }

    public boolean isBottomMarginCalculated() {
        return this._bottomMarginCalculated;
    }

    public void setBottomMarginCalculated(boolean bottomMarginCalculated) {
        this._bottomMarginCalculated = bottomMarginCalculated;
    }

    protected int getCSSWidth(CssContext c2) {
        return this.getCSSWidth(c2, false);
    }

    protected int getCSSWidth(CssContext c2, boolean shrinkingToFit) {
        if (!this.isAnonymous() && !this.getStyle().isAutoWidth()) {
            if (shrinkingToFit && !this.getStyle().isAbsoluteWidth()) {
                return -1;
            }
            int result = (int)this.getStyle().getFloatPropertyProportionalWidth(CSSName.WIDTH, this.getContainingBlock().getContentWidth(), c2);
            return result >= 0 ? result : -1;
        }
        return -1;
    }

    protected int getCSSHeight(CssContext c2) {
        if (!this.isAnonymous() && !this.isAutoHeight()) {
            if (this.getStyle().hasAbsoluteUnit(CSSName.HEIGHT)) {
                return (int)this.getStyle().getFloatPropertyProportionalHeight(CSSName.HEIGHT, 0.0f, c2);
            }
            return (int)this.getStyle().getFloatPropertyProportionalHeight(CSSName.HEIGHT, ((BlockBox)this.getContainingBlock()).getCSSHeight(c2), c2);
        }
        return -1;
    }

    public boolean isAutoHeight() {
        if (this.getStyle().isAutoHeight()) {
            return true;
        }
        if (this.getStyle().hasAbsoluteUnit(CSSName.HEIGHT)) {
            return false;
        }
        Box cb = this.getContainingBlock();
        if (cb.isStyled() && cb instanceof BlockBox) {
            return ((BlockBox)cb).isAutoHeight();
        }
        return !(cb instanceof BlockBox) || !((BlockBox)cb).isInitialContainingBlock();
    }

    private int getCSSMinWidth(CssContext c2) {
        return this.getStyle().getMinWidth(c2, this.getContainingBlockWidth());
    }

    private int getCSSMaxWidth(CssContext c2) {
        return this.getStyle().getMaxWidth(c2, this.getContainingBlockWidth());
    }

    private int getCSSMinHeight(CssContext c2) {
        return this.getStyle().getMinHeight(c2, this.getContainingBlockCSSHeight(c2));
    }

    private int getCSSMaxHeight(CssContext c2) {
        return this.getStyle().getMaxHeight(c2, this.getContainingBlockCSSHeight(c2));
    }

    private int getContainingBlockCSSHeight(CssContext c2) {
        if (!this.getContainingBlock().isStyled() || this.getContainingBlock().getStyle().isAutoHeight()) {
            return 0;
        }
        if (this.getContainingBlock().getStyle().hasAbsoluteUnit(CSSName.HEIGHT)) {
            return (int)this.getContainingBlock().getStyle().getFloatPropertyProportionalTo(CSSName.HEIGHT, 0.0f, c2);
        }
        return 0;
    }

    private int calcShrinkToFitWidth(LayoutContext c2) {
        this.calcMinMaxWidth(c2);
        return Math.min(Math.max(this.getMinWidth(), this.getAvailableWidth(c2)), this.getMaxWidth());
    }

    protected int getAvailableWidth(LayoutContext c2) {
        if (!this.getStyle().isAbsolute()) {
            return this.getContainingBlockWidth();
        }
        int left = 0;
        int right = 0;
        if (!this.getStyle().isIdent(CSSName.LEFT, IdentValue.AUTO)) {
            left = (int)this.getStyle().getFloatPropertyProportionalTo(CSSName.LEFT, this.getContainingBlock().getContentWidth(), c2);
        }
        if (!this.getStyle().isIdent(CSSName.RIGHT, IdentValue.AUTO)) {
            right = (int)this.getStyle().getFloatPropertyProportionalTo(CSSName.RIGHT, this.getContainingBlock().getContentWidth(), c2);
        }
        return this.getContainingBlock().getPaddingWidth(c2) - left - right;
    }

    protected boolean isFixedWidthAdvisoryOnly() {
        return false;
    }

    private void recalcMargin(LayoutContext c2) {
        boolean resetBottom;
        if (this.isTopMarginCalculated() && this.isBottomMarginCalculated()) {
            return;
        }
        FSDerivedValue topMargin = this.getStyle().valueByName(CSSName.MARGIN_TOP);
        boolean resetTop = topMargin instanceof LengthValue && !topMargin.hasAbsoluteUnit();
        FSDerivedValue bottomMargin = this.getStyle().valueByName(CSSName.MARGIN_BOTTOM);
        boolean bl = resetBottom = bottomMargin instanceof LengthValue && !bottomMargin.hasAbsoluteUnit();
        if (!resetTop && !resetBottom) {
            return;
        }
        RectPropertySet styleMargin = this.getStyleMargin(c2, false);
        RectPropertySet workingMargin = this.getMargin(c2);
        if (!this.isTopMarginCalculated() && styleMargin.top() != workingMargin.top()) {
            this.setMarginTop(c2, (int)styleMargin.top());
        }
        if (!this.isBottomMarginCalculated() && styleMargin.bottom() != workingMargin.bottom()) {
            this.setMarginBottom(c2, (int)styleMargin.bottom());
        }
    }

    public void calcMinMaxWidth(LayoutContext c2) {
        if (!this.isMinMaxCalculated()) {
            RectPropertySet margin = this.getMargin(c2);
            BorderPropertySet border = this.getBorder(c2);
            RectPropertySet padding = this.getPadding(c2);
            int width = this.getCSSWidth(c2, true);
            if (width == -1) {
                if (this.isReplaced()) {
                    width = this.getReplacedElement().getIntrinsicWidth();
                } else {
                    int height = this.getCSSHeight(c2);
                    ReplacedElement re = c2.getReplacedElementFactory().createReplacedElement(c2, this, c2.getUac(), width, height);
                    if (re != null) {
                        this.setReplacedElement(re);
                        width = this.getReplacedElement().getIntrinsicWidth();
                    }
                }
            }
            if (this.isReplaced() || width != -1 && !this.isFixedWidthAdvisoryOnly()) {
                this._minWidth = this._maxWidth = (int)margin.left() + (int)border.left() + (int)padding.left() + width + (int)margin.right() + (int)border.right() + (int)padding.right();
            } else {
                int cw = -1;
                if (width != -1) {
                    cw = this.getContentWidth();
                    this.setContentWidth(width);
                }
                this._minWidth = this._maxWidth = (int)margin.left() + (int)border.left() + (int)padding.left() + (int)margin.right() + (int)border.right() + (int)padding.right();
                int minimumMaxWidth = this._maxWidth;
                if (width != -1) {
                    minimumMaxWidth += width;
                }
                this.ensureChildren(c2);
                if (this.getChildrenContentType() == 2 || this.getChildrenContentType() == 1) {
                    switch (this.getChildrenContentType()) {
                        case 2: {
                            this.calcMinMaxWidthBlockChildren(c2);
                            break;
                        }
                        case 1: {
                            this.calcMinMaxWidthInlineChildren(c2);
                        }
                    }
                }
                if (minimumMaxWidth > this._maxWidth) {
                    this._maxWidth = minimumMaxWidth;
                }
                if (cw != -1) {
                    this.setContentWidth(cw);
                }
            }
            if (!this.isReplaced()) {
                this.calcMinMaxCSSMinMaxWidth(c2, margin, border, padding);
            }
            this.setMinMaxCalculated(true);
        }
    }

    private void calcMinMaxCSSMinMaxWidth(LayoutContext c2, RectPropertySet margin, BorderPropertySet border, RectPropertySet padding) {
        int cssMinWidth = this.getCSSMinWidth(c2);
        if (cssMinWidth > 0 && this._minWidth < (cssMinWidth += (int)margin.left() + (int)border.left() + (int)padding.left() + (int)margin.right() + (int)border.right() + (int)padding.right())) {
            this._minWidth = cssMinWidth;
        }
        if (!this.getStyle().isMaxWidthNone()) {
            int cssMaxWidth = this.getCSSMaxWidth(c2);
            if (this._maxWidth > (cssMaxWidth += (int)margin.left() + (int)border.left() + (int)padding.left() + (int)margin.right() + (int)border.right() + (int)padding.right())) {
                this._maxWidth = cssMaxWidth > this._minWidth ? cssMaxWidth : this._minWidth;
            }
        }
    }

    private void calcMinMaxWidthBlockChildren(LayoutContext c2) {
        int childMinWidth = 0;
        int childMaxWidth = 0;
        Iterator i2 = this.getChildIterator();
        while (i2.hasNext()) {
            BlockBox child = (BlockBox)i2.next();
            child.calcMinMaxWidth(c2);
            if (child.getMinWidth() > childMinWidth) {
                childMinWidth = child.getMinWidth();
            }
            if (child.getMaxWidth() <= childMaxWidth) continue;
            childMaxWidth = child.getMaxWidth();
        }
        this._minWidth += childMinWidth;
        this._maxWidth += childMaxWidth;
    }

    private void calcMinMaxWidthInlineChildren(LayoutContext c2) {
        int textIndent = (int)this.getStyle().getFloatPropertyProportionalWidth(CSSName.TEXT_INDENT, this.getContentWidth(), c2);
        if (this.getStyle().isListItem() && this.getStyle().isListMarkerInside()) {
            this.createMarkerData(c2);
            textIndent += this.getMarkerData().getLayoutWidth();
        }
        int childMinWidth = 0;
        int childMaxWidth = 0;
        int lineWidth = 0;
        InlineBox trimmableIB = null;
        Iterator i2 = this._inlineContent.iterator();
        while (i2.hasNext()) {
            Styleable child = (Styleable)i2.next();
            if (child.getStyle().isAbsolute() || child.getStyle().isFixed() || child.getStyle().isRunning()) continue;
            if (child.getStyle().isFloated() || child.getStyle().isInlineBlock() || child.getStyle().isInlineTable()) {
                if (child.getStyle().isFloated() && child.getStyle().isCleared()) {
                    if (trimmableIB != null) {
                        lineWidth -= trimmableIB.getTrailingSpaceWidth(c2);
                    }
                    if (lineWidth > childMaxWidth) {
                        childMaxWidth = lineWidth;
                    }
                    lineWidth = 0;
                }
                trimmableIB = null;
                BlockBox block = (BlockBox)child;
                block.calcMinMaxWidth(c2);
                lineWidth += block.getMaxWidth();
                if (block.getMinWidth() <= childMinWidth) continue;
                childMinWidth = block.getMinWidth();
                continue;
            }
            InlineBox iB = (InlineBox)child;
            IdentValue whitespace = iB.getStyle().getWhitespace();
            iB.calcMinMaxWidth(c2, this.getContentWidth(), lineWidth == 0);
            if (whitespace == IdentValue.NOWRAP) {
                lineWidth += textIndent + iB.getMaxWidth();
                if (iB.getMinWidth() > childMinWidth) {
                    childMinWidth = iB.getMinWidth();
                }
                trimmableIB = iB;
            } else if (whitespace == IdentValue.PRE) {
                if (trimmableIB != null) {
                    lineWidth -= trimmableIB.getTrailingSpaceWidth(c2);
                }
                trimmableIB = null;
                if (lineWidth > childMaxWidth) {
                    childMaxWidth = lineWidth;
                }
                if ((lineWidth = textIndent + iB.getFirstLineWidth()) > childMinWidth) {
                    childMinWidth = lineWidth;
                }
                if ((lineWidth = iB.getMaxWidth()) > childMinWidth) {
                    childMinWidth = lineWidth;
                }
                if (childMinWidth > childMaxWidth) {
                    childMaxWidth = childMinWidth;
                }
                lineWidth = 0;
            } else if (whitespace == IdentValue.PRE_WRAP || whitespace == IdentValue.PRE_LINE) {
                lineWidth += textIndent + iB.getFirstLineWidth();
                if (trimmableIB != null) {
                    lineWidth -= trimmableIB.getTrailingSpaceWidth(c2);
                }
                if (lineWidth > childMaxWidth) {
                    childMaxWidth = lineWidth;
                }
                if (iB.getMaxWidth() > childMaxWidth) {
                    childMaxWidth = iB.getMaxWidth();
                }
                if (iB.getMinWidth() > childMinWidth) {
                    childMinWidth = iB.getMinWidth();
                }
                trimmableIB = whitespace == IdentValue.PRE_LINE ? iB : null;
                lineWidth = 0;
            } else {
                lineWidth += textIndent + iB.getMaxWidth();
                if (iB.getMinWidth() > childMinWidth) {
                    childMinWidth = textIndent + iB.getMinWidth();
                }
                trimmableIB = iB;
            }
            if (textIndent <= 0) continue;
            textIndent = 0;
        }
        if (trimmableIB != null) {
            lineWidth -= trimmableIB.getTrailingSpaceWidth(c2);
        }
        if (lineWidth > childMaxWidth) {
            childMaxWidth = lineWidth;
        }
        this._minWidth += childMinWidth;
        this._maxWidth += childMaxWidth;
    }

    public int getMaxWidth() {
        return this._maxWidth;
    }

    protected void setMaxWidth(int maxWidth) {
        this._maxWidth = maxWidth;
    }

    public int getMinWidth() {
        return this._minWidth;
    }

    protected void setMinWidth(int minWidth) {
        this._minWidth = minWidth;
    }

    public void styleText(LayoutContext c2) {
        this.styleText(c2, this.getStyle());
    }

    public void styleText(LayoutContext c2, CalculatedStyle style) {
        if (this.getChildrenContentType() == 1) {
            LinkedList<CalculatedStyle> styles = new LinkedList<CalculatedStyle>();
            styles.add(style);
            Iterator i2 = this._inlineContent.iterator();
            while (i2.hasNext()) {
                Styleable child = (Styleable)i2.next();
                if (!(child instanceof InlineBox)) continue;
                InlineBox iB = (InlineBox)child;
                if (iB.isStartsHere()) {
                    CascadedStyle cs = null;
                    if (iB.getElement() != null) {
                        cs = iB.getPseudoElementOrClass() == null ? c2.getCss().getCascadedStyle(iB.getElement(), false) : c2.getCss().getPseudoElementStyle(iB.getElement(), iB.getPseudoElementOrClass());
                        styles.add(((CalculatedStyle)styles.getLast()).deriveStyle(cs));
                    } else {
                        styles.add(style.createAnonymousStyle(IdentValue.INLINE));
                    }
                }
                iB.setStyle((CalculatedStyle)styles.getLast());
                iB.applyTextTransform();
                if (!iB.isEndsHere()) continue;
                styles.removeLast();
            }
        }
    }

    protected void calcChildPaintingInfo(final CssContext c2, final PaintingInfo result, final boolean useCache) {
        if (this.getPersistentBFC() != null) {
            this.getPersistentBFC().getFloatManager().performFloatOperation(new FloatManager.FloatOperation(){

                public void operate(Box floater) {
                    PaintingInfo info = floater.calcPaintingInfo(c2, useCache);
                    BlockBox.this.moveIfGreater(result.getOuterMarginCorner(), info.getOuterMarginCorner());
                }
            });
        }
        super.calcChildPaintingInfo(c2, result, useCache);
    }

    public CascadedStyle getFirstLetterStyle() {
        return this._firstLetterStyle;
    }

    public void setFirstLetterStyle(CascadedStyle firstLetterStyle) {
        this._firstLetterStyle = firstLetterStyle;
    }

    public CascadedStyle getFirstLineStyle() {
        return this._firstLineStyle;
    }

    public void setFirstLineStyle(CascadedStyle firstLineStyle) {
        this._firstLineStyle = firstLineStyle;
    }

    protected boolean isMinMaxCalculated() {
        return this._minMaxCalculated;
    }

    protected void setMinMaxCalculated(boolean minMaxCalculated) {
        this._minMaxCalculated = minMaxCalculated;
    }

    protected void setDimensionsCalculated(boolean dimensionsCalculated) {
        this._dimensionsCalculated = dimensionsCalculated;
    }

    private boolean isDimensionsCalculated() {
        return this._dimensionsCalculated;
    }

    protected void setNeedShrinkToFitCalculatation(boolean needShrinkToFitCalculatation) {
        this._needShrinkToFitCalculatation = needShrinkToFitCalculatation;
    }

    private boolean isNeedShrinkToFitCalculatation() {
        return this._needShrinkToFitCalculatation;
    }

    public void initStaticPos(LayoutContext c2, BlockBox parent, int childOffset) {
        this.setX(0);
        this.setY(childOffset);
    }

    public int calcBaseline(LayoutContext c2) {
        for (int i2 = 0; i2 < this.getChildCount(); ++i2) {
            Box b2 = this.getChild(i2);
            if (b2 instanceof LineBox) {
                return b2.getAbsY() + ((LineBox)b2).getBaseline();
            }
            if (b2 instanceof TableRowBox) {
                return b2.getAbsY() + ((TableRowBox)b2).getBaseline();
            }
            int result = ((BlockBox)b2).calcBaseline(c2);
            if (result == Integer.MIN_VALUE) continue;
            return result;
        }
        return Integer.MIN_VALUE;
    }

    protected int calcInitialBreakAtLine(LayoutContext c2) {
        BreakAtLineContext bContext = c2.getBreakAtLineContext();
        if (bContext != null && bContext.getBlock() == this) {
            return bContext.getLine();
        }
        return 0;
    }

    public boolean isCurrentBreakAtLineContext(LayoutContext c2) {
        BreakAtLineContext bContext = c2.getBreakAtLineContext();
        return bContext != null && bContext.getBlock() == this;
    }

    public BreakAtLineContext calcBreakAtLineContext(LayoutContext c2) {
        if (!c2.isPrint() || !this.getStyle().isKeepWithInline()) {
            return null;
        }
        LineBox breakLine = this.findLastNthLineBox((int)this.getStyle().asFloat(CSSName.WIDOWS));
        if (breakLine != null) {
            PageBox linePage = c2.getRootLayer().getLastPage(c2, breakLine);
            PageBox ourPage = c2.getRootLayer().getLastPage(c2, this);
            if (linePage != null && ourPage != null && linePage.getPageNo() + 1 == ourPage.getPageNo()) {
                BlockBox breakBox = (BlockBox)breakLine.getParent();
                return new BreakAtLineContext(breakBox, breakBox.findOffset(breakLine));
            }
        }
        return null;
    }

    public int calcInlineBaseline(CssContext c2) {
        if (this.isReplaced() && this.getReplacedElement().hasBaseline()) {
            Rectangle bounds = this.getContentAreaEdge(this.getAbsX(), this.getAbsY(), c2);
            return bounds.y + this.getReplacedElement().getBaseline() - this.getAbsY();
        }
        LineBox lastLine = this.findLastLineBox();
        if (lastLine == null) {
            return this.getHeight();
        }
        return lastLine.getAbsY() + lastLine.getBaseline() - this.getAbsY();
    }

    public int findOffset(Box box) {
        int ccount = this.getChildCount();
        for (int i2 = 0; i2 < ccount; ++i2) {
            if (this.getChild(i2) != box) continue;
            return i2;
        }
        return -1;
    }

    public LineBox findLastNthLineBox(int count) {
        LastLineBoxContext context = new LastLineBoxContext(count);
        this.findLastLineBox(context);
        return context.line;
    }

    private void findLastLineBox(LastLineBoxContext context) {
        block3: {
            int type;
            block4: {
                type = this.getChildrenContentType();
                int ccount = this.getChildCount();
                if (ccount <= 0) break block3;
                if (type != 1) break block4;
                for (int i2 = ccount - 1; i2 >= 0; --i2) {
                    LineBox child = (LineBox)this.getChild(i2);
                    if (child.getHeight() <= 0) continue;
                    context.line = child;
                    if (--context.current != 0) continue;
                    return;
                }
                break block3;
            }
            if (type != 2) break block3;
            for (int i3 = ccount - 1; i3 >= 0; --i3) {
                ((BlockBox)this.getChild(i3)).findLastLineBox(context);
                if (context.current != 0) {
                    continue;
                }
                break;
            }
        }
    }

    private LineBox findLastLineBox() {
        block2: {
            int type;
            block3: {
                type = this.getChildrenContentType();
                int ccount = this.getChildCount();
                if (ccount <= 0) break block2;
                if (type != 1) break block3;
                for (int i2 = ccount - 1; i2 >= 0; --i2) {
                    LineBox result = (LineBox)this.getChild(i2);
                    if (result.getHeight() <= 0) continue;
                    return result;
                }
                break block2;
            }
            if (type != 2) break block2;
            for (int i3 = ccount - 1; i3 >= 0; --i3) {
                LineBox result = ((BlockBox)this.getChild(i3)).findLastLineBox();
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    private LineBox findFirstLineBox() {
        block2: {
            int ccount;
            int type;
            block3: {
                type = this.getChildrenContentType();
                ccount = this.getChildCount();
                if (ccount <= 0) break block2;
                if (type != 1) break block3;
                for (int i2 = 0; i2 < ccount; ++i2) {
                    LineBox result = (LineBox)this.getChild(i2);
                    if (result.getHeight() <= 0) continue;
                    return result;
                }
                break block2;
            }
            if (type != 2) break block2;
            for (int i3 = 0; i3 < ccount; ++i3) {
                LineBox result = ((BlockBox)this.getChild(i3)).findFirstLineBox();
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    public boolean isNeedsKeepWithInline(LayoutContext c2) {
        LineBox line;
        if (c2.isPrint() && this.getStyle().isKeepWithInline() && (line = this.findFirstLineBox()) != null) {
            PageBox linePage = c2.getRootLayer().getFirstPage(c2, line);
            PageBox ourPage = c2.getRootLayer().getFirstPage(c2, this);
            return linePage != null && ourPage != null && linePage.getPageNo() == ourPage.getPageNo() + 1;
        }
        return false;
    }

    public boolean isFloated() {
        return this._floatedBoxData != null;
    }

    public FloatedBoxData getFloatedBoxData() {
        return this._floatedBoxData;
    }

    public void setFloatedBoxData(FloatedBoxData floatedBoxData) {
        this._floatedBoxData = floatedBoxData;
    }

    public int getChildrenHeight() {
        return this._childrenHeight;
    }

    protected void setChildrenHeight(int childrenHeight) {
        this._childrenHeight = childrenHeight;
    }

    public boolean isFromCaptionedTable() {
        return this._fromCaptionedTable;
    }

    public void setFromCaptionedTable(boolean fromTable) {
        this._fromCaptionedTable = fromTable;
    }

    protected boolean isInlineBlock() {
        return this.isInline();
    }

    public boolean isInMainFlow() {
        Box flowRoot = this;
        while (flowRoot.getParent() != null) {
            flowRoot = flowRoot.getParent();
        }
        return flowRoot.isRoot();
    }

    public Box getDocumentParent() {
        Box staticEquivalent = this.getStaticEquivalent();
        if (staticEquivalent != null) {
            return staticEquivalent;
        }
        return this.getParent();
    }

    public boolean isContainsInlineContent(LayoutContext c2) {
        this.ensureChildren(c2);
        switch (this.getChildrenContentType()) {
            case 1: {
                return true;
            }
            case 4: {
                return false;
            }
            case 2: {
                Iterator i2 = this.getChildIterator();
                while (i2.hasNext()) {
                    BlockBox box = (BlockBox)i2.next();
                    if (!box.isContainsInlineContent(c2)) continue;
                    return true;
                }
                return false;
            }
        }
        throw new RuntimeException("internal error: no children");
    }

    public boolean checkPageContext(LayoutContext c2) {
        if (!this.getStyle().isIdent(CSSName.PAGE, IdentValue.AUTO)) {
            String pageName = this.getStyle().getStringProperty(CSSName.PAGE);
            if (!pageName.equals(c2.getPageName()) && this.isInDocumentFlow() && this.isContainsInlineContent(c2)) {
                c2.setPendingPageName(pageName);
                return true;
            }
        } else if (c2.getPageName() != null && this.isInDocumentFlow()) {
            c2.setPendingPageName(null);
            return true;
        }
        return false;
    }

    public boolean isNeedsClipOnPaint(RenderingContext c2) {
        return !this.isReplaced() && this.getStyle().isIdent(CSSName.OVERFLOW, IdentValue.HIDDEN) && this.getStyle().isOverflowApplies();
    }

    protected void propagateExtraSpace(LayoutContext c2, ContentLimitContainer parentContainer, ContentLimitContainer currentContainer, int extraTop, int extraBottom) {
        int start = currentContainer.getInitialPageNo();
        int end = currentContainer.getLastPageNo();
        for (int current = start; current <= end; ++current) {
            int bottom;
            int top;
            ContentLimit contentLimit = currentContainer.getContentLimit(current);
            if (current != start && (top = contentLimit.getTop()) != -1) {
                parentContainer.updateTop(c2, top - extraTop);
            }
            if (current == end || (bottom = contentLimit.getBottom()) == -1) continue;
            parentContainer.updateBottom(c2, bottom + extraBottom);
        }
    }

    protected boolean isInitialContainingBlock() {
        return false;
    }

    private static class MarginCollapseResult {
        private int maxPositive;
        private int maxNegative;

        private MarginCollapseResult() {
        }

        public void update(int value) {
            if (value < 0 && value < this.maxNegative) {
                this.maxNegative = value;
            }
            if (value > 0 && value > this.maxPositive) {
                this.maxPositive = value;
            }
        }

        public int getMargin() {
            return this.maxPositive + this.maxNegative;
        }

        public boolean hasMargin() {
            return this.maxPositive != 0 || this.maxNegative != 0;
        }
    }

    private static class LastLineBoxContext {
        public int current;
        public LineBox line;

        public LastLineBoxContext(int i2) {
            this.current = i2;
        }
    }
}

