/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.simple.xhtml.swt;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xhtmlrenderer.css.style.CalculatedStyle;
import org.xhtmlrenderer.extend.UserAgentCallback;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.resource.ImageResource;
import org.xhtmlrenderer.simple.xhtml.FormControl;
import org.xhtmlrenderer.simple.xhtml.controls.ButtonControl;
import org.xhtmlrenderer.simple.xhtml.swt.SWTXhtmlControl;
import org.xhtmlrenderer.swt.BasicRenderer;
import org.xhtmlrenderer.swt.SWTFSImage;

public class SWTButtonControl
extends SWTXhtmlControl {
    private Image _image = null;

    public SWTButtonControl(FormControl control, BasicRenderer parent, LayoutContext c2, CalculatedStyle style, UserAgentCallback uac) {
        super(control, parent, c2, style, uac);
    }

    protected Control createSWTControl(FormControl control, BasicRenderer parent, LayoutContext c2, CalculatedStyle style, UserAgentCallback uac) {
        NodeList images;
        final ButtonControl bc = (ButtonControl)control;
        Button button = new Button((Composite)parent, 8);
        button.setText(bc.getLabel());
        if (bc.isExtended() && (images = bc.getElement().getElementsByTagName("img")).getLength() > 0) {
            Element img = (Element)images.item(0);
            String uri = c2.getNamespaceHandler().getImageSourceURI(img);
            ImageResource res = uac.getImageResource(uri);
            SWTFSImage fsi = (SWTFSImage)res.getImage();
            this._image = new Image((Device)button.getDisplay(), fsi.getImage(), bc.isEnabled() ? 0 : 1);
            button.setImage(this._image);
        }
        if (bc.getType().equals("submit")) {
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e2) {
                    if (bc.press()) {
                        bc.getForm().submit();
                    }
                }
            });
            parent.getShell().setDefaultButton(button);
        } else if (bc.getType().equals("reset")) {
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e2) {
                    if (bc.press()) {
                        bc.getForm().reset();
                    }
                }
            });
        } else {
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e2) {
                    bc.press();
                }
            });
        }
        return button;
    }

    public int getIdealHeight() {
        this.getSWTControl().pack();
        return this.getSWTControl().getSize().y;
    }

    public int getIdealWidth() {
        this.getSWTControl().pack();
        return this.getSWTControl().getSize().x;
    }

    public void dispose() {
        super.dispose();
        if (this._image != null) {
            this._image.dispose();
        }
    }
}

