/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.swt;

import java.awt.Rectangle;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Point;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xhtmlrenderer.context.StyleReference;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.layout.PaintingInfo;
import org.xhtmlrenderer.render.Box;
import org.xhtmlrenderer.swt.BasicRenderer;

public class HoverListener
implements MouseMoveListener {
    private final BasicRenderer _parent;
    private Box _previousBox = null;

    public HoverListener(BasicRenderer parent) {
        this._parent = parent;
        parent.addMouseMoveListener(this);
    }

    public void mouseMove(MouseEvent e2) {
        Element current;
        LayoutContext c2 = this._parent.getLayoutContext();
        if (c2 == null) {
            return;
        }
        Box box = this._parent.find(e2.x, e2.y);
        Element previous = this._parent.getHovered_element();
        if (previous == (current = this.getHoveredElement(c2.getCss(), box))) {
            return;
        }
        this._parent.setHovered_element(current);
        boolean needRepaint = false;
        boolean targetedRepaint = true;
        org.eclipse.swt.graphics.Rectangle repaintTarget = null;
        if (previous != null) {
            needRepaint = true;
            this._previousBox.restyle(c2);
            PaintingInfo paintInfo = this._previousBox.getPaintingInfo();
            if (paintInfo == null) {
                targetedRepaint = false;
            } else {
                Rectangle rect = paintInfo.getAggregateBounds();
                repaintTarget = new org.eclipse.swt.graphics.Rectangle(rect.x, rect.y, rect.width, rect.height);
            }
            this._previousBox = null;
        }
        if (current != null) {
            needRepaint = true;
            Box target = box.getRestyleTarget();
            target.restyle(c2);
            if (targetedRepaint) {
                PaintingInfo paintInfo = target.getPaintingInfo();
                if (paintInfo == null) {
                    targetedRepaint = false;
                } else if (repaintTarget == null) {
                    Rectangle rect = paintInfo.getAggregateBounds();
                    repaintTarget = new org.eclipse.swt.graphics.Rectangle(rect.x, rect.y, rect.width, rect.height);
                } else {
                    Rectangle rect = paintInfo.getAggregateBounds();
                    repaintTarget.add(new org.eclipse.swt.graphics.Rectangle(rect.x, rect.y, rect.width, rect.height));
                }
            }
            this._previousBox = box;
        }
        if (needRepaint) {
            if (targetedRepaint) {
                Point origin = this._parent.getOrigin();
                repaintTarget.x -= origin.x;
                repaintTarget.y -= origin.y;
                this._parent.invalidate(repaintTarget);
            } else {
                this._parent.invalidate();
            }
        }
    }

    private Element getHoveredElement(StyleReference style, Box ib) {
        if (ib == null) {
            return null;
        }
        Element element = ib.getElement();
        while (element != null && !style.isHoverStyled(element)) {
            Node node = element.getParentNode();
            if (node.getNodeType() == 1) {
                element = (Element)node;
                continue;
            }
            element = null;
        }
        return element;
    }
}

