/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.swt;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.xhtmlrenderer.css.constants.IdentValue;
import org.xhtmlrenderer.css.value.FontSpecification;
import org.xhtmlrenderer.extend.FontResolver;
import org.xhtmlrenderer.layout.SharedContext;
import org.xhtmlrenderer.render.FSFont;
import org.xhtmlrenderer.swt.SWTFSFont;
import org.xhtmlrenderer.util.XRLog;

public class SWTFontResolver
implements FontResolver {
    private final Device _device;
    private final float _pointsPerPixel;
    private Map _instance_hash;
    private Map _default_fonts;
    private SWTFSFont _system_font;
    private static final String[] _defaults_serif = new String[]{"serif", "Serif", "times new roman", "times"};
    private static final String[] _defaults_monospace = new String[]{"monospace", "monospaced", "courier new", "courier"};

    public SWTFontResolver(Device device) {
        this._device = device;
        this._pointsPerPixel = 72.0f / (float)device.getDPI().y;
        this.init();
    }

    private void init() {
        int i2;
        this._instance_hash = new HashMap();
        String system_font_family = this._device.getSystemFont().getFontData()[0].getName();
        this._default_fonts = new HashMap();
        this._default_fonts.put("sans-serif", system_font_family);
        for (i2 = 0; i2 < _defaults_serif.length; ++i2) {
            if (this._device.getFontList(_defaults_serif[i2], true).length <= 0) continue;
            this._default_fonts.put("serif", _defaults_serif[i2]);
            break;
        }
        if (this._default_fonts.get("serif") == null) {
            this._default_fonts.put("serif", system_font_family);
        }
        for (i2 = 0; i2 < _defaults_monospace.length; ++i2) {
            if (this._device.getFontList(_defaults_monospace[i2], true).length <= 0) continue;
            this._default_fonts.put("monospace", _defaults_monospace[i2]);
            break;
        }
        if (this._default_fonts.get("monospace") == null) {
            this._default_fonts.put("monospace", system_font_family);
        }
        Font systemFont = this._device.getSystemFont();
        this._system_font = new SWTFSFont(systemFont, systemFont.getFontData()[0].getHeight(), true);
    }

    public void flushCache() {
        Iterator iter = this._instance_hash.values().iterator();
        while (iter.hasNext()) {
            ((SWTFSFont)iter.next()).dispose();
        }
        this._instance_hash.clear();
    }

    public FSFont resolveFont(SharedContext renderingContext, FontSpecification spec) {
        SWTFSFont font;
        if (spec.families != null) {
            for (int i2 = 0; i2 < spec.families.length; ++i2) {
                SWTFSFont font2 = this.resolveFont(renderingContext, spec.families[i2], spec.size, spec.fontWeight, spec.fontStyle, spec.variant);
                if (font2 == null) continue;
                return font2;
            }
        }
        if ((font = this.resolveFont(renderingContext, "sans-serif", spec.size, spec.fontWeight, spec.fontStyle, spec.variant)) != null) {
            return font;
        }
        XRLog.cascade(Level.WARNING, "Falling back to default system font. " + spec.toString());
        return this._system_font;
    }

    private SWTFSFont resolveFont(SharedContext ctx, String font, float size, IdentValue weight, IdentValue style, IdentValue variant) {
        String font_instance_name;
        if (font.startsWith("\"")) {
            font = font.substring(1);
        }
        if (font.endsWith("\"")) {
            font = font.substring(0, font.length() - 1);
        }
        float size2D = size;
        size *= this._pointsPerPixel;
        if (variant != null && variant == IdentValue.SMALL_CAPS) {
            size = (float)((double)size * 0.6);
        }
        int nSize = Math.round(size *= ctx.getTextRenderer().getFontScale());
        if (this._default_fonts.containsKey(font)) {
            font = (String)this._default_fonts.get(font);
        }
        if (this._instance_hash.containsKey(font_instance_name = SWTFontResolver.getFontInstanceHashName(font, nSize, weight, style, variant))) {
            return (SWTFSFont)this._instance_hash.get(font_instance_name);
        }
        FontData[] fd = this._device.getFontList(font, true);
        if (fd.length > 0) {
            int style_bits = 0;
            if (weight != null && (weight == IdentValue.BOLD || weight == IdentValue.FONT_WEIGHT_700 || weight == IdentValue.FONT_WEIGHT_800 || weight == IdentValue.FONT_WEIGHT_900)) {
                style_bits |= 1;
            }
            if (style != null && (style == IdentValue.ITALIC || style == IdentValue.OBLIQUE)) {
                style_bits |= 2;
            }
            SWTFSFont fnt = new SWTFSFont(new Font(this._device, fd[0].getName(), nSize, style_bits), size2D);
            this._instance_hash.put(font_instance_name, fnt);
            return fnt;
        }
        return null;
    }

    private static String getFontInstanceHashName(String name, int size, IdentValue weight, IdentValue style, IdentValue variant) {
        return name + "-" + size + "-" + weight + "-" + style + "-" + variant;
    }
}

