<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:bordereau="http://www.e-dec.ch/xml/schema/edecBordereauResponse/v1">


  <!--document language-->
  <xsl:variable name="documentLanguage" select="//bordereau:documentInformation/bordereau:documentLanguage" />
  <xsl:variable name="documentTitle" select="//bordereau:documentInformation/bordereau:documentTitle" />
  <xsl:variable name="documentNumber" select="//bordereau:documentInformation/bordereau:documentNumber" />
  <xsl:variable name="documentDate" select="//bordereau:documentInformation/bordereau:documentDate" />
  <xsl:variable name="documentTime" select="//bordereau:documentInformation/bordereau:documentTime" />

  <!--  Head template -->
  <xsl:template name="header_settings">
    <title>
      <xsl:value-of select="$documentTitle" />
    </title>
    <style type="text/css">
      <xsl:text>
      .title {font-family:Arial, Helvetica, sans-serif; font-size: 20px; font-weight:bold}
      .subtitle {font-family:Arial, Helvetica, sans-serif; font-size: 38px; font-style:bold; color:red}
      .label {font-family:Arial, Helvetica, sans-serif;font-size: 12px; font-style:italic}
      .content {font-family:Arial, Helvetica, sans-serif;font-size: 14px}
      .small {font-family:Arial, Helvetica, sans-serif;font-size: 8px}
      .header {font-family:Arial, Helvetica, sans-serif;font-size: 12px}
      .table_0{border-width: 0px; border-spacing:0px; border-style:solid; border-collapse: collapse; }
      .table_1{border-style: solid; border-width: 1px 1px 1px 1px; border-spacing: 0; border-collapse: collapse; page-break-inside: avoid}
      .td_0{border-width: 0px; border-style:solid; }
      .td_1{border-style: solid; margin: 0; padding: 4px;  border-width: 1px 1px 1px 1px;}

      </xsl:text>
    </style>
  </xsl:template>

  <!--Main Templates-->
  <xsl:template match="/">
    <xsl:apply-templates select="//bordereau:bordereauRequestResponse/bordereau:bordereau" />
  </xsl:template>

  <xsl:template match="//bordereau:bordereauRequestResponse/bordereau:bordereau">
    <html>
      <head>
        <xsl:call-template name="header_settings" />
      </head>
      <body class="content">
        <xsl:call-template name="headline" />
        <br />
        <xsl:call-template name="title" />
        <br />
        <br />
        <br />
        <br />
        <br />
        <br />
        <xsl:call-template name="addresses" />
        <br />
        <br />
        <br />
        <br />
        <br />
        <xsl:call-template name="account_totals" />
        <br />
        <br />
        <br />
        <xsl:call-template name="receipt_list" />
        <br />
        <br />
        <br />
        <xsl:call-template name="footer" />
      </body>
    </html>
  </xsl:template>

  <xsl:template name="footer">
    <span class="header">
      <strong>
        <xsl:call-template name="Translate">
          <xsl:with-param name="labelToTranslate" select="'legende'" />
        </xsl:call-template>
      </strong>
    </span>
    <br />
    <span class="header">
      <xsl:call-template name="Translate">
        <xsl:with-param name="labelToTranslate" select="'legende_vvz'" />
      </xsl:call-template>

    </span>
    <br />
    <span class="header">
      <xsl:call-template name="Translate">
        <xsl:with-param name="labelToTranslate" select="'legende_vvm'" />
      </xsl:call-template>

    </span>
    <br />
    <span class="header">
      <xsl:call-template name="Translate">
        <xsl:with-param name="labelToTranslate" select="'legende_rbz'" />
      </xsl:call-template>

    </span>
    <br />
    <span class="header">
      <xsl:call-template name="Translate">
        <xsl:with-param name="labelToTranslate" select="'legende_rbm'" />
      </xsl:call-template>

    </span>
    <br />
  </xsl:template>

  <xsl:template name="receipt_list">
    <table class="table_1" width="100%">
      <xsl:call-template name="receipt_list_header">
      </xsl:call-template>
      <xsl:call-template name="receipt_list_content">
      </xsl:call-template>
    </table>
  </xsl:template>

  <xsl:template name="receipt_list_header">
    <tr>
      <th class="td_1" width="">
        <xsl:call-template name="Translate">
          <xsl:with-param name="labelToTranslate" select="'zollstelle'" />
        </xsl:call-template>
      </th>
      <th class="td_1" align="center" width="">
        <xsl:call-template name="Translate">
          <xsl:with-param name="labelToTranslate" select="'document_type_ref'" />
        </xsl:call-template>
      </th>
      <th class="td_1" align="center" width="170">
        <xsl:call-template name="Translate">
          <xsl:with-param name="labelToTranslate" select="'referenz_spediteur'" />
        </xsl:call-template>
      </th>
      <th class="td_1" align="center" width="170">
        <xsl:call-template name="Translate">
          <xsl:with-param name="labelToTranslate" select="'referenz_zoll'" />
        </xsl:call-template>
      </th>
      <th class="td_1" align="center" width="110">
        <xsl:call-template name="Translate">
          <xsl:with-param name="labelToTranslate" select="'betrag_chf'" />
        </xsl:call-template>
      </th>
    </tr>
  </xsl:template>

  <xsl:template name="receipt_list_content">
    <xsl:for-each select="bordereau:details/bordereau:customsOffice">
      <xsl:call-template name="receipt_list_detail">
        <xsl:with-param name="customsOfficeName">
          <xsl:value-of select="bordereau:customsOfficeName" />
        </xsl:with-param>
      </xsl:call-template>
    </xsl:for-each>
  </xsl:template>


  <xsl:template name="receipt_list_detail">
    <xsl:param name="customsOfficeName" />
    <xsl:for-each select="bordereau:detail">
      <xsl:sort select="bordereau:customsReference" />

      <tr>
        <td class="td_1">
          <xsl:if test="position() = 1">
            <xsl:value-of select="$customsOfficeName" />
          </xsl:if>
        </td>
        <td class="td_1">
          <xsl:value-of select="bordereau:documentType/bordereau:documentTypeAbbreviation" />
        </td>
        <td class="td_1">
          <xsl:value-of select="bordereau:traderReference" />
        </td>
        <td class="td_1" align="right">
          <xsl:value-of select="bordereau:customsReference" />.<xsl:value-of select="bordereau:customsDeclarationVersion" />
        </td>
        <td class="td_1" align="right">
          <xsl:value-of select="bordereau:amount" />
        </td>

      </tr>
    </xsl:for-each>

  </xsl:template>



  <xsl:template name="account_totals">
    <table class="table_0" width="100%">
      <tr>
        <td valign="top">
          <xsl:call-template name="account" />
        </td>
        <td valign="top">
          <xsl:call-template name="totals" />
        </td>
      </tr>
    </table>
  </xsl:template>

  <xsl:template name="account">
    <span class="header">
      <xsl:call-template name="Translate">
        <xsl:with-param name="labelToTranslate" select="'account'" />
      </xsl:call-template>
    </span>
    <br />
    <strong>
      <xsl:value-of select="bordereau:account/bordereau:accountNumber" />
    </strong>
  </xsl:template>

  <xsl:template name="totals">
    <table class="table_0" align="right">
      <tr>
        <th class="td_0" width="200">
        </th>
        <th class="td_1" align="center" width="150">
          <xsl:call-template name="Translate">
            <xsl:with-param name="labelToTranslate" select="'anzahl_belege'" />
          </xsl:call-template>
        </th>
        <th class="td_1" align="center" width="150">
          <xsl:call-template name="Translate">
            <xsl:with-param name="labelToTranslate" select="'betrag_chf'" />
          </xsl:call-template>
        </th>
      </tr>
      <tr>
        <td class="td_1" align="left">
          <xsl:call-template name="Translate">
            <xsl:with-param name="labelToTranslate" select="'zoll_abgaben'" />
          </xsl:call-template>
        </td>
        <td class="td_1" align="right">
          <xsl:value-of select="bordereau:summary/bordereau:dutyAndAdditionalTaxes/bordereau:numberOfDocuments" />
        </td>
        <td class="td_1" align="right">
          <xsl:value-of select="bordereau:summary/bordereau:dutyAndAdditionalTaxes/bordereau:amount" />
        </td>
      </tr>
      <tr>
        <td class="td_1" align="left">
          <xsl:call-template name="Translate">
            <xsl:with-param name="labelToTranslate" select="'mwst_abgaben'" />
          </xsl:call-template>
        </td>
        <td class="td_1" align="right">
          <xsl:value-of select="bordereau:summary/bordereau:VAT/bordereau:numberOfDocuments" />
        </td>
        <td class="td_1" align="right">
          <xsl:value-of select="bordereau:summary/bordereau:VAT/bordereau:amount" />
        </td>
      </tr>
      <tr>
        <td class="td_1" align="left">
          <strong>
            <xsl:call-template name="Translate">
              <xsl:with-param name="labelToTranslate" select="'totals'" />
            </xsl:call-template>
          </strong>
        </td>
        <td class="td_1" align="right">
          <strong>
            <xsl:value-of select="bordereau:summary/bordereau:totals/bordereau:numberOfDocuments" />
          </strong>
        </td>
        <td class="td_1" align="right">
          <strong>
            <xsl:value-of select="bordereau:summary/bordereau:totals/bordereau:amount" />
          </strong>
        </td>
      </tr>

    </table>
  </xsl:template>


  <xsl:template name="addresses">
    <table class="table_0" width="100%">
      <tr>
        <td width="500" valign="top">
          <xsl:call-template name="consignee" />
        </td>
        <td valign="top">
          <xsl:call-template name="processing_center" />
        </td>
      </tr>
    </table>
  </xsl:template>

  <xsl:template name="consignee">
    <xsl:value-of select="bordereau:consignee/bordereau:name" />
    <br />
    <xsl:for-each select="bordereau:consignee/bordereau:addressLine">
      <xsl:value-of select="." />
      <br></br>
    </xsl:for-each>

  </xsl:template>


  <xsl:template name="processing_center">
    <span class="header">
      <xsl:call-template name="Translate">
        <xsl:with-param name="labelToTranslate" select="'verarbeitungszentrum'" />
      </xsl:call-template>
    </span>
    <br />
    <xsl:value-of select="bordereau:processingCenter/bordereau:name" />
    <br />
    <xsl:value-of select="bordereau:processingCenter/bordereau:street" />
    <br />
    <xsl:value-of select="bordereau:processingCenter/bordereau:country" />
    <nbsp />
    <xsl:value-of select="bordereau:processingCenter/bordereau:postalCode" />
    <nbsp />
    <xsl:value-of select="bordereau:processingCenter/bordereau:city" />
    <br />
    <xsl:value-of select="bordereau:processingCenter/bordereau:phoneNumber" />
  </xsl:template>


  <xsl:template name="headline">
    <table width="100%" class="table_0">
      <tr>
        <td class="td_0" align="left" valign="top">
          <xsl:call-template name="header" />
        </td>
        <td class="td_0" align="right" valign="top">
          <xsl:call-template name="barcode" />
        </td>
      </tr>
    </table>
  </xsl:template>

  <xsl:template name="title">
    <span class="title">
      <xsl:value-of select="$documentTitle" />
    </span>
    <br />
    <span class="content">
      <xsl:value-of select="$documentDate" />, <xsl:value-of select="$documentTime" />
    </span>

  </xsl:template>

  <xsl:template name="header">
    <table class="table_0">
      <tr>
        <td>
          <img width="150" src="logo_switzerland.gif" />
        </td>
        <td width="20"></td>
        <td class="small" width="300" valign="top">
          <xsl:call-template name="Translate">
            <xsl:with-param name="labelToTranslate" select="'eidgenoessisches_finanzdepartement_efd'" />
          </xsl:call-template>
          <br />
          <strong>
            <xsl:call-template name="Translate">
              <xsl:with-param name="labelToTranslate" select="'eidgenoessische_zollverwaltung_ezv'" />
            </xsl:call-template>
          </strong>
        </td>
      </tr>
    </table>
  </xsl:template>

  <xsl:template name="barcode">
    <table class="table_0" align="right">
      <tr>
        <td>
          <xsl:element name="img">
            <xsl:attribute name="height">50</xsl:attribute>
            <xsl:attribute name="src">barcode/<xsl:value-of select="$documentNumber" /></xsl:attribute>
          </xsl:element>
        </td>
      </tr>
      <tr>
        <td class="header">
          <strong>
            <xsl:value-of select="$documentNumber" />
          </strong>
        </td>
      </tr>
    </table>
  </xsl:template>

  <!-- Translations DE, FR, IT -->
  <xsl:template name="Translate">
    <xsl:param name="labelToTranslate" select="/.." />
    <xsl:variable name="lower">
      abcdefghijklmnopqrstuvwxyz
    </xsl:variable>
    <xsl:variable name="upper">
      ABCDEFGHIJKLMNOPQRSTUVWXYZ
    </xsl:variable>
    <xsl:choose>
      <xsl:when test="translate($documentLanguage,$lower,$upper) = 'IT'">
        <xsl:call-template name="TranslateIT">
          <xsl:with-param name="label" select="$labelToTranslate" />
        </xsl:call-template>
      </xsl:when>
      <xsl:when test="translate($documentLanguage,$lower,$upper) = 'FR'">
        <xsl:call-template name="TranslateFR">
          <xsl:with-param name="label" select="$labelToTranslate" />
        </xsl:call-template>
      </xsl:when>
      <xsl:when test="translate($documentLanguage,$lower,$upper) = 'DE'">
        <xsl:call-template name="TranslateDE">
          <xsl:with-param name="label" select="$labelToTranslate" />
        </xsl:call-template>
      </xsl:when>
    </xsl:choose>
  </xsl:template>


  <xsl:template name="TranslateDE">
    <xsl:param name="label" select="/.." />
    <xsl:choose>
      <xsl:when test="$label = 'eidgenoessische_zollverwaltung_ezv'">
        <xsl:text>Eidgen&#246;ssische Zollverwaltung EZV</xsl:text>
      </xsl:when>
      <xsl:when test="$label = 'eidgenoessisches_finanzdepartement_efd'">
        <xsl:text>Eidgen&#246;ssisches Finanzdepartement EFD</xsl:text>
      </xsl:when>
      <xsl:when test="$label = 'verarbeitungszentrum'">
        <xsl:text>Verarbeitungszentrum:</xsl:text>
      </xsl:when>
      <xsl:when test="$label = 'account'">
        <xsl:text>Konto:</xsl:text>
      </xsl:when>
      <xsl:when test="$label = 'anzahl_belege'">
        <xsl:text>Anzahl Belege:</xsl:text>
      </xsl:when>
      <xsl:when test="$label = 'betrag_chf'">
        <xsl:text>Betrag [CHF]:</xsl:text>
      </xsl:when>
      <xsl:when test="$label = 'zoll_abgaben'">
        <xsl:text>Zoll- und andere Abgaben:</xsl:text>
      </xsl:when>
      <xsl:when test="$label = 'mwst_abgaben'">
        <xsl:text>MWST-Abgaben:</xsl:text>
      </xsl:when>
      <xsl:when test="$label = 'totals'">
        <xsl:text>Total:</xsl:text>
      </xsl:when>
      <xsl:when test="$label = 'zollstelle'">
        <xsl:text>Zollstelle:</xsl:text>
      </xsl:when>
      <xsl:when test="$label = 'document_type_ref'">
        <xsl:text>1):</xsl:text>
      </xsl:when>
      <xsl:when test="$label = 'referenz_spediteur'">
        <xsl:text>Referenz Spediteur:</xsl:text>
      </xsl:when>
      <xsl:when test="$label = 'referenz_zoll'">
        <xsl:text>Referenz Zoll:</xsl:text>
      </xsl:when>
      <xsl:when test="$label = 'legende'">
        <xsl:text>Legende:</xsl:text>
      </xsl:when>
      <xsl:when test="$label = 'legende_vvz'">
        <xsl:text>VVZ = Veranlagungsverfügung Zoll</xsl:text>
      </xsl:when>
      <xsl:when test="$label = 'legende_vvm'">
        <xsl:text>VVM = Veranlagungsverfügung MWST</xsl:text>
      </xsl:when>
      <xsl:when test="$label = 'legende_rbz'">
        <xsl:text>RBZ = Beleg für Rückerstattungen Zollabgaben</xsl:text>
      </xsl:when>
      <xsl:when test="$label = 'legende_rbm'">
        <xsl:text>RBM = Beleg für Rückerstattungen MWST-Abgaben</xsl:text>
      </xsl:when>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="TranslateFR">
    <xsl:param name="label" select="/.." />
    <xsl:choose>
      <xsl:when test="$label = 'eidgenoessische_zollverwaltung_ezv'">
        <xsl:text>Administration f&#233;d&#233;rale des douanes AFD</xsl:text>
      </xsl:when>
      <xsl:when test="$label = 'eidgenoessisches_finanzdepartement_efd'">
        <xsl:text>D&#233;partement f&#233;d&#233;ral des finances DFF</xsl:text>
      </xsl:when>
      <xsl:when test="$label = 'verarbeitungszentrum'">
        <xsl:text>Verarbeitungszentrum:</xsl:text>
      </xsl:when>
      <xsl:when test="$label = 'account'">
        <xsl:text>Konto:</xsl:text>
      </xsl:when>
      <xsl:when test="$label = 'anzahl_belege'">
        <xsl:text>Anzahl Belege:</xsl:text>
      </xsl:when>
      <xsl:when test="$label = 'betrag_chf'">
        <xsl:text>Betrag [CHF]:</xsl:text>
      </xsl:when>
      <xsl:when test="$label = 'zoll_abgaben'">
        <xsl:text>Zoll- und andere Abgaben:</xsl:text>
      </xsl:when>
      <xsl:when test="$label = 'mwst_abgaben'">
        <xsl:text>MWST-Abgaben:</xsl:text>
      </xsl:when>
      <xsl:when test="$label = 'totals'">
        <xsl:text>Total:</xsl:text>
      </xsl:when>
      <xsl:when test="$label = 'zollstelle'">
        <xsl:text>Zollstelle:</xsl:text>
      </xsl:when>
      <xsl:when test="$label = 'document_type_ref'">
        <xsl:text>1):</xsl:text>
      </xsl:when>
      <xsl:when test="$label = 'referenz_spediteur'">
        <xsl:text>Referenz Spediteur:</xsl:text>
      </xsl:when>
      <xsl:when test="$label = 'referenz_zoll'">
        <xsl:text>Referenz Zoll:</xsl:text>
      </xsl:when>
      <xsl:when test="$label = 'legende'">
        <xsl:text>Legende:</xsl:text>
      </xsl:when>
      <xsl:when test="$label = 'legende_vvz'">
        <xsl:text>VVZ = Veranlagungsverfügung Zoll</xsl:text>
      </xsl:when>
      <xsl:when test="$label = 'legende_vvm'">
        <xsl:text>VVM = Veranlagungsverfügung MWST</xsl:text>
      </xsl:when>
      <xsl:when test="$label = 'legende_rbz'">
        <xsl:text>RBZ = Beleg für Rückerstattungen Zollabgaben</xsl:text>
      </xsl:when>
      <xsl:when test="$label = 'legende_rbm'">
        <xsl:text>RBM = Beleg für Rückerstattungen MWST-Abgaben</xsl:text>
      </xsl:when>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="TranslateIT">
    <xsl:param name="label" select="/.." />
    <xsl:choose>
      <xsl:when test="$label = 'eidgenoessische_zollverwaltung_ezv'">
        <xsl:text>Amministrazione federale delle dogane AFD</xsl:text>
      </xsl:when>
      <xsl:when test="$label = 'eidgenoessisches_finanzdepartement_efd'">
        <xsl:text>Dipartimento federale delle finanze DFF</xsl:text>
      </xsl:when>
      <xsl:when test="$label = 'verarbeitungszentrum'">
        <xsl:text>Verarbeitungszentrum:</xsl:text>
      </xsl:when>
      <xsl:when test="$label = 'account'">
        <xsl:text>Konto:</xsl:text>
      </xsl:when>
      <xsl:when test="$label = 'anzahl_belege'">
        <xsl:text>Anzahl Belege:</xsl:text>
      </xsl:when>
      <xsl:when test="$label = 'betrag_chf'">
        <xsl:text>Betrag [CHF]:</xsl:text>
      </xsl:when>
      <xsl:when test="$label = 'zoll_abgaben'">
        <xsl:text>Zoll- und andere Abgaben:</xsl:text>
      </xsl:when>
      <xsl:when test="$label = 'mwst_abgaben'">
        <xsl:text>MWST-Abgaben:</xsl:text>
      </xsl:when>
      <xsl:when test="$label = 'totals'">
        <xsl:text>Total:</xsl:text>
      </xsl:when>
      <xsl:when test="$label = 'zollstelle'">
        <xsl:text>Zollstelle:</xsl:text>
      </xsl:when>
      <xsl:when test="$label = 'document_type_ref'">
        <xsl:text>1)</xsl:text>
      </xsl:when>
      <xsl:when test="$label = 'referenz_spediteur'">
        <xsl:text>Referenz Spediteur:</xsl:text>
      </xsl:when>
      <xsl:when test="$label = 'referenz_zoll'">
        <xsl:text>Referenz Zoll:</xsl:text>
      </xsl:when>
      <xsl:when test="$label = 'legende'">
        <xsl:text>Legende:</xsl:text>
      </xsl:when>
      <xsl:when test="$label = 'legende_vvz'">
        <xsl:text>VVZ = Veranlagungsverfügung Zoll</xsl:text>
      </xsl:when>
      <xsl:when test="$label = 'legende_vvm'">
        <xsl:text>VVM = Veranlagungsverfügung MWST</xsl:text>
      </xsl:when>
      <xsl:when test="$label = 'legende_rbz'">
        <xsl:text>RBZ = Beleg für Rückerstattungen Zollabgaben</xsl:text>
      </xsl:when>
      <xsl:when test="$label = 'legende_rbm'">
        <xsl:text>RBM = Beleg für Rückerstattungen MWST-Abgaben</xsl:text>
      </xsl:when>

    </xsl:choose>
  </xsl:template>


</xsl:stylesheet>
