/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.bootstrap;

import ch.transsoft.bootstrap.Main;
import ch.transsoft.bootstrap.util.Logging;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;

public class Environment {
    public static Path getDownloadedJarDirectory() {
        return Environment.getWorkingDirectory().getParent().resolve("launcher").resolve("jars");
    }

    public static Path getWorkingDirectory() {
        return Environment.getUserHomeDir().resolve(".transsoft").resolve("expovit");
    }

    public static Path getUserHomeDir() {
        return Path.of(System.getProperty("user.home"), new String[0]);
    }

    public static Path getJarPath() {
        try {
            return Paths.get(Main.class.getProtectionDomain().getCodeSource().getLocation().toURI());
        }
        catch (URISyntaxException e) {
            Logging.getLogger().severe("Failed to construct bootstrap.jar path: " + e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public static Path getInstalledJarDir() {
        return Environment.getJarPath().getParent();
    }

    public static String getJarPathOrEmpty() {
        try {
            return Paths.get(Main.class.getProtectionDomain().getCodeSource().getLocation().toURI()).toString();
        }
        catch (URISyntaxException e) {
            return "";
        }
    }

    private static Path getLogDirectory() {
        String profile = System.getenv("APPDATA");
        if (profile == null) {
            return Environment.getUserHomeDir();
        }
        return Path.of(profile, new String[0]);
    }

    public static String getLogPath() {
        Path roamingDir = Environment.getLogDirectory();
        Path logDir = roamingDir.resolve("expovit").resolve("log");
        logDir.toFile().mkdirs();
        Path logFile = logDir.resolve("bootstrap.log");
        return logFile.toString();
    }

    public static String getProcessCommandOrEmpty() {
        return ProcessHandle.current().info().command().orElse("");
    }
}

