/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.bootstrap.util;

import java.io.File;
import org.jetbrains.annotations.NotNull;

public final class LauncherFileName
implements Comparable<LauncherFileName> {
    private final File file;
    private int major = 0;
    private int minor = 0;
    private int patch = 0;
    private int buildNumber = 0;
    private boolean valid = true;
    public static final String LAUNCHER_JAR_PREFIX = "launcher-all";
    public static final String LAUNCHER_JAR_ENDING = ".jar";

    public LauncherFileName(File file) {
        this.file = file;
        try {
            String[] mainSegs;
            String[] initialSegs = this.extractVersion().split("-");
            if (initialSegs.length == 0 || initialSegs.length == 1 && initialSegs[0].isBlank()) {
                throw new IllegalArgumentException("Empty version string");
            }
            if (initialSegs.length > 2) {
                throw new IllegalArgumentException("More than one dash in version!");
            }
            if (initialSegs.length == 2) {
                this.buildNumber = Integer.parseInt(initialSegs[1]);
            }
            if ((mainSegs = initialSegs[0].split("\\.")).length > 3) {
                throw new IllegalArgumentException("Version string contains more than 3 segments plus build");
            }
            this.major = this.extractVersionAtPos(mainSegs, 0);
            this.minor = this.extractVersionAtPos(mainSegs, 1);
            this.patch = this.extractVersionAtPos(mainSegs, 2);
        }
        catch (Exception ignored) {
            this.valid = false;
        }
    }

    private int extractVersionAtPos(String[] segStrs, int i) {
        if (i > segStrs.length - 1) {
            return 0;
        }
        if (segStrs[i].isEmpty()) {
            return 0;
        }
        return Integer.parseInt(segStrs[i]);
    }

    @NotNull
    private String extractVersion() {
        String fileName = this.getFile().getName();
        if (!fileName.startsWith(LAUNCHER_JAR_PREFIX) || !fileName.endsWith(LAUNCHER_JAR_ENDING)) {
            throw new IllegalArgumentException("File is not a launcher jar: " + fileName);
        }
        int startIndex = "launcher-all-".length();
        int endIndex = fileName.length() - LAUNCHER_JAR_ENDING.length();
        return fileName.substring(startIndex, endIndex);
    }

    public boolean isSmaller(LauncherFileName other) {
        if (this.major != other.major) {
            return this.major < other.major;
        }
        if (this.minor != other.minor) {
            return this.minor < other.minor;
        }
        if (this.patch != other.patch) {
            return this.patch < other.patch;
        }
        if (this.buildNumber == other.buildNumber) {
            return false;
        }
        if (this.buildNumber == 0) {
            return false;
        }
        if (other.buildNumber == 0) {
            return true;
        }
        return this.buildNumber < other.buildNumber;
    }

    public String toString() {
        return this.major + "." + this.minor + "." + this.patch + (String)(this.buildNumber > 0 ? "-" + this.buildNumber : "");
    }

    @Override
    public int compareTo(@NotNull LauncherFileName o) {
        if (this.isSmaller(o)) {
            return -1;
        }
        if (o.isSmaller(this)) {
            return 1;
        }
        return 0;
    }

    public File getFile() {
        return this.file;
    }

    public static boolean majorMinorEquals(File first, File second) {
        return new LauncherFileName(first).majorMinorEquals(new LauncherFileName(second));
    }

    private boolean majorMinorEquals(LauncherFileName other) {
        if (this.major != other.major) {
            return false;
        }
        return this.minor == other.minor;
    }

    public int getBuildNumber() {
        return this.buildNumber;
    }

    public boolean isValid() {
        return this.valid;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getMajor() {
        return this.major;
    }

    public int getPatch() {
        return this.patch;
    }
}

