/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.expovit.model.infra.node;

import ch.transsoft.expovit.model.infra.ITraversal;
import ch.transsoft.expovit.model.infra.IXMLWriter;
import ch.transsoft.expovit.model.infra.LoggingContext;
import ch.transsoft.expovit.model.infra.node.ModelNode;
import ch.transsoft.expovit.model.infra.node.PrimitiveBase;
import ch.transsoft.expovit.util.Check;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class BinaryNode
extends PrimitiveBase<BinaryNode> {
    public static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private byte[] value;

    public BinaryNode() {
    }

    public BinaryNode(String value) {
        this.value = value.getBytes(DEFAULT_CHARSET);
    }

    public BinaryNode(byte[] value) {
        this.value = value;
    }

    @Override
    public String getStringValue() {
        if (!this.isInitialized()) {
            return "";
        }
        String result = new String(this.value, DEFAULT_CHARSET);
        Check.assertTrue(Arrays.equals(this.value, result.getBytes(DEFAULT_CHARSET)), "Binary conversion error: " + Arrays.toString(Arrays.copyOf(this.value, Math.min(this.value.length, 20))));
        return result;
    }

    public void setStringValue(String value) {
        this.setValue(value.getBytes(DEFAULT_CHARSET));
    }

    @Override
    public void parseValue(LoggingContext context, String str) {
        Check.assertNotNull(str);
        this.value = str.getBytes(DEFAULT_CHARSET);
    }

    public void setValue(byte[] value) {
        this.setValue(value, true);
    }

    public void setValue(byte[] value, boolean dirty) {
        this.value = value;
        if (this.isSameValue(this.value, value)) {
            return;
        }
        this.fireEvent(dirty);
    }

    @Override
    public boolean isInitialized() {
        return this.value != null;
    }

    @Override
    protected void printInitializedField(Node node, IXMLWriter writer, String tagName) {
        Element child = writer.createElement(node, tagName);
        writer.createCDATAChild(child, this.getStringValue());
    }

    @Override
    String getXmlValueString() {
        return "";
    }

    @Override
    public String getValue() {
        return this.getStringValue();
    }

    public String toString() {
        return this.getStringValue();
    }

    @Override
    public void setValue(Object value, boolean dirty) {
        this.setValue((byte[])value, dirty);
    }

    @Override
    public BinaryNode getCopy(ModelNode<?> parent) {
        BinaryNode result = new BinaryNode(this.value);
        super.completeCopy(result, parent);
        return result;
    }

    @Override
    public boolean isEqual(BinaryNode other) {
        return this.isSameValue(this.value, other.value);
    }

    @Override
    public void traverse(ITraversal traversal) {
        traversal.visit(this);
    }

    @Override
    public void clear() {
        this.setValue(null, true);
    }

    @Override
    public void cumulate(BinaryNode other) {
    }

    public InputStream asInputStream() {
        Check.assertTrue(this.isInitialized(), new Object[0]);
        return new ByteArrayInputStream(this.value);
    }

    public byte[] getByteArray() {
        return this.value;
    }

    public static interface Listener {
        public void changed(BinaryNode var1);
    }
}

