/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.expovit.model.infra.node;

import ch.transsoft.expovit.model.infra.ITraversal;
import ch.transsoft.expovit.model.infra.LoggingContext;
import ch.transsoft.expovit.model.infra.node.INumberNode;
import ch.transsoft.expovit.model.infra.node.ModelNode;
import ch.transsoft.expovit.model.infra.node.PrimitiveBase;
import ch.transsoft.expovit.service.Services;
import ch.transsoft.expovit.util.Check;
import ch.transsoft.expovit.util.NumberUtil;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;

public class DecimalNode
extends PrimitiveBase<DecimalNode>
implements INumberNode<DecimalNode> {
    private Double value;
    private int fractionDigits;
    private DecimalFormat format;

    public DecimalNode(int fractionDigits) {
        this(null, fractionDigits);
    }

    public DecimalNode(Double value, int fractionDigits) {
        this.setDigits(fractionDigits);
        this.setValue(value, true);
    }

    @Override
    public String getStringValue() {
        if (!this.isInitialized()) {
            return "";
        }
        return this.getFormat().format(this.getValue());
    }

    @Override
    public boolean isInitialized() {
        return this.value != null;
    }

    @Override
    String getXmlValueString() {
        return this.getStringValue();
    }

    public String toString() {
        if (this.format == null || !this.isInitialized()) {
            return this.getStringValue();
        }
        return this.format.format(this.getValue());
    }

    @Override
    public Double getValue() {
        return this.value;
    }

    public void setValue(Number value) {
        this.setValue(value, true);
    }

    public void setValue(Number value, boolean dirty) {
        if (this.isSameValue(value)) {
            return;
        }
        if (value == null) {
            this.value = null;
        } else {
            try {
                this.value = this.getFormat().parse(this.getFormat().format(value)).doubleValue();
            }
            catch (ParseException e) {
                this.value = null;
            }
        }
        this.fireEvent(dirty);
    }

    private boolean isSameValue(Number other) {
        if (this.value == null && other == null) {
            return true;
        }
        if (this.value == null || other == null) {
            return false;
        }
        return this.value.doubleValue() == other.doubleValue();
    }

    @Override
    public void parseValue(LoggingContext context, String str) {
        String trimmed2 = str.trim().replace("\u2019", "").replace(",", "");
        if (trimmed2.isEmpty()) {
            return;
        }
        try {
            this.setValue(this.getFormat().parse(trimmed2), true);
        }
        catch (ParseException e) {
            context.log(this.getPath() + Services.getText("607") + str);
        }
    }

    @Override
    public void setValue(Object value, boolean dirty) {
        if (value instanceof String) {
            try {
                this.setValue(this.getFormat().parse((String)value), dirty);
            }
            catch (Exception e) {
                this.setValue(null, dirty);
            }
            return;
        }
        this.setValue((Number)value, dirty);
    }

    public int getFractionDigits() {
        return this.fractionDigits;
    }

    private void setDigits(int fractionDigits) {
        this.fractionDigits = fractionDigits;
        this.format = NumberUtil.createNumberFormat();
        this.format.setMaximumFractionDigits(fractionDigits);
        this.format.setMinimumFractionDigits(fractionDigits);
    }

    @Override
    public DecimalNode getCopy(ModelNode<?> parent) {
        DecimalNode result = new DecimalNode(this.value, this.fractionDigits);
        super.completeCopy(result, parent);
        return result;
    }

    @Override
    public boolean isEqual(DecimalNode other) {
        return this.isSameValue(this.value, other.value);
    }

    public BigDecimal asBigDecimal() {
        return BigDecimal.valueOf(this.value);
    }

    public NumberFormat getFormat() {
        Check.assertNotNull(this.format);
        return this.format;
    }

    public void add(DecimalNode summand) {
        if (summand == null) {
            return;
        }
        if (!summand.isInitialized()) {
            return;
        }
        if (!this.isInitialized()) {
            this.setValue(summand.value, false);
            return;
        }
        this.setValue(this.getValue() + summand.getValue(), false);
    }

    @Override
    public void cumulate(DecimalNode summand) {
        if (summand == null) {
            return;
        }
        this.add(summand);
    }

    @Override
    public void traverse(ITraversal traversal) {
        traversal.visit(this);
    }

    @Override
    public void clear() {
        this.setValue(null, true);
    }

    @Override
    public Double getAsNumber() {
        return this.value;
    }
}

