/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.expovit.model.infra.node;

import ch.transsoft.expovit.model.infra.ITraversal;
import ch.transsoft.expovit.model.infra.LoggingContext;
import ch.transsoft.expovit.model.infra.node.ModelNode;
import ch.transsoft.expovit.model.infra.node.PrimitiveBase;
import ch.transsoft.expovit.service.Services;
import ch.transsoft.expovit.util.Check;
import ch.transsoft.expovit.util.DateUtil;
import java.util.Calendar;

public final class EdecDateNode
extends PrimitiveBase<EdecDateNode> {
    private static final int UNINITIALIZED_VALUE = Integer.MIN_VALUE;
    private int year = Integer.MIN_VALUE;
    private int month = Integer.MIN_VALUE;
    private int day = Integer.MIN_VALUE;

    public EdecDateNode() {
    }

    public EdecDateNode(String date) {
        this.parseValue(new LoggingContext(), date);
    }

    public EdecDateNode(int year, int month, int day) {
        this.year = year;
        this.month = month;
        this.day = day;
    }

    @Override
    String getXmlValueString() {
        return this.getStringValue();
    }

    private void setValue(String value) {
        if (value == null) {
            this.year = Integer.MIN_VALUE;
            this.month = Integer.MIN_VALUE;
            this.day = Integer.MIN_VALUE;
            return;
        }
        Check.assertTrue(DateUtil.isEdecDate(value), "Invalid date: " + value);
        this.year = Integer.parseInt(value.substring(0, 4));
        this.month = Integer.parseInt(value.substring(5, 7));
        this.day = Integer.parseInt(value.substring(8, 10));
    }

    public void setValue(String value, boolean dirty) {
        if (this.isSameValue(this.getValue(), value)) {
            return;
        }
        this.setValue(value);
        this.fireEvent(dirty);
    }

    @Override
    public boolean isInitialized() {
        return this.year != Integer.MIN_VALUE;
    }

    @Override
    public String getValue() {
        if (!this.isInitialized()) {
            return null;
        }
        return DateUtil.asEdecDate(this.year, this.month, this.day);
    }

    @Override
    public String getStringValue() {
        if (!this.isInitialized()) {
            return "";
        }
        return this.getValue();
    }

    @Override
    public EdecDateNode getCopy(ModelNode<?> parent) {
        EdecDateNode result = new EdecDateNode(this.getYear(), this.getMonth(), this.getDay());
        super.completeCopy(result, parent);
        return result;
    }

    public int getDay() {
        return this.day;
    }

    public int getMonth() {
        return this.month;
    }

    public int getYear() {
        return this.year;
    }

    @Override
    public boolean isEqual(EdecDateNode other) {
        return this.isSameValue(this.getValue(), other.getValue());
    }

    @Override
    public void parseValue(LoggingContext context, String str) {
        if (str.isEmpty()) {
            return;
        }
        if (this.isLong(str)) {
            Calendar cal = DateUtil.createGregorianCalendar();
            cal.setTimeInMillis(Long.parseLong(str));
            this.year = cal.get(1);
            this.month = cal.get(2) + 1;
            this.day = cal.get(5);
            if (cal.get(11) < 12) {
                --this.day;
            }
            this.fireEvent();
            return;
        }
        if (!DateUtil.isEdecDate(str)) {
            context.log(this.getPath() + Services.getText("606") + " " + str);
            return;
        }
        this.setValue(str, true);
    }

    private boolean isLong(String date) {
        try {
            Long.parseLong(date);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    public void setValue(Object value, boolean dirty) {
        if (value == null) {
            this.setValue(null, dirty);
            return;
        }
        if (value instanceof String) {
            this.setValue((String)value, dirty);
            return;
        }
        Check.fail("Unexpected type for EdecDate: " + value.getClass().getName());
    }

    public String toString() {
        if (!this.isInitialized()) {
            return "";
        }
        return DateUtil.asEdecDate(this.year, this.month, this.day);
    }

    @Override
    public void traverse(ITraversal traversal) {
        traversal.visit(this);
    }

    @Override
    public void clear() {
        this.setValue(null, true);
    }

    @Override
    public void cumulate(EdecDateNode other) {
    }

    public boolean before(EdecDateNode date) {
        if (this.getYear() < date.getYear()) {
            return true;
        }
        if (this.getYear() > date.getYear()) {
            return false;
        }
        if (this.getMonth() < date.getMonth()) {
            return true;
        }
        if (this.getMonth() > date.getMonth()) {
            return false;
        }
        return this.getDay() < date.getDay();
    }

    public boolean isSame(EdecDateNode d2) {
        return this.getYear() == d2.getYear() && this.getMonth() == d2.getMonth() && this.getDay() == d2.getDay();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EdecDateNode that = (EdecDateNode)o;
        if (this.year != that.year) {
            return false;
        }
        if (this.month != that.month) {
            return false;
        }
        return this.day == that.day;
    }

    public int hashCode() {
        int result = this.year;
        result = 31 * result + this.month;
        result = 31 * result + this.day;
        return result;
    }
}

