/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.expovit.model.infra.node;

import ch.transsoft.expovit.model.infra.ITraversal;
import ch.transsoft.expovit.model.infra.IXMLWriter;
import ch.transsoft.expovit.model.infra.InjectionSpec;
import ch.transsoft.expovit.model.infra.node.ModelNode;
import ch.transsoft.expovit.model.infra.node.NodeBase;
import ch.transsoft.expovit.util.Check;
import org.w3c.dom.Node;

public final class EnumNode<T extends Enum<T>>
extends NodeBase<EnumNode<T>> {
    private T value;

    public EnumNode(T value) {
        this.value = value;
    }

    @Override
    public void printField(Node node, IXMLWriter writer, String tagName) throws Exception {
        writer.appendTextNode(node, tagName, ((Enum)this.value).name());
    }

    public void setValue(T value) {
        Check.assertNotNull(value, "Enum value must not be null");
        if (((Enum)this.value).equals(value)) {
            return;
        }
        this.value = value;
        this.fireEvent();
    }

    public T getValue() {
        return this.value;
    }

    @Override
    public EnumNode<T> getCopy(ModelNode<?> parent) {
        EnumNode<T> result = new EnumNode<T>(this.value);
        super.completeCopy(result, parent);
        return result;
    }

    @Override
    public void apply(EnumNode<T> other) {
        this.setValue(other.getValue());
    }

    @Override
    public boolean isEqual(EnumNode<T> other) {
        return this.isSameValue(this.value, other.value);
    }

    @Override
    public void traverse(ITraversal traversal) {
        traversal.visit(this);
    }

    @Override
    public void inject(EnumNode<T> other, InjectionSpec spec) {
        this.apply(other);
    }

    @Override
    public void cumulate(EnumNode<T> other) {
    }
}

