/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.expovit.model.infra.node;

import ch.transsoft.expovit.model.infra.IXMLWriter;
import ch.transsoft.expovit.model.infra.InjectionSpec;
import ch.transsoft.expovit.model.infra.node.IPrimitive;
import ch.transsoft.expovit.model.infra.node.NodeBase;
import org.w3c.dom.Node;

public abstract class PrimitiveBase<T extends PrimitiveBase<T>>
extends NodeBase<T>
implements IPrimitive<T> {
    @Override
    public void inject(T other, InjectionSpec spec) {
        if (!spec.injectTarget(this, other)) {
            return;
        }
        if (!spec.overwrite() && this.isInitialized()) {
            return;
        }
        if (spec.useUninitialized() || other.isInitialized()) {
            this.apply(other, spec.isDirty());
        }
        this.repair(other, spec);
    }

    protected void repair(T other, InjectionSpec spec) {
        spec.repair(this.getParent(), this, other);
    }

    @Override
    public void printField(Node node, IXMLWriter writer, String tagName) {
        if (!this.isInitialized()) {
            return;
        }
        this.printInitializedField(node, writer, tagName);
    }

    protected void printInitializedField(Node node, IXMLWriter writer, String tagName) {
        writer.appendTextNode(node, tagName, this.getXmlValueString());
    }

    @Override
    public void apply(T other) {
        this.setValue(other.getValue(), true);
    }

    public void apply(T other, boolean dirty) {
        this.setValue(other.getValue(), dirty);
    }

    abstract String getXmlValueString();
}

