/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.expovit.model.infra.node;

import ch.transsoft.expovit.model.infra.ITraversal;
import ch.transsoft.expovit.model.infra.LoggingContext;
import ch.transsoft.expovit.model.infra.node.IStringNodeValidator;
import ch.transsoft.expovit.model.infra.node.ModelNode;
import ch.transsoft.expovit.model.infra.node.NodeBase;
import ch.transsoft.expovit.model.infra.node.PrimitiveBase;
import ch.transsoft.expovit.service.Services;
import ch.transsoft.expovit.util.Check;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StringNodeBase<T extends StringNodeBase<T>>
extends PrimitiveBase<StringNodeBase<T>> {
    @NotNull
    private String value;
    private int maxLength;
    private boolean trimmed = false;
    protected IStringNodeValidator validator;

    public StringNodeBase(String value) {
        this(value, Integer.MAX_VALUE);
    }

    public StringNodeBase(@Nullable String value, int maxLength) {
        this.value = value == null ? "" : value;
        this.maxLength = maxLength;
        Check.assertTrue(maxLength > 0, "invalid length:", maxLength);
    }

    @Override
    public String getStringValue() {
        return this.getValue();
    }

    @Override
    public void parseValue(LoggingContext context, String str) {
        Check.assertNotNull(str);
        if (str.length() > this.getMaxLength()) {
            String logStr = str.substring(0, this.getMaxLength()) + "|" + str.substring(this.getMaxLength());
            context.log(this.getPath() + String.format(Services.getText("611"), this.getMaxLength()) + logStr);
            str = str.substring(0, this.getMaxLength());
        }
        this.setValue(str, true);
        if (!str.isEmpty() && this.getValue().isEmpty()) {
            context.log(this.getPath() + Services.getText("610") + str);
        }
    }

    public void setValue(String value) {
        this.setValue(value, true);
    }

    public void setValue(String value, boolean dirty) {
        if (value == null) {
            value = "";
        }
        if (this.isSameValue(this.value, value)) {
            return;
        }
        if (this.trimmed) {
            value = value.trim();
        }
        if (this.validator != null) {
            value = this.validator.validate(value, this.value);
        }
        this.value = value;
        this.fireEvent(dirty);
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    @Override
    public boolean isInitialized() {
        return !this.value.isEmpty();
    }

    @Override
    String getXmlValueString() {
        return this.getStringValue();
    }

    @Override
    @NotNull
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.getValue();
    }

    @Override
    public void setValue(Object value, boolean dirty) {
        this.setValue((String)value, dirty);
    }

    public IStringNodeValidator getValidator() {
        return this.validator;
    }

    public void setValidator(IStringNodeValidator validator2) {
        this.validator = validator2;
    }

    public void setTrimmed(boolean trimmed2) {
        this.trimmed = trimmed2;
    }

    @Override
    public T getCopy(ModelNode<?> parent) {
        T result = this.createInstance();
        ((StringNodeBase)result).validator = this.validator;
        super.completeCopy((NodeBase<?>)result, parent);
        return result;
    }

    protected abstract T createInstance();

    @Override
    public boolean isEqual(StringNodeBase<T> other) {
        return this.isSameValue(this.value, other.value);
    }

    @Override
    public void traverse(ITraversal traversal) {
        traversal.visit(this);
    }

    @Override
    public void clear() {
        this.setValue("", true);
    }

    @Override
    public void cumulate(StringNodeBase<T> other) {
        if (this.isInitialized()) {
            return;
        }
        this.apply(other);
    }

    public boolean isEmpty() {
        return "".equals(this.value);
    }
}

