/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.expovit.model.infra.node.list;

import ch.transsoft.expovit.model.infra.ITraversal;
import ch.transsoft.expovit.model.infra.IXMLWriter;
import ch.transsoft.expovit.model.infra.InjectionSpec;
import ch.transsoft.expovit.model.infra.event.IChangeInfo;
import ch.transsoft.expovit.model.infra.event.IChangeListener;
import ch.transsoft.expovit.model.infra.node.INode;
import ch.transsoft.expovit.model.infra.node.ListEntry;
import ch.transsoft.expovit.model.infra.node.ModelNode;
import ch.transsoft.expovit.model.infra.node.NodeBase;
import ch.transsoft.expovit.model.infra.node.list.ListElementAdded;
import ch.transsoft.expovit.model.infra.node.list.ListElementMoved;
import ch.transsoft.expovit.model.infra.node.list.ListElementRemoved;
import ch.transsoft.expovit.util.Check;
import ch.transsoft.expovit.util.disposable.IDisposable;
import ch.transsoft.expovit.util.disposable.ListenerList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class ListNodeBase<T extends ListNodeBase<T, E>, E extends ListEntry<E>>
extends ModelNode<T>
implements Iterable<E> {
    protected List<E> list = new ArrayList();
    protected final Class<E> type;
    @Nullable
    protected Integer maxLength;
    private final ListenerList<IChangeListener> listChangeListeners = new ListenerList();

    public ListNodeBase(Class<E> type, Integer maxLength) {
        this.type = type;
        this.maxLength = maxLength;
    }

    public ListNodeBase(Class<E> type) {
        this.type = type;
    }

    public ListNodeBase(List<E> list, Class<E> type) {
        this.list = list;
        this.type = type;
    }

    public Class<E> getType() {
        return this.type;
    }

    public void add(E element) {
        this.add(this.list.size(), element);
    }

    public void add(int index, E element) {
        ((NodeBase)element).setParent(this);
        this.list.add(index, element);
        this.fireEvent(new ListElementAdded(index, (INode<?>)element));
    }

    public void remove(E obj) {
        int index = this.list.indexOf(obj);
        Check.assertTrue(this.list.remove(obj), new Object[0]);
        ((NodeBase)obj).setParent(null);
        this.fireEvent(new ListElementRemoved(index));
        this.removeError((INode<?>)obj);
    }

    private void removeError(INode<?> node) {
        if (node.getErrorInfo().hasError()) {
            this.decrementErrorCount(node.getErrorInfo().errorCount());
        }
    }

    public E remove(int row) {
        ListEntry result = (ListEntry)this.list.remove(row);
        result.setParent(null);
        this.fireEvent(new ListElementRemoved(row));
        this.removeError(result);
        return (E)result;
    }

    @Override
    public void printField(Node node, IXMLWriter writer, String tagName) throws Exception {
        Element listNode = this.printModelNode(node, writer, tagName);
        this.listElements(listNode, this, writer);
    }

    private void listElements(Node parent, ListNodeBase<T, E> list, IXMLWriter writer) throws Exception {
        if (list.isEmpty()) {
            return;
        }
        String simpleName = list.get(0).getClass().getSimpleName();
        for (ListEntry element : list) {
            element.printField(parent, writer, simpleName);
        }
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        return this.list.iterator();
    }

    public E get(int pos) {
        return (E)((ListEntry)this.list.get(pos));
    }

    public E getFirst() {
        return (E)((ListEntry)this.list.getFirst());
    }

    public String toString() {
        return this.list.toString();
    }

    public int size() {
        return this.list.size();
    }

    public int indexOf(E E) {
        return this.list.indexOf(E);
    }

    public Stream<E> stream() {
        return this.list.stream();
    }

    @Override
    public T getCopy(ModelNode<?> parent) {
        return this.getCopy(parent, item -> true);
    }

    public T getCopy(ModelNode<?> parent, Predicate<E> predicate) {
        T result = this.createListNode();
        this.completeCopy((NodeBase<?>)result, parent);
        for (ListEntry child : this.list) {
            if (!predicate.test(child)) continue;
            ((ListNodeBase)result).add((ListEntry)((ListEntry)child.getCopy((ModelNode)result)));
        }
        ((ListNodeBase)result).maxLength = this.maxLength;
        return result;
    }

    protected abstract T createListNode();

    @Override
    public void apply(T other) {
    }

    @Override
    public boolean isEqual(T other) {
        throw Check.fail("equals() is not supported for ListNodes");
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public void traverse(ITraversal traversal) {
        traversal.visit(this);
        for (ListEntry E : this.list) {
            E.traverse(traversal);
        }
    }

    public String getPath(E child) {
        return this.getPath() + this.getChildNumber(child);
    }

    private String getChildNumber(E child) {
        int index = this.list.indexOf(child);
        return "[" + index + "]";
    }

    public E getLastItem() {
        Check.assertFalse(this.isEmpty(), "getLastItem not possible on empty list");
        return (E)((ListEntry)this.list.getLast());
    }

    @Override
    public void inject(T other, InjectionSpec spec) {
        if (spec.useUninitialized() || ((NodeBase)other).isEnabled()) {
            this.setEnabled(((NodeBase)other).isEnabled());
        }
        for (ListEntry element : other) {
            ListEntry copy = (ListEntry)element.getCopy((ModelNode)null);
            this.repair(copy, element, spec);
            this.add(copy);
        }
    }

    protected void repair(E copy, E element, InjectionSpec spec) {
        spec.repair(this, copy, element);
    }

    public void clear() {
        this.list.clear();
    }

    public void moveDown(E selected) {
        if (this.list.size() < 2) {
            return;
        }
        int index = this.list.indexOf(selected);
        Check.assertTrue(index != -1, "element to move not in list " + String.valueOf(selected));
        this.list.remove(index);
        this.list.add(index + 1, selected);
        this.fireEvent(new ListElementMoved((ListEntry<?>)selected, index, index + 1));
    }

    public void moveUp(E selected) {
        if (this.list.size() < 2) {
            return;
        }
        int index = this.list.indexOf(selected);
        Check.assertTrue(index != -1, "element to move not in list " + String.valueOf(selected));
        this.list.remove(index);
        this.list.add(index - 1, selected);
        this.fireEvent(new ListElementMoved((ListEntry<?>)selected, index, index - 1));
    }

    @Override
    public void cumulate(T other) {
        for (ListEntry element : other) {
            this.add(element);
        }
    }

    public boolean validateSizeConstraint() {
        if (this.maxLength == null) {
            return true;
        }
        return this.list.size() <= this.maxLength;
    }

    public String getMaxElementsString() {
        return this.maxLength == null ? "undefined" : this.maxLength.toString();
    }

    @Nullable
    public Integer getMaxLength() {
        return this.maxLength;
    }

    public IDisposable addListChangeListener(IChangeListener listener) {
        return this.getListChangeListeners().add(listener);
    }

    private ListenerList<IChangeListener> getListChangeListeners() {
        return this.listChangeListeners;
    }

    @Override
    public void fireEvent(IChangeInfo info) {
        this.notifyListChangeListeners(info);
        super.fireEvent(info);
    }

    private void notifyListChangeListeners(IChangeInfo info) {
        for (IChangeListener listener : this.listChangeListeners) {
            listener.changed(this, info);
        }
    }
}

