/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.expovit.model.infra.nodetypes;

import ch.transsoft.expovit.model.infra.node.BinaryNode;
import ch.transsoft.expovit.model.infra.node.BooleanNode;
import ch.transsoft.expovit.model.infra.node.DateNode;
import ch.transsoft.expovit.model.infra.node.DateTimeNode;
import ch.transsoft.expovit.model.infra.node.DecimalNode;
import ch.transsoft.expovit.model.infra.node.EdecDateNode;
import ch.transsoft.expovit.model.infra.node.EnumNode;
import ch.transsoft.expovit.model.infra.node.FileNode;
import ch.transsoft.expovit.model.infra.node.IntegralNode;
import ch.transsoft.expovit.model.infra.node.ModelNode;
import ch.transsoft.expovit.model.infra.node.StringNode;
import ch.transsoft.expovit.model.infra.node.TimestampNode;
import ch.transsoft.expovit.model.infra.node.list.ListNodeBase;
import ch.transsoft.expovit.model.infra.nodetypes.BinaryNodeNodeType;
import ch.transsoft.expovit.model.infra.nodetypes.BooleanNodeNodeType;
import ch.transsoft.expovit.model.infra.nodetypes.BooleanNodeType;
import ch.transsoft.expovit.model.infra.nodetypes.BooleanPrimitiveNodeType;
import ch.transsoft.expovit.model.infra.nodetypes.DateNodeNodeType;
import ch.transsoft.expovit.model.infra.nodetypes.DateNodeType;
import ch.transsoft.expovit.model.infra.nodetypes.DateTimeNodeType;
import ch.transsoft.expovit.model.infra.nodetypes.DecimalNodeNodeType;
import ch.transsoft.expovit.model.infra.nodetypes.DoubleNodeType;
import ch.transsoft.expovit.model.infra.nodetypes.DoublePrimitiveNodeType;
import ch.transsoft.expovit.model.infra.nodetypes.EdecDateNodeType;
import ch.transsoft.expovit.model.infra.nodetypes.EnumNodeNodeType;
import ch.transsoft.expovit.model.infra.nodetypes.EnumNodeType;
import ch.transsoft.expovit.model.infra.nodetypes.FileNodeType;
import ch.transsoft.expovit.model.infra.nodetypes.INodeType;
import ch.transsoft.expovit.model.infra.nodetypes.IntegerNodeType;
import ch.transsoft.expovit.model.infra.nodetypes.IntegerPrimitiveNodeType;
import ch.transsoft.expovit.model.infra.nodetypes.IntegralNodeNodeType;
import ch.transsoft.expovit.model.infra.nodetypes.ListNodeNodeType;
import ch.transsoft.expovit.model.infra.nodetypes.LongNodeType;
import ch.transsoft.expovit.model.infra.nodetypes.LongPrimitiveNodeType;
import ch.transsoft.expovit.model.infra.nodetypes.ModelNodeNodeType;
import ch.transsoft.expovit.model.infra.nodetypes.StringNodeNodeType;
import ch.transsoft.expovit.model.infra.nodetypes.StringNodeType;
import ch.transsoft.expovit.model.infra.nodetypes.TimestampNodeNodeType;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class NodeTypes {
    private static final Map<Class<?>, INodeType> map = new HashMap();

    public static INodeType getNodeType(Class<?> type) {
        if (Enum.class.isAssignableFrom(type)) {
            return map.get(Enum.class);
        }
        INodeType nodeType = map.get(type);
        return nodeType != null ? nodeType : NodeTypes.getSuperNodeType(type);
    }

    private static INodeType getSuperNodeType(Class<?> type) {
        Class<?> superType = type.getSuperclass();
        if (superType == null) {
            throw new IllegalStateException("No superclass exists for type: " + type.getName());
        }
        INodeType nodeType = map.get(superType);
        return nodeType != null ? nodeType : NodeTypes.getSuperNodeType(superType);
    }

    static {
        map.put(Boolean.TYPE, new BooleanPrimitiveNodeType());
        map.put(Boolean.class, new BooleanNodeType());
        map.put(Integer.TYPE, new IntegerPrimitiveNodeType());
        map.put(Integer.class, new IntegerNodeType());
        map.put(Long.TYPE, new LongPrimitiveNodeType());
        map.put(Long.class, new LongNodeType());
        map.put(Double.TYPE, new DoublePrimitiveNodeType());
        map.put(Double.class, new DoubleNodeType());
        map.put(String.class, new StringNodeType());
        map.put(Date.class, new DateNodeType());
        map.put(Enum.class, new EnumNodeType());
        map.put(ListNodeBase.class, new ListNodeNodeType());
        map.put(IntegralNode.class, new IntegralNodeNodeType());
        map.put(BooleanNode.class, new BooleanNodeNodeType());
        map.put(StringNode.class, new StringNodeNodeType());
        map.put(BinaryNode.class, new BinaryNodeNodeType());
        map.put(ModelNode.class, new ModelNodeNodeType());
        map.put(EnumNode.class, new EnumNodeNodeType());
        map.put(DateNode.class, new DateNodeNodeType());
        map.put(DateTimeNode.class, new DateTimeNodeType());
        map.put(EdecDateNode.class, new EdecDateNodeType());
        map.put(TimestampNode.class, new TimestampNodeNodeType());
        map.put(FileNode.class, new FileNodeType());
        map.put(DecimalNode.class, new DecimalNodeNodeType());
    }
}

