/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.expovit.service.app;

import ch.transsoft.expovit.service.Services;
import ch.transsoft.expovit.service.app.AppState;
import ch.transsoft.expovit.service.app.IAppChangedListener;
import ch.transsoft.expovit.service.app.IAppService;
import ch.transsoft.expovit.service.gui.IGuiService;
import ch.transsoft.expovit.util.Check;
import ch.transsoft.expovit.util.disposable.ListenerList;
import java.io.File;

public class AppService
implements IAppService {
    private final ListenerList<IAppChangedListener> listeners = new ListenerList();
    private AppState appState = AppState.newSending;
    private File currentTemplate;

    public void handleExitRequest() {
        Check.checkEDT();
        Services.get(IGuiService.class).commitCurrentEditor();
        Services.get(IGuiService.class).shutdown();
    }

    public void changeTemplateState(File template) {
        this.changeTemplateState(template, template == null ? AppState.sending : AppState.template);
    }

    private void changeTemplateState(File template, AppState appState) {
        this.currentTemplate = template;
        this.appState = appState;
        for (IAppChangedListener listener : this.listeners) {
            listener.stateChanged(appState, template);
        }
    }

    @Override
    public void saveTemplate() {
        Check.assertNotNull(this.currentTemplate, "No template open");
    }

    @Override
    public AppState getAppState() {
        return this.appState;
    }

    @Override
    public void save() {
        switch (this.getAppState()) {
            case newSending: {
                break;
            }
            case sending: {
                break;
            }
            case template: {
                this.saveTemplate();
            }
        }
    }
}

