/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.expovit.service.config;

import ch.transsoft.expovit.model.config.conf.Configuration;
import ch.transsoft.expovit.model.config.conf.PassarConfiguration;
import ch.transsoft.expovit.model.config.conf.ProxyConfiguration;
import ch.transsoft.expovit.model.config.conf.license.LicenseInfo;
import ch.transsoft.expovit.model.config.pref.PassarPreferences;
import ch.transsoft.expovit.model.config.pref.Preferences;
import ch.transsoft.expovit.model.infra.node.FileNode;
import ch.transsoft.expovit.service.Services;
import ch.transsoft.expovit.service.backend.jobs.JobUtil;
import ch.transsoft.expovit.service.config.IConfigService;
import ch.transsoft.expovit.service.config.IConfigServiceListener;
import ch.transsoft.expovit.service.masterdata.DataFiles;
import ch.transsoft.expovit.service.masterdata.IDataService;
import ch.transsoft.expovit.util.Check;
import ch.transsoft.expovit.util.disposable.IDisposable;
import ch.transsoft.expovit.util.disposable.ListenerList;
import java.io.File;
import java.io.IOException;
import java.util.Properties;

public class ConfigService
implements IConfigService {
    public static final String CONFIG = "config";
    public static final String LANGUAGE_FILE = "language.txt";
    public static final String EXPOVIT = "expovit";
    public static final String EXAMPLE_CONTENT = "ExampleContent";
    public static final String LOCK_FILE = "lock";
    public static final String VERSION_FILE = "version.txt";
    public static final String EXPORT = "export";
    public static final String IMPORT = "import";
    private final ListenerList<IConfigServiceListener> listeners = new ListenerList();
    private PassarPreferences passarPreferences;
    private Preferences edecPreferences;
    private PassarConfiguration passarConfiguration;
    private Configuration edecConfiguration;
    private ProxyConfiguration proxyConfiguration;
    private boolean useNewLocalConfigDir;

    public ConfigService() {
        this.setLocalConfigDir();
    }

    private void setLocalConfigDir() {
        File newDir = this.getRoamingDir();
        if (newDir == null) {
            this.useNewLocalConfigDir = false;
            return;
        }
        File newExpovitDir = new File(newDir, EXPOVIT);
        if (newExpovitDir.exists()) {
            this.useNewLocalConfigDir = true;
            return;
        }
        try {
            this.useNewLocalConfigDir = this.migrateLocalConfigDir(newExpovitDir);
        }
        catch (Exception e) {
            this.useNewLocalConfigDir = false;
        }
    }

    private boolean migrateLocalConfigDir(File newExpovitDir) throws IOException {
        if (!this.bestEffortMkdirs(newExpovitDir)) {
            return false;
        }
        return !this.getOldLocalConfigDir().getCanonicalPath().equals(newExpovitDir.getCanonicalPath());
    }

    @Override
    public File getLogFilePath() {
        File dir = this.getLogFolder();
        this.bestEffortMkdirs(dir);
        return new File(dir, "expovit-launcher.log");
    }

    @Override
    public File getLogFolder() {
        File configDir = this.getLocalConfigDir();
        return new File(configDir, "log");
    }

    private File getOldLocalConfigDir() {
        File result = new File(this.getUserHome(), EXPOVIT);
        this.bestEffortMkdirs(result);
        return result;
    }

    @Override
    public File getDefaultRootDir() {
        return new File(this.getLocalConfigDir(), EXAMPLE_CONTENT);
    }

    private File getRoamingDir() {
        String profile = System.getenv("APPDATA");
        if (profile == null) {
            return null;
        }
        return new File(profile);
    }

    private File getLocalConfigDir() {
        if (this.useNewLocalConfigDir) {
            return new File(this.getRoamingDir(), EXPOVIT);
        }
        return this.getOldLocalConfigDir();
    }

    @Override
    public File getLanguageFilePath() {
        return new File(this.getLocalConfigDir(), LANGUAGE_FILE);
    }

    @Override
    public String getUserName() {
        return System.getProperty("user.name");
    }

    private File getUserHome() {
        File home = new File(System.getProperty("user.home"));
        if (home.exists()) {
            return home;
        }
        return new File(System.getenv("USERPROFILE"));
    }

    @Override
    public String getVersionString() {
        try {
            Properties props = new Properties();
            props.load(this.getClass().getResourceAsStream("version.properties"));
            String version = props.getProperty("version");
            if (version == null) {
                return "<version>";
            }
            return version;
        }
        catch (Exception e) {
            return "<version>";
        }
    }

    private boolean bestEffortMkdirs(File dir) {
        return dir.mkdirs();
    }

    @Override
    public File getConfigDir(boolean readOnly) {
        return this.getDir(this.getRootDir(), CONFIG, !readOnly);
    }

    @Override
    public File getEdecConfigDir(boolean readOnly) {
        return this.getDir(this.getEdecRootDir(), CONFIG, !readOnly);
    }

    @Override
    public File getLockFilePath(IConfigService.Module module) {
        switch (module) {
            case moduleExport: {
                return new File(this.getExportDir(), LOCK_FILE);
            }
            case moduleImport: {
                return new File(this.getImportDir(), LOCK_FILE);
            }
        }
        throw new IllegalArgumentException("Unknown module: " + String.valueOf((Object)module));
    }

    @Override
    public File getVersionFilePath() {
        return new File(this.getConfigDir(false), VERSION_FILE);
    }

    public File getExportDir() {
        return this.getDir(this.getRootDir(), EXPORT, true);
    }

    public File getImportDir() {
        return this.getDir(this.getRootDir(), IMPORT, true);
    }

    @Override
    public File getRootDir() {
        File result;
        FileNode rootFolder = this.getPreferences().getRootFolder();
        if (rootFolder.isInitialized() && (result = rootFolder.getValue()).exists()) {
            return result;
        }
        return this.getDefaultRootDir();
    }

    @Override
    public File getEdecRootDir() {
        File result;
        FileNode rootFolder = this.getEdecPreferences().getRootFolder();
        if (rootFolder.isInitialized() && (result = rootFolder.getValue()).exists()) {
            return result;
        }
        return this.getDefaultRootDir();
    }

    @Override
    public File getTempDir() {
        return new File(System.getProperty("java.io.tmpdir"));
    }

    @Override
    public IDisposable add(IConfigServiceListener listener) {
        return this.listeners.add(listener);
    }

    public PassarPreferences getPreferences() {
        if (this.passarPreferences == null) {
            try {
                this.passarPreferences = Services.get(IDataService.class).readSync(DataFiles.passarPreferences);
            }
            catch (Exception e) {
                Check.fail(e, "Preferences.xml konnten nicht gelesen werden: " + String.valueOf(JobUtil.getMasterDataPath(DataFiles.edecPreferences, true)));
            }
        }
        return this.passarPreferences;
    }

    @Override
    public Preferences getEdecPreferences() {
        if (this.edecPreferences == null) {
            try {
                this.edecPreferences = Services.get(IDataService.class).readSync(DataFiles.edecPreferences);
            }
            catch (Exception e) {
                Check.fail(e, "Preferences.xml konnten nicht gelesen werden: " + String.valueOf(JobUtil.getMasterDataPath(DataFiles.edecPreferences, true)));
            }
        }
        return this.edecPreferences;
    }

    private PassarConfiguration getConfiguration() {
        if (this.passarConfiguration == null) {
            this.passarConfiguration = this.readConfiguration();
        }
        return this.passarConfiguration;
    }

    private Configuration getEdecConfiguration() {
        if (this.edecConfiguration == null) {
            this.edecConfiguration = this.readEdecConfiguration();
        }
        return this.edecConfiguration;
    }

    private PassarConfiguration readConfiguration() {
        try {
            return Services.get(IDataService.class).readSync(DataFiles.passarConfiguration);
        }
        catch (Exception e) {
            throw new RuntimeException("Die Konfiguration konnte nicht gelesen werden.", e);
        }
    }

    private Configuration readEdecConfiguration() {
        try {
            return Services.get(IDataService.class).readSync(DataFiles.edecConfiguration);
        }
        catch (Exception e) {
            throw new RuntimeException("Die Konfiguration konnte nicht gelesen werden.", e);
        }
    }

    @Override
    public LicenseInfo getEdecLicenseInfo() {
        return this.getEdecConfiguration().getLicenseInfo();
    }

    @Override
    public LicenseInfo getPassarLicenseInfo() {
        return this.getConfiguration().getLicenseInfo();
    }

    @Override
    public String getGuid() {
        return this.getEdecLicenseInfo().getGuid().getValue();
    }

    @Override
    public ProxyConfiguration getProxyConfiguration() {
        if (this.proxyConfiguration == null) {
            this.proxyConfiguration = this.readProxyConfiguration();
        }
        return this.proxyConfiguration;
    }

    private ProxyConfiguration readProxyConfiguration() {
        try {
            return Services.get(IDataService.class).readSync(DataFiles.proxySettings);
        }
        catch (Exception e) {
            throw Check.fail(e, "Die Konfiguration konnte nicht gelesen werden.");
        }
    }

    @Override
    public void saveProxyConfiguration(ProxyConfiguration proxyConfiguration) {
        this.proxyConfiguration = proxyConfiguration;
        Services.get(IDataService.class).saveMasterDataNow(proxyConfiguration);
    }

    private File getDir(File parent, String child, boolean createDir) {
        File dir = new File(parent, child);
        if (createDir) {
            this.bestEffortMkdirs(dir);
        }
        return dir;
    }
}

