/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.expovit.service.gui;

import ch.transsoft.expovit.service.gui.IGuiService;
import ch.transsoft.expovit.ui.gui.control.IInputField;
import ch.transsoft.expovit.ui.img.IconLoader;
import ch.transsoft.expovit.util.Check;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.Timer;

public class GuiService
implements IGuiService {
    private IInputField focusInputField;
    private Timer timer;
    private boolean hourGlassCursor = false;
    private JFrame frame;

    public GuiService() {
        this.startCommitTimer();
        this.addFocusListener();
    }

    public static void addIcons(Window frame) {
        ArrayList<Image> imageList = new ArrayList<Image>();
        imageList.add(IconLoader.getIcon("icon/logo/icon-32x32.png").getImage());
        imageList.add(IconLoader.getIcon("icon/logo/icon-24x24.png").getImage());
        imageList.add(IconLoader.getIcon("icon/logo/icon-16x16.png").getImage());
        frame.setIconImages(imageList);
    }

    @Override
    public JFrame getMainFrame() {
        Check.checkEDT();
        return this.frame;
    }

    private void startCommitTimer() {
        this.timer = new Timer(1000, e -> {
            Check.checkEDT();
            if (this.focusInputField == null) {
                return;
            }
            if (!this.focusInputField.isVisible()) {
                return;
            }
            this.focusInputField.save();
        });
        this.timer.setRepeats(true);
        this.timer.start();
    }

    @Override
    public void shutdown() {
        this.timer.stop();
        if (this.frame == null) {
            return;
        }
        this.frame.dispose();
        Timer timer2 = new Timer(20000, e -> System.exit(0));
        timer2.setRepeats(false);
        timer2.start();
    }

    private void addFocusListener() {
        KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        focusManager.addPropertyChangeListener(e -> {
            String prop = e.getPropertyName();
            if ("focusOwner".equals(prop) && e.getNewValue() instanceof IInputField) {
                this.focusInputField = (IInputField)e.getNewValue();
            }
        });
    }

    @Override
    public void commitCurrentEditor() {
        if (this.focusInputField != null) {
            this.focusInputField.commit();
        }
    }

    @Override
    public void setHourGlassCursor(boolean value) {
        this.hourGlassCursor = value;
        if (this.hourGlassCursor) {
            this.setHourGlassCursor();
        } else {
            this.setNormalCursor();
        }
    }

    private void setHourGlassCursor() {
        for (Window current : JFrame.getWindows()) {
            current.setCursor(Cursor.getPredefinedCursor(3));
        }
    }

    private void setNormalCursor() {
        for (Window current : JFrame.getWindows()) {
            current.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public static enum ExportTab {
        template,
        imp,
        sendingList,
        header,
        itemList,
        forms;

    }
}

