/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.expovit.service.logging;

import ch.transsoft.expovit.service.Services;
import ch.transsoft.expovit.service.config.IConfigService;
import ch.transsoft.expovit.service.logging.ILoggingService;
import ch.transsoft.expovit.service.webservices.bugreport.SendBugReportFacade;
import ch.transsoft.expovit.ui.dialog.DialogUtil;
import ch.transsoft.expovit.util.Check;
import java.io.FileNotFoundException;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class LoggingService
implements ILoggingService {
    private Logger logger;
    private FileHandler fh;

    public LoggingService() {
        try {
            this.logger = Logger.getLogger("expovit");
            this.fh = new FileHandler(this.getLogFilePath(), 1000000, 2, true);
            this.fh.setFormatter(new SimpleFormatter());
            this.logger.addHandler(this.fh);
            this.logger.setLevel(Level.ALL);
        }
        catch (Exception e) {
            this.showErrorDialog(e, "Failed to open log file: " + this.getLogFilePath(), new String[0]);
            SendBugReportFacade.send(false, e);
        }
    }

    @Override
    public void logSilentWithBugMail(Throwable t, String ... message) {
        this.logSilent(t, message);
        SendBugReportFacade.send(false, t, message);
    }

    private String getLogFilePath() {
        return Services.get(IConfigService.class).getLogFilePath().getPath();
    }

    @Override
    public synchronized void logSilent(Throwable t, String ... messages) {
        String message = Check.createMessage(messages);
        this.logger.log(Level.SEVERE, message, t);
    }

    @Override
    public synchronized void logSilent(String ... messages) {
        String message = Check.createMessage(messages);
        this.logger.log(Level.WARNING, message);
    }

    @Override
    public synchronized void logSilent(Level level, String ... message) {
        String msg = Check.createMessage(message);
        this.logger.log(level, msg);
    }

    @Override
    public synchronized void logAndReport(String title, String ... message) {
        this.showErrorDialog(title, message);
    }

    @Override
    public void logAndReport(String message) {
        this.logAndReport(Services.getText("613"), message);
    }

    @Override
    public synchronized void logAndReport(Throwable t, String ... message) {
        this.logSilent(t, message);
        this.showErrorDialog(t, Services.getText("613"), message);
        SendBugReportFacade.send(false, t, message);
    }

    private void showErrorDialog(String title, String ... message) {
        String msg = Check.createMessage(message);
        this.showErrorDialog(title, msg);
    }

    private void showErrorDialog(Throwable t, String title, String ... message) {
        String msg = Check.createMessage(message) + "\n\n" + Services.getText("615") + "\n" + LoggingService.getExceptionMessage(t);
        this.showErrorDialog(title, msg);
    }

    public static String getExceptionMessage(Throwable t) {
        StringBuilder result = new StringBuilder();
        for (Throwable current = t; current != null; current = current.getCause()) {
            if (current.getMessage() == null) continue;
            if (current instanceof FileNotFoundException) {
                result.append("File not found: ");
            }
            result.append(current.getMessage());
            result.append("\n");
        }
        String resultStr = result.toString();
        if (resultStr.isEmpty()) {
            return t.getClass().getSimpleName();
        }
        return resultStr;
    }

    private void showErrorDialog(String title, String message) {
        DialogUtil.showErrorDialog(title, message);
    }
}

