/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.expovit.service.masterdata;

import ch.transsoft.expovit.model.infra.NodeFactory;
import ch.transsoft.expovit.model.infra.XMLReader;
import ch.transsoft.expovit.model.masterdata.IDataNode;
import ch.transsoft.expovit.service.Services;
import ch.transsoft.expovit.service.backend.jobs.JobUtil;
import ch.transsoft.expovit.service.backend.jobs.SaveMasterDataJob;
import ch.transsoft.expovit.service.config.IConfigService;
import ch.transsoft.expovit.service.config.IConfigServiceListener;
import ch.transsoft.expovit.service.masterdata.IDataFile;
import ch.transsoft.expovit.service.masterdata.IDataService;
import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.Map;

public class DataService
implements IDataService {
    private final Map<IDataFile<?>, IDataNode<?>> masterDataMap = new HashMap();

    public DataService() {
        Services.get(IConfigService.class).add(new IConfigServiceListener(){

            @Override
            public void rootChanged() {
                DataService.this.masterDataMap.clear();
            }

            @Override
            public void modeChanged(boolean isDemo) {
            }

            @Override
            public void configurationChanged() {
            }
        });
    }

    @Override
    public void saveMasterDataNow(IDataNode<?> masterData) {
        try {
            new SaveMasterDataJob(masterData).execute();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T extends IDataNode<T>> T readSync(IDataFile<T> dataType) throws Exception {
        File file = JobUtil.getMasterDataPath(dataType, true);
        if (!file.exists()) {
            return (T)((IDataNode)NodeFactory.create(dataType.contentType()));
        }
        XMLReader reader = new XMLReader();
        return (T)((IDataNode)reader.read(new FileInputStream(file), dataType.contentType()));
    }
}

