/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.expovit.service.proxy;

import ch.transsoft.expovit.model.config.conf.options.ProxyInfo;
import ch.transsoft.expovit.service.Services;
import ch.transsoft.expovit.service.config.IConfigService;
import ch.transsoft.expovit.service.config.IConfigServiceListener;
import ch.transsoft.expovit.service.logging.ILoggingService;
import ch.transsoft.expovit.service.proxy.CustomProxySelector;
import ch.transsoft.expovit.service.proxy.IConnectionService;
import ch.transsoft.expovit.util.NumberUtil;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.ProxySelector;
import java.util.logging.Level;
import javax.net.ssl.SSLContext;
import nl.altindag.ssl.SSLFactory;

public class ConnectionService
implements IConnectionService {
    private final ProxySelector defaultSelector = ProxySelector.getDefault();

    @Override
    public void init() {
        this.registerListener();
        this.configureSSLContext();
        this.setProxy();
    }

    private void configureSSLContext() {
        SSLFactory sslFactory = SSLFactory.builder().withDefaultTrustMaterial().withSystemTrustMaterial().build();
        SSLContext.setDefault(sslFactory.getSslContext());
    }

    private void registerListener() {
        Services.get(IConfigService.class).add(new IConfigServiceListener(){

            @Override
            public void configurationChanged() {
                ConnectionService.this.setProxy();
            }

            @Override
            public void modeChanged(boolean isDemo) {
            }

            @Override
            public void rootChanged() {
            }
        });
    }

    private void setProxy() {
        ProxyInfo info = Services.get(IConfigService.class).getProxyConfiguration().getProxyInfo();
        if (!info.getProxyHost().isEnabled()) {
            ProxySelector.setDefault(this.defaultSelector);
        } else if (info.getProxyHost().isUserProxySet()) {
            String port = info.getProxyHost().getHttpPort().getValue();
            if (!NumberUtil.isInteger(port)) {
                Services.get(ILoggingService.class).logAndReport(Services.getText("4427") + " " + port);
                return;
            }
            String host = info.getProxyHost().getHttpHost().getValue();
            Services.get(ILoggingService.class).logSilent(Level.INFO, "Using custom proxy host: " + host + ":" + port);
            ProxySelector.setDefault(new CustomProxySelector(host, NumberUtil.parseInteger(port)));
        }
        if (info.getProxyAuth().isEnabled()) {
            String user = info.getProxyAuth().getUser().getValue();
            String password = info.getProxyAuth().getPassword().getValue();
            Authenticator.setDefault(new ProxyAuthenticator(user, password));
        } else {
            Authenticator.setDefault(null);
        }
    }

    private static class ProxyAuthenticator
    extends Authenticator {
        private final String user;
        private final String password;

        public ProxyAuthenticator(String user, String password) {
            this.user = user;
            this.password = password;
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.user, this.password.toCharArray());
        }
    }
}

