/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.expovit.service.text.internal;

import ch.transsoft.expovit.service.Services;
import ch.transsoft.expovit.service.config.IConfigService;
import ch.transsoft.expovit.service.logging.ILoggingService;
import ch.transsoft.expovit.service.text.ITextService;
import ch.transsoft.expovit.service.text.ITextServiceListener;
import ch.transsoft.expovit.util.FileUtil;
import ch.transsoft.expovit.util.disposable.ListenerList;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.jetbrains.annotations.PropertyKey;

public class TextService
implements ITextService {
    private ITextService.Language currentLanguage;
    private final ListenerList<ITextServiceListener> listeners = new ListenerList();
    public static final String BUNDLE_NAME = "ch.transsoft.expovit.service.text.translation";
    private static final String BUNDLE_PATH = "ch/transsoft/expovit/service/text.translation";
    private static final ResourceBundle translation_default = ResourceBundle.getBundle("ch/transsoft/expovit/service/text.translation", ITextService.Language.de.getLocale());
    private static final ResourceBundle translation_fr = ResourceBundle.getBundle("ch/transsoft/expovit/service/text.translation", ITextService.Language.fr.getLocale());
    private static final ResourceBundle translation_it = ResourceBundle.getBundle("ch/transsoft/expovit/service/text.translation", ITextService.Language.it.getLocale());
    private static final ResourceBundle translation_en = ResourceBundle.getBundle("ch/transsoft/expovit/service/text.translation", ITextService.Language.en.getLocale());

    public TextService() {
        this.currentLanguage = this.readCurrentLanguage();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ITextService.Language readCurrentLanguage() {
        File file = this.getLanguageFile();
        if (!file.exists()) {
            return this.getDefaultLanguage();
        }
        try (BufferedReader br = new BufferedReader(new FileReader(file));){
            String line = br.readLine();
            if (line == null) {
                ITextService.Language language = this.getDefaultLanguage();
                return language;
            }
            if (line.equals(ITextService.Language.de.name())) {
                ITextService.Language language = ITextService.Language.de;
                return language;
            }
            if (line.equals(ITextService.Language.fr.name())) {
                ITextService.Language language = ITextService.Language.fr;
                return language;
            }
            ITextService.Language language = this.getDefaultLanguage();
            return language;
        }
        catch (Exception e) {
            return ITextService.Language.de;
        }
    }

    private ITextService.Language getDefaultLanguage() {
        String lan = System.getProperty("user.language");
        if (lan == null) {
            return ITextService.Language.de;
        }
        if (lan.isEmpty()) {
            return ITextService.Language.de;
        }
        if (lan.contains("fr")) {
            return ITextService.Language.fr;
        }
        return ITextService.Language.de;
    }

    private File getLanguageFile() {
        return Services.get(IConfigService.class).getLanguageFilePath();
    }

    @Override
    public String getText(@PropertyKey(resourceBundle="ch.transsoft.expovit.service.text.translation") String id) {
        return this.getText(this.getCurrentLanguage(), id);
    }

    private ResourceBundle getBundleForLanguage(ITextService.Language language) {
        return switch (language) {
            case ITextService.Language.fr -> translation_fr;
            case ITextService.Language.it -> translation_it;
            case ITextService.Language.en -> translation_en;
            default -> translation_default;
        };
    }

    private boolean containsKey(ResourceBundle bundle, String key) {
        return ((PropertyResourceBundle)bundle).handleGetObject(key) != null;
    }

    @Override
    public String getText(ITextService.Language language, String key) {
        ResourceBundle bundle = this.getBundleForLanguage(language);
        if (this.containsKey(bundle, key)) {
            return bundle.getString(key);
        }
        if (this.availableInAtLeastOneLanguage(key)) {
            return "";
        }
        return key;
    }

    private boolean availableInAtLeastOneLanguage(String key) {
        return this.containsKey(translation_default, key) || this.containsKey(translation_fr, key) || this.containsKey(translation_it, key) || this.containsKey(translation_en, key);
    }

    @Override
    public ITextService.Language getCurrentLanguage() {
        return this.currentLanguage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveLanguage() {
        File file = this.getLanguageFile();
        FileWriter writer = null;
        try {
            writer = new FileWriter(file);
            writer.write(this.currentLanguage.name());
        }
        catch (Exception e) {
            try {
                Services.get(ILoggingService.class).logSilent(e, "Failed to save language-file");
            }
            catch (Throwable throwable) {
                FileUtil.close(writer);
                throw throwable;
            }
            FileUtil.close(writer);
        }
        FileUtil.close(writer);
    }

    @Override
    public void add(ITextServiceListener listener) {
        this.listeners.add(listener);
    }
}

