/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.expovit.ui.dialog.option.pm;

import ch.transsoft.expovit.model.config.conf.options.ProxyInfo;
import ch.transsoft.expovit.model.config.conf.options.ProxyType;
import ch.transsoft.expovit.model.config.conf.options.VmInfo;
import ch.transsoft.expovit.ui.dialog.option.pm.OptionProxyAuthPm;
import ch.transsoft.expovit.ui.dialog.option.pm.OptionVmPanelPm;
import ch.transsoft.expovit.ui.pm.model.EnabledPm;
import ch.transsoft.expovit.ui.pm.model.IPm;
import ch.transsoft.expovit.ui.pm.model.StringPm;
import ch.transsoft.expovit.util.disposable.Disposables;
import ch.transsoft.expovit.util.disposable.IDisposable;

public final class OptionDialogProxyPm
implements IPm,
IDisposable {
    private final Disposables disposables = new Disposables();
    private final ProxyInfo proxyInfo;
    private final StringPm httpHost;
    private final StringPm httpPort;
    private final EnabledPm useAuthPm;
    private final OptionProxyAuthPm authPm;
    private final OptionVmPanelPm vmPm;

    public OptionDialogProxyPm(ProxyInfo proxyInfo, VmInfo vmInfo) {
        this.proxyInfo = proxyInfo;
        this.httpHost = new StringPm(proxyInfo.getProxyHost().getHttpHost());
        this.httpPort = new StringPm(proxyInfo.getProxyHost().getHttpPort());
        this.useAuthPm = new EnabledPm(proxyInfo.getProxyAuth());
        this.authPm = new OptionProxyAuthPm(proxyInfo);
        this.vmPm = new OptionVmPanelPm(vmInfo);
    }

    public StringPm getHttpHost() {
        return this.httpHost;
    }

    public StringPm getHttpPort() {
        return this.httpPort;
    }

    @Override
    public void dispose() {
        this.disposables.dispose();
    }

    public void add(IDisposable disposable) {
        this.disposables.add(disposable);
    }

    public ProxyInfo getProxyInfo() {
        return this.proxyInfo;
    }

    public EnabledPm getUseAuthPm() {
        return this.useAuthPm;
    }

    public OptionProxyAuthPm getAuthPm() {
        return this.authPm;
    }

    public OptionVmPanelPm getVmPm() {
        return this.vmPm;
    }

    public void setSelectedProxyType(ProxyType proxyType) {
        this.proxyInfo.getProxyHost().setProxyType(proxyType);
    }

    public ProxyType getSelectedProxyType() {
        return this.proxyInfo.getProxyHost().getProxyType();
    }
}

