/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.expovit.ui.gui.control;

import ch.transsoft.expovit.service.validate.ErrorInfo;
import ch.transsoft.expovit.ui.gui.Design;
import ch.transsoft.expovit.ui.gui.control.IInputField;
import ch.transsoft.expovit.ui.pm.model.IPmListener;
import ch.transsoft.expovit.ui.pm.model.StringPm;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JPasswordField;
import javax.swing.border.LineBorder;

public class PasswordField
extends JPasswordField
implements ActionListener,
FocusListener,
IInputField {
    private StringPm model;

    public PasswordField(StringPm doc) {
        this();
        this.setModel(doc);
    }

    public PasswordField() {
        this.addAffirmListener();
        this.setBorder(new LineBorder(Design.CONTROL_BORDER, 1));
    }

    public void setModel(StringPm doc) {
        this.model = doc;
        this.setDocument(doc);
        this.setErrorState(this.model.getErrorInfo());
        this.addErrorListener();
        this.addEnableListener();
    }

    private void addEnableListener() {
        this.setEnabled(this.model.isEnabled());
        this.setEditable(this.model.isEditable());
        this.setToolTipTextIfNotEmpty(this.model.getTooltip());
        this.model.add(new IPmListener(){

            @Override
            public void enabled(boolean value) {
                PasswordField.this.setEnabled(value);
            }

            @Override
            public void editable(boolean editable, String reason) {
                PasswordField.this.setEditable(editable);
                PasswordField.this.setToolTipTextIfNotEmpty(reason);
            }
        });
    }

    private void setToolTipTextIfNotEmpty(String tooltip) {
        if (tooltip == null || tooltip.isEmpty()) {
            return;
        }
        this.setToolTipText(tooltip);
    }

    private void setErrorState(ErrorInfo info) {
        this.setToolTipText(info.message());
        if (info.hasError()) {
            this.setBackground(Design.ERROR_COLOR);
            return;
        }
        this.setNonErrorBackground();
    }

    private void setNonErrorBackground() {
        if (this.model.isMandatory()) {
            this.setBackground(Design.CONTROL_BG_MANDATORY);
        } else {
            this.setBackground(this.isEnabled() ? Design.CONTROL_BG : Design.CONTROL_BG_DISABLED);
        }
    }

    private void addErrorListener() {
        this.model.addErrorListener(this::setErrorState);
    }

    public PasswordField setReadOnly() {
        this.setReadOnly(true);
        return this;
    }

    public PasswordField setReadOnly(boolean value) {
        this.setBackground(value ? Design.CONTROL_BG_READ_ONLY : (this.model.isMandatory() ? Design.CONTROL_BG_MANDATORY : Design.CONTROL_BG));
        this.setEditable(!value);
        return this;
    }

    private void addAffirmListener() {
        this.addActionListener(this);
        this.addFocusListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.affirm();
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.affirm();
    }

    private void affirm() {
        this.model.triggerDataChanged();
    }

    @Override
    public void commit() {
        this.affirm();
    }

    @Override
    public void save() {
        if (!this.model.hasValidator()) {
            this.affirm();
        }
    }
}

