/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.expovit.ui.gui.control;

import ch.transsoft.expovit.ui.gui.control.StateAwareComboBoxModel;
import ch.transsoft.expovit.util.disposable.IDisposable;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;

public class StateAwareComboBox<E>
extends JComboBox<E> {
    private IDisposable stateListenerDisposable = null;

    public StateAwareComboBox(ComboBoxModel<E> aModel) {
        super(aModel);
    }

    @Override
    public void setModel(ComboBoxModel<E> aModel) {
        super.setModel(aModel);
        if (this.stateListenerDisposable != null) {
            this.stateListenerDisposable.dispose();
        }
        this.stateListenerDisposable = null;
        if (aModel instanceof StateAwareComboBoxModel) {
            StateAwareComboBoxModel model = (StateAwareComboBoxModel)aModel;
            this.setEnabled(model.getEnabledState());
            this.stateListenerDisposable = model.addStateListener(() -> this.setEnabled(model.getEnabledState()));
        }
    }
}

