/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.expovit.ui.img;

import ch.transsoft.expovit.util.Check;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;

public class IconLoader {
    private static final Map<String, ImageIcon> iconCache = new HashMap<String, ImageIcon>();

    public static ImageIcon getIcon(String name) {
        ImageIcon result = iconCache.get(name);
        if (result == null) {
            result = IconLoader.loadIcon(name);
            iconCache.put(name, result);
        }
        return result;
    }

    private static ImageIcon loadIcon(String name) {
        URL imageURL = IconLoader.getUrl(name);
        Check.assertNotNull(imageURL, "icon not found: ", name);
        return new ImageIcon(imageURL);
    }

    public static URL getUrl(String name) {
        return IconLoader.class.getResource(name);
    }

    public static ImageIcon getMonochromaticIcon(Color color, int width, int height) {
        String name = color.toString();
        ImageIcon result = iconCache.get(name);
        if (result == null) {
            result = IconLoader.createMonochromaticIcon(color, width, height);
            iconCache.put(name, result);
        }
        return result;
    }

    private static ImageIcon createMonochromaticIcon(Color color, int width, int height) {
        BufferedImage image = new BufferedImage(width, height, 1);
        Graphics2D graphics = image.createGraphics();
        graphics.setPaint(color);
        graphics.fillRect(0, 0, width, height);
        graphics.dispose();
        return new ImageIcon(image);
    }
}

